/*
 * Decompiled with CFR 0.152.
 */
package com.product.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class DynamicDataSourceContextHolder {
    private static final ThreadLocal<String> CONTEXT_HOLDER = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "defaultDs";
        }
    };
    public static List<Object> dataSourceKeys = new ArrayList<Object>();
    public static List<String> dataSourceIds = new ArrayList<String>();
    public static Map<Object, Object> dataSourcesMap = new ConcurrentHashMap<Object, Object>();

    public static void setRouterKey(String key) {
        CONTEXT_HOLDER.set(key);
    }

    public static void setRouterKeyIgnore(String key) {
        String routerkey = DynamicDataSourceContextHolder.getcontainDataSourceKey(key);
        if (StringUtils.isEmpty((Object)routerkey)) {
            routerkey = key;
        }
        CONTEXT_HOLDER.set(routerkey);
    }

    public static String getRouterKey() {
        return CONTEXT_HOLDER.get();
    }

    public static void clearDataSourceKey() {
        CONTEXT_HOLDER.remove();
    }

    public static boolean containDataSourceKey(String key) {
        return dataSourceKeys.contains(key);
    }

    public static String getcontainDataSourceKey(String key) {
        for (Object obj : dataSourceKeys) {
            if (!key.equalsIgnoreCase(obj.toString())) continue;
            return obj.toString();
        }
        return null;
    }

    public static List<String> getDataSourceIds() {
        return dataSourceIds;
    }

    public static void setDataSourceIds(List<String> dataSourceIds) {
        DynamicDataSourceContextHolder.dataSourceIds = dataSourceIds;
    }

    public static Map<Object, Object> getDataSourcesMap() {
        return dataSourcesMap;
    }

    public static void setDataSourcesMap(Map<Object, Object> dataSourcesMap) {
        DynamicDataSourceContextHolder.dataSourcesMap = dataSourcesMap;
    }
}

