/*
 * Decompiled with CFR 0.152.
 */
package com.product.annotation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.annotation.ReferQuery;
import com.product.annotation.ReferQueryRepeatedValues;
import com.product.component.BaseAnnotationService;
import com.product.model.ServiceSession;
import com.product.service.OperationFlag;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.TypeUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public abstract class ReferQueryImpl<T extends FMybatisTemplate>
extends BaseAnnotationService<ReferQuery> {
    private static final Logger logger = LoggerFactory.getLogger(ReferQueryImpl.class);

    protected abstract T getTemplate();

    public ReferQueryImpl() {
        super(ReferQuery.class);
    }

    private void onActionField(Object targetObject, Field field, ReferQuery referQuery, OperationFlag operFlag) throws Exception {
        String tagTable = referQuery.table();
        String tagQuery = referQuery.query();
        String tagSet = referQuery.set();
        OperationFlag[] tagFlags = referQuery.operationFlags();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        JSONObject paramsQuery = JSON.parseObject((String)tagQuery);
        JSONObject paramsSet = JSON.parseObject((String)tagSet);
        Criteria criteria = null;
        Set<String> keySet = paramsQuery.keySet();
        for (String key : keySet) {
            String keyValue;
            Iterator value = paramsQuery.get((Object)key);
            if (value != null && value instanceof String && (keyValue = (String)((Object)value)).startsWith("$")) {
                value = this.onValueGet(targetObject, keyValue.substring(1));
            }
            if (criteria == null) {
                criteria = Criteria.where((String)key).is((Object)value);
                continue;
            }
            criteria = criteria.and(key).is((Object)value);
        }
        if (criteria != null) {
            Query query = new Query(criteria);
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keySet = paramsSet.keySet();
            for (String key : keySet) {
                keyMap.put(paramsSet.getString(key), key);
                query.fields().include(paramsSet.getString(key));
            }
            T template = this.getTemplate();
            try {
                Map<String, Object> resultRow = ((FMybatisTemplate)template).selectOne(query, tagTable, 1);
                if (resultRow == null) {
                    this.printStack(logger, "ReferQueryImpl", String.format("\u6839\u636e\u67e5\u8be2\u6761\u4ef6->\u3010%1$s\u3011\u83b7\u53d6\u4e0d\u5230\u7ed3\u679c\u503c", query));
                    return;
                }
                keySet = resultRow.keySet();
                for (String key : keySet) {
                    this.onValueSet(targetObject, (String)keyMap.get(key), resultRow.get(key));
                }
            }
            catch (Exception e) {
                this.printStack(logger, "ReferQueryImpl", e, "\u8bf7\u6c42\u6570\u636e\u5e93\u6216\u5199\u5165\u53d1\u751f\u5f02\u5e38");
            }
        }
    }

    private void onActionFieldByIn(Object targetObject, Field field, ReferQuery referQuery, OperationFlag operFlag) throws Exception {
        String tagTable = referQuery.table();
        String tagQuery = referQuery.query();
        String tagSet = referQuery.set();
        OperationFlag[] tagFlags = referQuery.operationFlags();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        JSONObject paramsQuery = JSON.parseObject((String)tagQuery);
        JSONObject paramsSet = JSON.parseObject((String)tagSet);
        Criteria criteria = null;
        if (targetObject instanceof ArrayList) {
            ArrayList jsonlist = (ArrayList)targetObject;
            Set keySet = paramsQuery.keySet();
            for (String key : keySet) {
                Iterator keyValue;
                Iterator<Object> s = new HashSet();
                Object value = paramsQuery.get((Object)key);
                if (value != null && value instanceof String && ((String)((Object)(keyValue = (String)value))).startsWith("$")) {
                    for (int i = 0; i < jsonlist.size(); ++i) {
                        Object o = jsonlist.get(i);
                        value = this.onValueGet(o, ((String)((Object)keyValue)).substring(1));
                        s.add(value);
                    }
                }
                if (criteria == null) {
                    if (s.size() > 1) {
                        criteria = Criteria.where((String)key).in((Collection)((Object)s));
                        continue;
                    }
                    keyValue = s.iterator();
                    while (keyValue.hasNext()) {
                        Object o = keyValue.next();
                        criteria = Criteria.where((String)key).is(o);
                    }
                    continue;
                }
                if (s.size() > 1) {
                    criteria = criteria.and(key).in((Collection)((Object)s));
                    continue;
                }
                keyValue = s.iterator();
                while (keyValue.hasNext()) {
                    Object o = keyValue.next();
                    criteria = criteria.and(key).is(o);
                }
            }
            if (criteria != null) {
                Query query = new Query(criteria);
                HashMap<String, String> keyMap = new HashMap<String, String>();
                keySet = paramsSet.keySet();
                for (String key : keySet) {
                    keyMap.put(paramsSet.getString(key), key);
                    query.fields().include(paramsSet.getString(key));
                }
                keySet = paramsQuery.keySet();
                for (String key : keySet) {
                    query.fields().include(key);
                }
                T template = this.getTemplate();
                try {
                    List<Map<String, Object>> resultRow = ((FMybatisTemplate)template).select(query, tagTable, 1);
                    if (resultRow == null) {
                        this.printStack(logger, "ReferQueryImpl", String.format("\u6839\u636e\u67e5\u8be2\u6761\u4ef6->\u3010%1$s\u3011\u83b7\u53d6\u4e0d\u5230\u7ed3\u679c\u503c", query));
                        return;
                    }
                    this.onValueSet(targetObject, resultRow, paramsQuery, paramsSet, field);
                }
                catch (Exception e) {
                    this.printStack(logger, "ReferQueryImpl", e, "\u8bf7\u6c42\u6570\u636e\u5e93\u6216\u5199\u5165\u53d1\u751f\u5f02\u5e38");
                }
            }
        } else {
            Set<String> keySet = paramsQuery.keySet();
            for (String key : keySet) {
                String keyValue;
                Iterator value = paramsQuery.get((Object)key);
                if (value != null && value instanceof String && (keyValue = (String)((Object)value)).startsWith("$")) {
                    value = this.onValueGet(targetObject, keyValue.substring(1));
                }
                if (criteria == null) {
                    criteria = Criteria.where((String)key).is((Object)value);
                    continue;
                }
                criteria = criteria.and(key).is((Object)value);
            }
            if (criteria != null) {
                Query query = new Query(criteria);
                HashMap<String, String> keyMap = new HashMap<String, String>();
                keySet = paramsSet.keySet();
                for (String key : keySet) {
                    keyMap.put(paramsSet.getString(key), key);
                    query.fields().include(paramsSet.getString(key));
                }
                T template = this.getTemplate();
                try {
                    Map<String, Object> resultRow = ((FMybatisTemplate)template).selectOne(query, tagTable, 1);
                    if (resultRow == null) {
                        this.printStack(logger, "ReferQueryImpl", String.format("\u6839\u636e\u67e5\u8be2\u6761\u4ef6->\u3010%1$s\u3011\u83b7\u53d6\u4e0d\u5230\u7ed3\u679c\u503c", query));
                        return;
                    }
                    keySet = resultRow.keySet();
                    for (String key : keySet) {
                        this.onValueSet(targetObject, (String)keyMap.get(key), resultRow.get(key));
                    }
                }
                catch (Exception e) {
                    this.printStack(logger, "ReferQueryImpl", e, "\u8bf7\u6c42\u6570\u636e\u5e93\u6216\u5199\u5165\u53d1\u751f\u5f02\u5e38");
                }
            }
        }
    }

    public void onAction(ServiceSession session, Object targetObject, OperationFlag operFlag, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (targetObject == null) {
            this.printStack(logger, "ReferQueryImpl", "\u8bf7\u6c42\u5199\u5165\u5bf9\u8c61\u7981\u6b62\u4e3a\u7a7a");
            return;
        }
        for (Field field : fields = TypeUtils.getAllFields(beanClass)) {
            if (field.isAnnotationPresent(ReferQueryRepeatedValues.class)) {
                ReferQuery[] referQuerys;
                ReferQueryRepeatedValues referQueryRepeate = field.getAnnotation(ReferQueryRepeatedValues.class);
                for (ReferQuery referQuery : referQuerys = referQueryRepeate.value()) {
                    this.onActionField(targetObject, field, referQuery, operFlag);
                }
                continue;
            }
            if (!field.isAnnotationPresent(this.getAnnotationClass())) continue;
            ReferQuery referQuery = (ReferQuery)field.getAnnotation(this.getAnnotationClass());
            if (targetObject instanceof Map) {
                this.onActionField(targetObject, field, referQuery, operFlag);
                continue;
            }
            if (targetObject instanceof JSONObject) {
                this.onActionField(targetObject, field, referQuery, operFlag);
                continue;
            }
            if (!(targetObject instanceof List)) continue;
            this.onActionFieldByIn(targetObject, field, referQuery, operFlag);
        }
    }

    public void onValueSet(Object targetObject, List<Map<String, Object>> resultRow, JSONObject paramsQuery, JSONObject paramsSet, Field field) {
        if (targetObject instanceof ArrayList) {
            List datalist = (List)targetObject;
            Set querySet = paramsQuery.keySet();
            Set set = paramsSet.keySet();
            for (String key : set) {
                for (int i = 0; i < datalist.size(); ++i) {
                    HashMap<String, Object> referMap = new HashMap<String, Object>();
                    Object itemRow = datalist.get(i);
                    JSONObject source = (JSONObject)TypeUtils.toJSON(itemRow, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                    if (!source.containsKey((Object)field.getName())) {
                        source.put(field.getName(), (Object)"");
                    }
                    Object Value2 = null;
                    for (Map<String, Object> map : resultRow) {
                        int num = 0;
                        for (String query : querySet) {
                            String keyValue;
                            Object paramsvalue = paramsQuery.get((Object)query);
                            if (paramsvalue != null && paramsvalue instanceof String && (keyValue = (String)paramsvalue).startsWith("$")) {
                                paramsvalue = keyValue.substring(1);
                            }
                            if (String.valueOf(source.get(paramsvalue)).equals(String.valueOf(map.get(query)))) {
                                ++num;
                                continue;
                            }
                            --num;
                        }
                        if (num != paramsQuery.size()) continue;
                        Value2 = map.get(paramsSet.get((Object)key));
                    }
                    referMap.put(key, Value2);
                    if (itemRow instanceof Map) {
                        ((Map)itemRow).putAll(referMap);
                        continue;
                    }
                    BeanWrapperImpl rowBean = new BeanWrapperImpl(itemRow);
                    for (Map.Entry entry : referMap.entrySet()) {
                        rowBean.setPropertyValue((String)entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }
}

