/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.dynamicds;

import com.github.pagehelper.PageInterceptor;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FMybatisTemplate;
import java.util.List;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Aspect
@ConditionalOnProperty(prefix="dynamicsds", name={"diffdb"}, havingValue="true")
public class DataSourceDialectAspect {
    private static final Logger log = LoggerFactory.getLogger(DataSourceDialectAspect.class);

    @AfterReturning(pointcut="bean(moreStorageOperation) && execution(* com.product.storage.template.FMybatisTemplate.getSqlSessionTemplate(..))", returning="result")
    public void afterGetSqlSessionTemplate(JoinPoint joinPoint, Object result) {
        FMybatisTemplate template = (FMybatisTemplate)joinPoint.getThis();
        if (result instanceof SqlSessionTemplate) {
            List interceptors = ((SqlSessionTemplate)result).getConfiguration().getInterceptors();
            interceptors.stream().forEach(interceptor -> {
                if (interceptor instanceof PageInterceptor) {
                    Properties properties = new Properties();
                    properties.setProperty("helperDialect", template.getDBType().name().toLowerCase());
                    properties.setProperty("offsetAsPageNum", "false");
                    properties.setProperty("rowBoundsWithCount", "true");
                    properties.setProperty("pageSizeZero", "false");
                    ((PageInterceptor)interceptor).setProperties(properties);
                }
            });
        }
    }
}

