/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.template;

import com.product.storage.parser.QueryInsertExtractor;
import com.product.storage.parser.QueryRemoveExtractor;
import com.product.storage.parser.QuerySelectExtractor;
import com.product.storage.parser.QueryUpdateExtractor;
import com.product.storage.template.FMybatisTemplate;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class FStorageLogger {
    private static final Logger LOG = LogManager.getLogger(FStorageLogger.class);
    private String sqlPrintFormat = "ThreadId: %1$s ->Sql: %2$s";

    public static Logger getLog() {
        return LOG;
    }

    public void logSelectQuery(String collectionName, Query query, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QuerySelectExtractor extractor = new QuerySelectExtractor(collectionName, query, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("ThreadId: " + Thread.currentThread().getId() + "->Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logInsertQuery(String collectionName, Document dbDoc, List<Document> dbDocList, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QueryInsertExtractor extractor = dbDoc != null ? new QueryInsertExtractor(collectionName, dbDoc, FMybatisTemplate.getMyCatTag(mycatState)) : new QueryInsertExtractor(collectionName, dbDocList, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("ThreadId: " + Thread.currentThread().getId() + "->Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logUpdateQuery(String collectionName, Query query, Update update, boolean upsert, boolean multi, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QueryUpdateExtractor extractor = new QueryUpdateExtractor(collectionName, query, update, upsert, multi, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("ThreadId: " + Thread.currentThread().getId() + "->Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logDeleteQuery(String collectionName, Query query, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QueryRemoveExtractor extractor = new QueryRemoveExtractor(collectionName, query, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("ThreadId: " + Thread.currentThread().getId() + "->SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("ThreadId: " + Thread.currentThread().getId() + "->Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logSQLQuery(String sql) {
        LOG.info((Object)String.format(this.sqlPrintFormat, Thread.currentThread().getId(), sql));
    }
}

