/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.model.ExpertReponse;
import com.product.util.EncryptUtils;
import com.product.util.MD5Util;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseGenerate {
    private static final Logger loggerLicense = LoggerFactory.getLogger((String)"encryptUtilsLogger");
    private static final String sSource = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String sTarget = "012WXhi73ABCDEYZabcdOPQRSTopqrjklmn56stu4UVefgFGHIJKLMN89vwxyz";
    private static final DateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");

    public static ExpertReponse<Boolean, String> encoder(String encoderText, boolean isBase64, Date startDate, Date endDate) {
        ExpertReponse<Boolean, String> response = new ExpertReponse<Boolean, String>();
        StringBuffer buffer = new StringBuffer();
        if (startDate != null) {
            buffer.append(dateFormatter.format(startDate));
        } else {
            buffer.append("00000000");
        }
        if (endDate != null) {
            buffer.append(dateFormatter.format(endDate));
        } else {
            buffer.append("00000000");
        }
        if (isBase64) {
            encoderText = EncryptUtils.encoderBase64(encoderText);
        }
        buffer.append(encoderText);
        String encodeBefore = buffer.toString();
        String encodeAfter = EncryptUtils.encoder(encodeBefore, sSource, sTarget, false);
        loggerLicense.debug(String.format("\u52a0\u5bc6\u524d:%1$s \u52a0\u5bc6\u540e:%2$s", encodeBefore, encodeAfter));
        String responseText = EncryptUtils.reverseEncoderByStack(encodeAfter, 2);
        loggerLicense.debug(String.format("\u6362\u4f4d\u524d:%1$s \u6362\u4f4d\u540e:%2$s", encodeAfter, responseText));
        response.setCode(true);
        response.setValue(responseText);
        return response;
    }

    public static ExpertReponse<Boolean, Map<String, Object>> decoder(String license, String encodeAfter, String encoderKey, boolean isBase64, boolean withGrant, Map<String, Object> grantMap) throws ParseException, UnsupportedEncodingException {
        ExpertReponse<Boolean, Map<String, Object>> response = new ExpertReponse<Boolean, Map<String, Object>>();
        HashMap<String, Date> licenseMap = new HashMap<String, Date>();
        response.setValue(licenseMap);
        String encodedText = EncryptUtils.reverseEncoderByStack(license, 2);
        loggerLicense.debug(String.format("\u6362\u4f4d\u524d:%1$s \u6362\u4f4d\u540e:%2$s", license, encodedText));
        String originalText = EncryptUtils.decoder(encodedText, sSource, sTarget, false);
        loggerLicense.debug(String.format("\u89e3\u5bc6\u524d:%1$s \u89e3\u5bc6\u540e:%2$s", encodedText, originalText));
        String sStartDate = originalText.substring(0, 8);
        String sEndDate = originalText.substring(8, 16);
        String encoderText = originalText.substring(16);
        if (isBase64) {
            encoderText = EncryptUtils.decoderBase64(encoderText);
        }
        if (withGrant) {
            JSONObject paramsMap = JSON.parseObject((String)encoderText);
            grantMap.putAll((Map<String, Object>)paramsMap);
            if (paramsMap.containsKey((Object)encoderKey)) {
                encoderKey = paramsMap.getString(encoderKey);
            }
            List<String> skipList = Arrays.asList("grantList", encoderKey);
            grantMap.forEach((key, val) -> {
                if (!skipList.contains(key)) {
                    licenseMap.put((String)key, (Date)val);
                }
            });
        } else {
            encoderKey = encoderText;
        }
        if (encodeAfter.equals(encoderKey)) {
            if ("00000000".equals(sStartDate)) {
                sStartDate = dateFormatter.format(new Date());
            }
            if ("00000000".equals(sEndDate)) {
                sEndDate = "30000101";
            }
            Date startDate = dateFormatter.parse(sStartDate);
            Date endDate = dateFormatter.parse(sEndDate);
            licenseMap.put("startDate", startDate);
            licenseMap.put("endDate", endDate);
            response.setSuccessful(true);
            return response;
        }
        response.setError("\u8bb8\u53ef\u8bc1\u4e0d\u6b63\u786e!");
        loggerLicense.debug(String.format("start:%1$s end:%2$s check:%3$s", sStartDate, sEndDate, originalText));
        return response;
    }

    public static ExpertReponse<Boolean, String> onEncoderEnterpriseLicense(String entCode, String entName, Date startDate, Date endDate) {
        ExpertReponse<Boolean, String> response = new ExpertReponse<Boolean, String>();
        ArrayList<String> dataList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entCode)) {
            dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)entName)) {
            dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (dataList.size() > 0) {
            response.setError(String.format("\u751f\u6210\u8bb8\u53ef\u8bc1:%1$s", String.join((CharSequence)",", dataList)));
            return response;
        }
        String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
        String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
        response = LicenseGenerate.encoder(encodeAfter, false, startDate, endDate);
        return response;
    }

    public static ExpertReponse<Date, Date> onDecoderEnterpriseLicense(String entCode, String entName, String license) throws UnsupportedEncodingException {
        ExpertReponse<Date, Date> response = new ExpertReponse<Date, Date>();
        try {
            ArrayList<String> dataList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)entCode)) {
                dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)entName)) {
                dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)license)) {
                dataList.add("\u8bb8\u53ef\u8bc1\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (dataList.size() > 0) {
                response.setError(String.format("\u6821\u9a8c\u8bb8\u53ef\u8bc1:%1$s \u5f02\u5e38", String.join((CharSequence)",", dataList)));
                return response;
            }
            String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
            String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
            ExpertReponse<Boolean, Map<String, Object>> decoderMap = LicenseGenerate.decoder(license, encodeAfter, null, false, false, null);
            if (decoderMap.isSuccessful()) {
                response.setCode((Date)decoderMap.getValue().get("startDate"));
                response.setValue((Date)decoderMap.getValue().get("endDate"));
            } else {
                response.setError(decoderMap.getLastError());
            }
        }
        catch (ParseException pe) {
            response.setError("\u4ea7\u54c1\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        return response;
    }

    public static <T> ExpertReponse<Boolean, String> onEncoderModuleLicense(String entCode, String entName, String contNo, String productCode, String productName, Integer licenseType, List<T> moduleCodeList, Date startDate, Date endDate) {
        ExpertReponse<Boolean, String> response = new ExpertReponse<Boolean, String>();
        ArrayList<String> dataList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entCode)) {
            dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)entName)) {
            dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)productCode)) {
            dataList.add("\u4ea7\u54c1\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)productName)) {
            dataList.add("\u4ea7\u54c1\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (dataList.size() > 0) {
            response.setError(String.format("\u751f\u6210\u8bb8\u53ef\u8bc1:%1$s", String.join((CharSequence)",", dataList)));
            return response;
        }
        String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
        String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
        StringBuffer buffer = new StringBuffer();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("licenseType", licenseType);
        paramsMap.put("contno", contNo);
        paramsMap.put("productCode", productCode);
        paramsMap.put("productName", productName);
        paramsMap.put("grantList", moduleCodeList);
        paramsMap.put("encodeText", encodeAfter);
        buffer.append(JSON.toJSONString(paramsMap));
        response = LicenseGenerate.encoder(buffer.toString(), true, startDate, endDate);
        return response;
    }

    public static <T> ExpertReponse<Boolean, Map<String, Object>> onDecoderModuleLicense(String entCode, String entName, String license, List<T> grantList) throws UnsupportedEncodingException {
        ExpertReponse<Boolean, Map<String, Object>> response = new ExpertReponse<Boolean, Map<String, Object>>();
        try {
            HashMap<String, Object> grantMap;
            ArrayList<String> dataList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)entCode)) {
                dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)entName)) {
                dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)license)) {
                dataList.add("\u8bb8\u53ef\u8bc1\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (dataList.size() > 0) {
                response.setError(String.format("\u6821\u9a8c\u8bb8\u53ef\u8bc1:%1$s \u5f02\u5e38", String.join((CharSequence)",", dataList)));
                return response;
            }
            String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
            String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
            response = LicenseGenerate.decoder(license, encodeAfter, "encodeText", true, true, grantMap = new HashMap<String, Object>());
            if (response.isSuccessful()) {
                grantList.addAll((List)grantMap.get("grantList"));
            }
        }
        catch (ParseException pe) {
            response.setError("\u4ea7\u54c1\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        return response;
    }

    public static <T> ExpertReponse<Boolean, String> onEncoderShopLicense(String entCode, String entName, String productCode, String erpCode, Integer licenseType, List<T> shopCodeList, Date startDate, Date endDate) {
        ExpertReponse<Boolean, String> response = new ExpertReponse<Boolean, String>();
        ArrayList<String> dataList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entCode)) {
            dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)entName)) {
            dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)productCode)) {
            dataList.add("\u4ea7\u54c1\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (dataList.size() > 0) {
            response.setError(String.format("\u751f\u6210\u8bb8\u53ef\u8bc1:%1$s", String.join((CharSequence)",", dataList)));
            return response;
        }
        String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
        String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
        StringBuffer buffer = new StringBuffer();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("productCode", productCode);
        paramsMap.put("identify", "market");
        paramsMap.put("erpCode", erpCode);
        paramsMap.put("licenseType", licenseType);
        paramsMap.put("grantList", shopCodeList);
        paramsMap.put("encodeText", encodeAfter);
        if (licenseType == 1) {
            paramsMap.put("encodeGuid", UUID.randomUUID());
        }
        buffer.append(JSON.toJSONString(paramsMap));
        response = LicenseGenerate.encoder(buffer.toString(), true, startDate, endDate);
        return response;
    }

    public static <T> ExpertReponse<Boolean, Map<String, Object>> onDecoderShopLicense(String entCode, String entName, String license, List<T> grantList) throws UnsupportedEncodingException {
        ExpertReponse<Boolean, Map<String, Object>> response = new ExpertReponse<Boolean, Map<String, Object>>();
        try {
            HashMap<String, Object> grantMap;
            ArrayList<String> dataList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)entCode)) {
                dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)entName)) {
                dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)license)) {
                dataList.add("\u8bb8\u53ef\u8bc1\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (dataList.size() > 0) {
                response.setError(String.format("\u6821\u9a8c\u8bb8\u53ef\u8bc1:%1$s \u5f02\u5e38", String.join((CharSequence)",", dataList)));
                return response;
            }
            String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
            String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
            response = LicenseGenerate.decoder(license, encodeAfter, "encodeText", true, true, grantMap = new HashMap<String, Object>());
            if (response.isSuccessful()) {
                grantList.addAll((List)grantMap.get("grantList"));
                if (!grantMap.containsKey("identify")) {
                    response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u65b0\u7248\u8bb8\u53ef\u8bc1!");
                } else if (!"market".equals(grantMap.get("identify"))) {
                    response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
                }
            }
        }
        catch (ParseException pe) {
            response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        return response;
    }

    public static <T> ExpertReponse<Boolean, String> onEncoderTerminalLicense(String entCode, String entName, String productCode, String erpCode, Integer licenseType, List<T> terminalCodeList, Date startDate, Date endDate) {
        ExpertReponse<Boolean, String> response = new ExpertReponse<Boolean, String>();
        ArrayList<String> dataList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entCode)) {
            dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)entName)) {
            dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)productCode)) {
            dataList.add("\u4ea7\u54c1\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (dataList.size() > 0) {
            response.setError(String.format("\u751f\u6210\u8bb8\u53ef\u8bc1:%1$s", String.join((CharSequence)",", dataList)));
            return response;
        }
        String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
        String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
        StringBuffer buffer = new StringBuffer();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("productCode", productCode);
        paramsMap.put("identify", "terminal");
        paramsMap.put("erpCode", erpCode);
        paramsMap.put("licenseType", licenseType);
        paramsMap.put("grantList", terminalCodeList);
        paramsMap.put("encodeText", encodeAfter);
        paramsMap.put("encodeGuid", UUID.randomUUID());
        buffer.append(JSON.toJSONString(paramsMap));
        response = LicenseGenerate.encoder(buffer.toString(), true, startDate, endDate);
        return response;
    }

    public static <T> ExpertReponse<Boolean, Map<String, Object>> onDecoderTerminalLicense(String entCode, String entName, String license, List<T> grantList) throws UnsupportedEncodingException {
        ExpertReponse<Boolean, Map<String, Object>> response = new ExpertReponse<Boolean, Map<String, Object>>();
        try {
            HashMap<String, Object> grantMap;
            ArrayList<String> dataList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)entCode)) {
                dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)entName)) {
                dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)license)) {
                dataList.add("\u8bb8\u53ef\u8bc1\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (dataList.size() > 0) {
                response.setError(String.format("\u6821\u9a8c\u8bb8\u53ef\u8bc1:%1$s \u5f02\u5e38", String.join((CharSequence)",", dataList)));
                return response;
            }
            String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
            String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
            response = LicenseGenerate.decoder(license, encodeAfter, "encodeText", true, true, grantMap = new HashMap<String, Object>());
            if (response.isSuccessful()) {
                grantList.addAll((List)grantMap.get("grantList"));
                if (!grantMap.containsKey("identify")) {
                    response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u65b0\u7248\u8bb8\u53ef\u8bc1!");
                } else if (!"terminal".equals(grantMap.get("identify"))) {
                    response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
                }
            }
        }
        catch (ParseException pe) {
            loggerLicense.info("\u89e3\u6790\u8bb8\u53ef\u8bc1\u5931\u8d25:{}", (Object)pe.getMessage(), (Object)pe);
            response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        catch (Exception e) {
            loggerLicense.info("\u89e3\u6790\u8bb8\u53ef\u8bc1\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        return response;
    }

    public static <T> ExpertReponse<Boolean, String> onEncoderPartnerLicense(String entCode, String entName, String productCode, List<T> partnerList, Date startDate, Date endDate) {
        ExpertReponse<Boolean, String> response = new ExpertReponse<Boolean, String>();
        ArrayList<String> dataList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entCode)) {
            dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)entName)) {
            dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)productCode)) {
            dataList.add("\u4ea7\u54c1\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (dataList.size() > 0) {
            response.setError(String.format("\u751f\u6210\u8bb8\u53ef\u8bc1:%1$s", String.join((CharSequence)",", dataList)));
            return response;
        }
        String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
        String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
        StringBuffer buffer = new StringBuffer();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("productCode", productCode);
        paramsMap.put("grantList", partnerList);
        paramsMap.put("encodeText", encodeAfter);
        buffer.append(JSON.toJSONString(paramsMap));
        response = LicenseGenerate.encoder(buffer.toString(), true, startDate, endDate);
        return response;
    }

    public static <T> ExpertReponse<Boolean, Map<String, Object>> onDecoderPartnerLicense(String entCode, String entName, String license, List<T> grantList) throws UnsupportedEncodingException {
        ExpertReponse<Boolean, Map<String, Object>> response = new ExpertReponse<Boolean, Map<String, Object>>();
        try {
            HashMap<String, Object> grantMap;
            ArrayList<String> dataList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)entCode)) {
                dataList.add("\u4f01\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)entName)) {
                dataList.add("\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)license)) {
                dataList.add("\u8bb8\u53ef\u8bc1\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (dataList.size() > 0) {
                response.setError(String.format("\u6821\u9a8c\u8bb8\u53ef\u8bc1:%1$s \u5f02\u5e38", String.join((CharSequence)",", dataList)));
                return response;
            }
            String encodeBefore = String.format("%1$s#%2$s", entCode, entName);
            String encodeAfter = MD5Util.getInstance().md5(encodeBefore);
            response = LicenseGenerate.decoder(license, encodeAfter, "encodeText", true, true, grantMap = new HashMap<String, Object>());
            if (response.isSuccessful()) {
                grantList.addAll((List)grantMap.get("grantList"));
            }
        }
        catch (ParseException pe) {
            response.setError("\u8bb8\u53ef\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        return response;
    }
}

