/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.component.BatchBaseService;
import com.product.component.BeanField;
import com.product.exception.ServiceException;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.TypeUtils;
import com.shiji.core.util.ReflectUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="batchuptservice")
public class BatchUptService
extends BatchBaseService {
    @Value(value="${batchinsert.batch_rows:1000}")
    private int BATCH_ROWS = 1000;

    public <T> int batchUpdate(FMybatisTemplate storage, Class<?> objClass, List<T> lists, String tableName, String keyFieldName) throws Exception {
        List fields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        Set<BeanField> beanFields = this.transform(fields);
        return this.batchUpdateFields(storage, beanFields, lists, tableName, keyFieldName);
    }

    public <T> int batchUpdate(FMybatisTemplate storage, Class<?> objClass, Set<String> fields, List<T> lists, String tableName, String keyFieldName) throws Exception {
        List allBeanFields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        List<Field> fieldList = this.filter(allBeanFields, fields);
        Set<BeanField> beanFields = this.transform(fieldList);
        return this.batchUpdateFields(storage, beanFields, lists, tableName, keyFieldName);
    }

    public <T> int batchUpdateFields(FMybatisTemplate storage, Set<BeanField> beanFields, List<T> lists, String tableName, String keyFieldName) throws Exception {
        if (StringUtils.isEmpty(lists) || lists.isEmpty()) {
            return 0;
        }
        if (StringUtils.isEmpty(beanFields) || beanFields.isEmpty()) {
            return 0;
        }
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new ServiceException("5000", "unsupport DBMS Type!", new Object[0]);
        }
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("UPDATE ").append(tableName).append(" set ");
        for (BeanField col : beanFields) {
            if (!lists.stream().anyMatch(e -> TypeUtils.toJSONObj((Object)e, (boolean)false, (SerializerFeature[])new SerializerFeature[0]).containsKey((Object)col.getColName()))) continue;
            tabsql.append(col.getColName()).append(" = CASE ").append(keyFieldName);
            for (int i = 0; i < lists.size(); ++i) {
                T bean = lists.get(i);
                JSONObject rowjson = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                if (!rowjson.containsKey((Object)keyFieldName)) continue;
                tabsql.append(" WHEN ");
                if (rowjson.get((Object)keyFieldName) instanceof Long || rowjson.get((Object)keyFieldName) instanceof Integer) {
                    tabsql.append(rowjson.get((Object)keyFieldName));
                } else {
                    tabsql.append(" '").append(rowjson.get((Object)keyFieldName)).append("' ");
                }
                tabsql.append(" THEN ").append(this.getColData(dbtype, rowjson.get((Object)col.getColName()), col.getColType()));
            }
            tabsql.append(" END ").append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(" where ").append(keyFieldName).append(" in (");
        List keys = lists.stream().map(p -> TypeUtils.toJSONObj((Object)p, (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)keyFieldName).toString()).collect(Collectors.toList());
        tabsql.append(keys.stream().collect(Collectors.joining(",")));
        tabsql.append(")");
        return db.update("mybatis.sql.update", tabsql.toString());
    }
}

