/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.product.component.AbstractData;
import com.product.component.DataCompareCallback;
import com.product.component.DataWriter;
import com.product.component.IndexBlock;
import com.product.util.MD5Util;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReader
extends AbstractData {
    private Map<Integer, List<IndexBlock>> indexMap = new HashMap<Integer, List<IndexBlock>>();
    private static final Logger logger = LoggerFactory.getLogger(AbstractData.class);

    public DataReader(String dataFilename, String indexFilename, Integer modSize, Integer batchSize, String ... fieldName) throws IOException {
        super(dataFilename, indexFilename, modSize, batchSize, false, fieldName);
        this.onIndexReader();
    }

    public List<Integer> getHashList() {
        return this.indexMap.keySet().stream().collect(Collectors.toList());
    }

    protected void onIndexReader() throws IOException {
        long fileSize = this.getIndexChannel().size();
        long blockCount = fileSize / (long)this.BLOCK_SIZE.intValue();
        blockCount = blockCount * 100L < fileSize ? blockCount + 1L : blockCount;
        for (long i = 0L; i < blockCount; ++i) {
            ByteBuffer bufferReader = ByteBuffer.allocate(this.BLOCK_SIZE);
            this.getIndexChannel().position(i * (long)this.BLOCK_SIZE.intValue());
            this.getIndexChannel().read(bufferReader);
            bufferReader.flip();
            String contentReader = this.CHARSET.decode(bufferReader).toString().trim();
            IndexBlock dataIdx = (IndexBlock)JSON.parseObject((String)contentReader, IndexBlock.class);
            List<Object> indexList = null;
            if (this.indexMap.containsKey(dataIdx.getHashCode())) {
                indexList = this.indexMap.get(dataIdx.getHashCode());
            } else {
                indexList = new ArrayList();
                this.indexMap.put(dataIdx.getHashCode(), indexList);
            }
            indexList.add(dataIdx);
        }
    }

    public Map<String, Map<String, Object>> onBlockReader(Integer hashCode) throws IOException {
        HashMap<String, Map<String, Object>> responseMap = new HashMap<String, Map<String, Object>>();
        if (this.indexMap.containsKey(hashCode)) {
            List<IndexBlock> indexList = this.indexMap.get(hashCode);
            for (IndexBlock dataIdx : indexList) {
                this.getDataChannel().position(dataIdx.getStartIdx());
                int dataSize = Integer.valueOf(Long.toString(dataIdx.getEndIdx() - dataIdx.getStartIdx()));
                ByteBuffer dataBuffer = ByteBuffer.allocate(dataSize);
                this.getDataChannel().read(dataBuffer);
                dataBuffer.flip();
                String params = this.CHARSET.decode(dataBuffer).toString();
                Map paramsMap = null;
                try {
                    paramsMap = (Map)JSON.parseObject((String)params, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(this){}, (Feature[])new Feature[0]);
                }
                catch (Exception e) {
                    logger.error("onBlockReader:{} error:{}", new Object[]{params, e.getMessage(), e});
                }
                responseMap.putAll(paramsMap);
            }
        }
        return responseMap;
    }

    public List<Map<String, Object>> onIntersect(DataReader dataReader, Integer hashCode) throws IOException {
        DataReader self = this;
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        Map<String, Map<String, Object>> dataMap1 = this.onBlockReader(hashCode);
        Map<String, Map<String, Object>> dataMap2 = dataReader.onBlockReader(hashCode);
        Map md5Map1 = dataMap1.values().stream().collect(HashMap::new, (m, v) -> m.put(self.getDataKey((Map<String, Object>)v), MD5Util.getInstance().md5(JSON.toJSONString((Object)v))), HashMap::putAll);
        Map md5Map2 = dataMap2.values().stream().collect(HashMap::new, (m, v) -> m.put(dataReader.getDataKey((Map<String, Object>)v), MD5Util.getInstance().md5(JSON.toJSONString((Object)v))), HashMap::putAll);
        List intersectKeyList = md5Map1.keySet().stream().filter(key -> md5Map2.containsKey(key)).collect(Collectors.toList());
        intersectKeyList.stream().forEach(action -> response.add((Map)dataMap1.get(action)));
        return response;
    }

    public List<Map<String, Object>> onIntersect(DataReader dataReader) throws IOException {
        DataReader self = this;
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        List<Integer> hashList1 = this.getHashList();
        List<Integer> hashList2 = dataReader.getHashList();
        List<Integer> intersectHashList = hashList1.stream().filter(key -> hashList2.contains(key)).collect(Collectors.toList());
        intersectHashList.forEach(hashCode -> {
            try {
                response.addAll(self.onIntersect(dataReader, (Integer)hashCode));
            }
            catch (Exception e) {
                logger.error("onIntersect error:{}", (Object)e.getMessage(), (Object)e);
            }
        });
        return response;
    }

    public List<Map<String, Object>> onMinus(DataReader dataReader, Integer hashCode, DataCompareCallback callback) throws IOException {
        DataReader self = this;
        ArrayList<Map<String, Object>> responseUpdate = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> responseInsert = new ArrayList<Map<String, Object>>();
        Map<String, Map<String, Object>> dataMap1 = this.onBlockReader(hashCode);
        Map<String, Map<String, Object>> dataMap2 = dataReader.onBlockReader(hashCode);
        Map md5Map1 = dataMap1.values().stream().collect(HashMap::new, (m, v) -> m.put(self.getDataKey((Map<String, Object>)v), MD5Util.getInstance().md5(JSON.toJSONString((Object)v))), HashMap::putAll);
        Map md5Map2 = dataMap2.values().stream().collect(HashMap::new, (m, v) -> m.put(dataReader.getDataKey((Map<String, Object>)v), MD5Util.getInstance().md5(JSON.toJSONString((Object)v))), HashMap::putAll);
        List updateKeyList = md5Map1.keySet().stream().filter(key -> md5Map1.containsKey(key) && md5Map2.containsKey(key) && !((String)md5Map2.get(key)).equals(md5Map1.get(key))).collect(Collectors.toList());
        List insertKeyList = md5Map1.keySet().stream().filter(key -> !md5Map2.containsKey(key)).collect(Collectors.toList());
        updateKeyList.stream().forEach(action -> responseUpdate.add((Map)dataMap1.get(action)));
        insertKeyList.stream().forEach(action -> responseInsert.add((Map)dataMap1.get(action)));
        if (callback != null) {
            callback.onUpdate(responseUpdate);
            callback.onInsert(responseInsert);
        }
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        response.addAll(responseUpdate);
        response.addAll(responseInsert);
        return response;
    }

    public List<Map<String, Object>> onMinus(DataReader dataReader, DataCompareCallback callback) throws IOException {
        DataReader self = this;
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        List<Integer> hashList1 = this.getHashList();
        List<Integer> hashList2 = dataReader.getHashList();
        List<Integer> intersectHashList = hashList1.stream().filter(key -> hashList2.contains(key)).collect(Collectors.toList());
        List<Integer> minusHashList = hashList1.stream().filter(key -> !hashList2.contains(key)).collect(Collectors.toList());
        intersectHashList.forEach(hashCode -> {
            try {
                List<Map<String, Object>> dataList = self.onMinus(dataReader, (Integer)hashCode, callback);
                response.addAll(dataList);
            }
            catch (Exception e) {
                logger.error("onMinus error:{}", (Object)e.getMessage(), (Object)e);
            }
        });
        minusHashList.forEach(hashCode -> {
            try {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
                dataList.addAll(self.onBlockReader((Integer)hashCode).values());
                response.addAll(dataList);
                if (callback != null) {
                    callback.onInsert(dataList);
                }
            }
            catch (IOException e) {
                logger.error("onMinus error:{}", (Object)e.getMessage(), (Object)e);
            }
        });
        return response;
    }

    public void onUnion(DataReader dataReader, DataWriter dataWriter, Writer logWriter) throws IOException {
        DataReader self = this;
        List<Integer> hashList1 = this.getHashList();
        List<Integer> hashList2 = dataReader.getHashList();
        List<Integer> minusHashList1 = hashList1.stream().filter(key -> !hashList2.contains(key)).collect(Collectors.toList());
        List<Integer> minusHashList2 = hashList2.stream().filter(key -> !hashList1.contains(key)).collect(Collectors.toList());
        List<Integer> intersectHashList = hashList1.stream().filter(key -> hashList2.contains(key)).collect(Collectors.toList());
        if (logWriter != null) {
            logWriter.write("minus 1 \r\n");
        }
        ArrayList<Map<String, Object>> response1 = new ArrayList<Map<String, Object>>();
        minusHashList1.forEach(hashCode -> {
            try {
                Map<String, Map<String, Object>> dataMap = self.onBlockReader((Integer)hashCode);
                if (dataMap.size() > 0) {
                    Collection<Map<String, Object>> valueList = dataMap.values();
                    response1.addAll(valueList);
                    if (logWriter != null) {
                        for (Map<String, Object> rowMap : valueList) {
                            logWriter.write(String.format("%1$s\r\n", JSON.toJSONString(rowMap)));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("onUnion error:{}", (Object)e.getMessage(), (Object)e);
            }
        });
        dataWriter.onAppend(response1);
        if (logWriter != null) {
            logWriter.write("minus 2 \r\n");
        }
        ArrayList<Map<String, Object>> response2 = new ArrayList<Map<String, Object>>();
        minusHashList2.forEach(hashCode -> {
            try {
                Map<String, Map<String, Object>> dataMap = dataReader.onBlockReader((Integer)hashCode);
                if (dataMap.size() > 0) {
                    Collection<Map<String, Object>> valueList = dataMap.values();
                    response2.addAll(valueList);
                    if (logWriter != null) {
                        for (Map<String, Object> rowMap : valueList) {
                            logWriter.write(String.format("%1$s\r\n", JSON.toJSONString(rowMap)));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("onUnion error:{}", (Object)e.getMessage(), (Object)e);
            }
        });
        dataWriter.onAppend(response2);
        if (logWriter != null) {
            logWriter.write("update 3 \r\n");
        }
        ArrayList responseOriginal = new ArrayList();
        final ArrayList responseUpdate = new ArrayList();
        final ArrayList responseInsert = new ArrayList();
        intersectHashList.forEach(hashCode -> {
            try {
                Map<String, Map<String, Object>> dataMaps = dataReader.onBlockReader((Integer)hashCode);
                responseOriginal.addAll(dataMaps.values());
                this.onMinus(dataReader, (Integer)hashCode, new DataCompareCallback(){

                    @Override
                    public void onUpdate(List<Map<String, Object>> dataList) {
                        if (dataList.size() > 0) {
                            responseUpdate.addAll(dataList);
                        }
                    }

                    @Override
                    public void onInsert(List<Map<String, Object>> dataList) {
                        if (dataList.size() > 0) {
                            responseInsert.addAll(dataList);
                        }
                    }
                });
            }
            catch (IOException e) {
                logger.error("onUnion error:{}", (Object)e.getMessage(), (Object)e);
            }
        });
        if (logWriter != null) {
            try {
                logWriter.write("Original row \r\n");
                for (Map rowMap : responseOriginal) {
                    logWriter.write(String.format("%1$s\r\n", JSON.toJSONString((Object)rowMap)));
                }
                logWriter.write("Update row \r\n");
                for (Map rowMap : responseUpdate) {
                    logWriter.write(String.format("%1$s\r\n", JSON.toJSONString((Object)rowMap)));
                }
                logWriter.write("Insert row \r\n");
                for (Map rowMap : responseInsert) {
                    logWriter.write(String.format("%1$s\r\n", JSON.toJSONString((Object)rowMap)));
                }
            }
            catch (Exception e) {
                logger.error("onUnion error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        response.addAll(responseOriginal);
        response.addAll(responseUpdate);
        response.addAll(responseInsert);
        dataWriter.onAppend(response);
    }
}

