/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.globrule;

import com.alibaba.fastjson.JSONObject;
import com.product.annotation.redis.CacheLock;
import com.product.annotation.redis.CacheParam;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.component.globrule.GlobRuleModel;
import com.product.component.globrule.GlobRuleSrv;
import com.product.component.globrule.INORule;
import com.product.component.globrule.MappedRuleImpl;
import com.product.exception.ServiceException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.ParamValidateUtil;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class GlobRuleSrvimpl
extends JDBCCompomentServiceImpl<GlobRuleModel>
implements GlobRuleSrv,
ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(GlobRuleSrvimpl.class);
    public Map<String, INORule> ruleHandles = new HashMap<String, INORule>();
    ApplicationContext applicationContext;

    public GlobRuleSrvimpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "globrule", "ruleId");
    }

    public static GlobRuleSrv getInstance() {
        return (GlobRuleSrv)SpringContext.getContext().getBean(GlobRuleSrv.class);
    }

    @Override
    @CacheLock(prefix="globrule")
    public long getlast(@CacheParam long entId, @CacheParam String ruleId, @CacheParam String ruleTypeStr, String datestr, long keynum) {
        String globruledet = "globruledet";
        long startseqno = 0L;
        long endseqno = 0L;
        Criteria criteria = Criteria.where((String)"entId").is((Object)entId).and("ruleId").is((Object)ruleId).and("ruleTypeStr").is((Object)ruleTypeStr);
        Query query = new Query((CriteriaDefinition)criteria);
        Map<String, Object> map = this.getTemplate().selectOne(query, globruledet);
        if (map != null) {
            if (!StringUtils.isEmpty((Object)datestr) && !datestr.equals(MapUtils.getString(map, (Object)"ruleTypeDay"))) {
                endseqno = keynum;
            } else {
                startseqno = MapUtils.getLongValue(map, (Object)"ruleCurSeqno");
                endseqno = startseqno + keynum;
            }
            Update upt = new Update();
            upt.set("ruleCurSeqno", (Object)String.valueOf(endseqno));
            upt.set("ruleTypeDay", (Object)datestr);
            this.getTemplate().update(query, upt, globruledet);
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("entId", entId);
            data.put("ruleId", ruleId);
            data.put("ruleTypeStr", ruleTypeStr);
            endseqno = keynum;
            data.put("ruleCurSeqno", String.valueOf(endseqno));
            data.put("ruleTypeDay", datestr);
            this.getTemplate().insert(data, globruledet);
        }
        return startseqno;
    }

    @Override
    public long getnext(long entId, String ruleId, String ruleTypeStr, String dateStr) {
        return GlobRuleSrvimpl.getInstance().getlast(entId, ruleId, ruleTypeStr, dateStr, 1L) + 1L;
    }

    @Override
    public GlobRuleModel getrule(long entId, String ruleid) throws Exception {
        Criteria criteria = Criteria.where((String)"entId").is((Object)entId).and("ruleid").is((Object)ruleid);
        Query query = new Query((CriteriaDefinition)criteria);
        String globruled = "globrule";
        GlobRuleModel rule = this.getTemplate().selectOne(query, GlobRuleModel.class, "globrule");
        if (rule == null) {
            throw new ServiceException("90001", "\u6ca1\u6709\u627e\u5230\u7f16\u7801\u89c4\u5219[{0}]", new Object[]{ruleid});
        }
        return rule;
    }

    @Override
    public ServiceResponse getRuleDef(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject jsonrtn = new JSONObject();
        ServiceResponse check = ParamValidateUtil.checkParam(session, jsonparam, "ruleId");
        if (!check.getReturncode().equals("0")) {
            return check;
        }
        String ruleId = jsonparam.getString("ruleId");
        GlobRuleModel globrule = GlobRuleSrvimpl.getInstance().getrule(session.getEnt_id(), jsonparam.getString("ruleid"));
        jsonrtn.put("globrule", (Object)globrule);
        return ServiceResponse.buildSuccess((Object)jsonrtn);
    }

    @Override
    public ServiceResponse getRuleList(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject jsonrtn = new JSONObject();
        ServiceResponse check = ParamValidateUtil.checkParam(session, jsonparam, "ruleId");
        if (!check.getReturncode().equals("0")) {
            return check;
        }
        String ruleId = jsonparam.getString("ruleId");
        String[] rules = ruleId.split(",");
        ArrayList<GlobRuleModel> ruleList = new ArrayList<GlobRuleModel>();
        for (String rid : rules) {
            GlobRuleModel globrule = GlobRuleSrvimpl.getInstance().getrule(session.getEnt_id(), rid);
            if (globrule == null) continue;
            ruleList.add(globrule);
        }
        jsonrtn.put("globrule", ruleList);
        return ServiceResponse.buildSuccess((Object)jsonrtn);
    }

    private INORule getRuleHandle(String ruleCode) {
        INORule handle = this.ruleHandles.get(ruleCode);
        if (handle == null) {
            handle = new MappedRuleImpl();
        }
        return handle;
    }

    public void getRuleCodeTemplate(GlobRuleModel rule) throws Exception {
        String prestr = rule.getPreStr();
        String level = rule.getLevelStr();
        Map<String, Object> keys = rule.getKeys();
        String[] ruledefs = rule.getRuleDef().split("\\|");
        StringBuilder ruleCodeStr = new StringBuilder();
        StringBuilder ruleTypeStr = new StringBuilder();
        if (keys == null) {
            keys = new HashMap<String, Object>();
        }
        if (keys.get("NOW") == null) {
            keys.put("NOW", new Date());
        }
        if (!StringUtils.isEmpty((Object)prestr)) {
            ruleTypeStr.append(prestr);
            keys.put("PRESTR", prestr);
        } else {
            prestr = "#";
        }
        if (!StringUtils.isEmpty((Object)level)) {
            keys.put("LEVEL", level);
        } else {
            level = "#";
        }
        String DateStr = null;
        if (rule.getRuleIsRule().equalsIgnoreCase("L")) {
            if (!StringUtils.isEmpty((Object)prestr) && !prestr.equalsIgnoreCase("#")) {
                ruleCodeStr.append(prestr);
            }
            ruleCodeStr.append("#SEQ");
            String[] levels = rule.getRuleDef().toString().split("\\-");
            int prelevel = 0;
            int seqlen = 0;
            for (int i = 0; i < levels.length; ++i) {
                if (i + 1 == Integer.parseInt(level)) {
                    seqlen = Integer.parseInt(levels[i]);
                    break;
                }
                prelevel += Integer.parseInt(levels[i]);
            }
            seqlen = seqlen + ruleCodeStr.length() - 4;
            rule.setRuleSysLen(seqlen);
            rule.setRuleTypeDay("");
            rule.setRuleCodeStr(ruleCodeStr.toString());
            rule.setRuleTypeStr(ruleTypeStr.toString());
            return;
        }
        for (String def : ruledefs) {
            if ("#SEQ".equalsIgnoreCase(def)) {
                ruleCodeStr.append("#SEQ");
                continue;
            }
            if (def.startsWith("#")) {
                String codeStr = def;
                String ruleCode = def.substring(1).toLowerCase();
                INORule handle = this.getRuleHandle(ruleCode);
                codeStr = handle.getCodeStr(ruleCode, keys);
                if (codeStr == null) {
                    codeStr = def;
                }
                if (handle.isDateRule()) {
                    DateStr = codeStr;
                } else if (!codeStr.equalsIgnoreCase(prestr) && !codeStr.equalsIgnoreCase(level)) {
                    ruleTypeStr.append("-" + codeStr);
                }
                ruleCodeStr.append(codeStr);
                continue;
            }
            ruleCodeStr.append(def);
            ruleTypeStr.append(def);
        }
        rule.setRuleTypeDay(DateStr);
        rule.setRuleCodeStr(ruleCodeStr.toString());
        rule.setRuleTypeStr(ruleTypeStr.toString());
    }

    private List<String> getRuleCodeList(GlobRuleModel rule, int num) throws Exception {
        ArrayList<String> rulecodelist = new ArrayList<String>();
        this.getRuleCodeTemplate(rule);
        long startSeqNo = GlobRuleSrvimpl.getInstance().getlast(rule.getEntId(), rule.getRuleId(), rule.getRuleTypeStr(), rule.getRuleTypeDay(), num);
        long lastNum = startSeqNo + (long)num;
        String baseCode = rule.getRuleCodeStr();
        int seqlen = rule.getRuleSysLen() - baseCode.length() + 4;
        for (int i = 0; i < num; ++i) {
            Object seqNo;
            int len;
            if ((len = seqlen - String.valueOf(seqNo = String.valueOf(++startSeqNo)).length()) < 0) {
                throw new ServiceException("10000", "seqno [{0}] length is max [{1}]", new Object[]{seqNo, seqlen});
            }
            len += String.valueOf(seqNo).length();
            seqNo = "00000000000000000000" + (String)seqNo;
            seqNo = ((String)seqNo).substring(((String)seqNo).length() - len);
            String code = rule.getRuleCodeStr().replace("#SEQ", (CharSequence)seqNo);
            rulecodelist.add(code);
        }
        return rulecodelist;
    }

    @Override
    public List<String> doGenRuleCodeBatch(long ent_id, String ruleid, String prestr, String level, int num, Map<String, Object> fields) throws Exception {
        GlobRuleModel rule = GlobRuleSrvimpl.getInstance().getrule(ent_id, ruleid);
        rule.setEntId(ent_id);
        rule.setPreStr(prestr);
        rule.setLevelStr(level);
        rule.setKeys(fields);
        return this.getRuleCodeList(rule, num);
    }

    @Override
    public String doGenRuleCode(long ent_id, String ruleid, String prestr, String level, Map<String, Object> fields) throws Exception {
        List<String> codes = this.doGenRuleCodeBatch(ent_id, ruleid, prestr, level, 1, fields);
        return codes.get(0);
    }

    @Override
    public String getSheetId(ServiceSession session, JSONObject jsonparam) throws Exception {
        long startTimeMillis = System.currentTimeMillis();
        jsonparam.put("menucode", StaticVariable.get((String)"context.moduleCode"));
        String sheetid = GlobRuleSrvimpl.getInstance().doGenRuleCodeBatch(session.getEnt_id(), "sheetid", null, null, 1, (Map<String, Object>)jsonparam).get(0);
        long endTimeMillis = System.currentTimeMillis();
        long executeTime = endTimeMillis - startTimeMillis;
        logger.info("executeTime:" + executeTime);
        return sheetid;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.nonNull(this.applicationContext);
        Map rules = this.applicationContext.getBeansOfType(INORule.class);
        if (Objects.nonNull(rules)) {
            for (INORule rule : rules.values()) {
                logger.info("GlobRule\u6ce8\u518c\u89c4\u5219\u7f16\u7801\u751f\u6210\u5668[" + rule.getRuleCode() + "]");
                this.ruleHandles.put(rule.getRuleCode().toLowerCase(), rule);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    protected Document onBeforeRowInsert(Query query, Update update) {
        return null;
    }
}

