/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.redis;

import com.efuture.redis.BaseJedisConnectionFactory;
import jakarta.annotation.Resource;
import java.time.Duration;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisJedisPoolConfig {
    @Resource
    ConfigurableEnvironment environment;

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public RedisStandaloneConfiguration redisStandaloneConfig() {
        String host = this.environment.getProperty("spring.redis.host");
        String port = this.environment.getProperty("spring.redis.port");
        String password = this.environment.getProperty("spring.redis.password");
        String index = this.environment.getProperty("spring.redis.database");
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(host.trim());
        redisStandaloneConfiguration.setPort(Integer.parseInt(port.trim()));
        redisStandaloneConfiguration.setDatabase(!StringUtils.isEmpty((Object)index) ? Integer.valueOf(index) : 0);
        redisStandaloneConfiguration.setPassword(!StringUtils.isEmpty((Object)password) ? password.trim() : "");
        return redisStandaloneConfiguration;
    }

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public JedisConnectionFactory singleRedisConnectionFactory() {
        BaseJedisConnectionFactory.StandaloneJedisClientConfiguration clientConfig = (BaseJedisConnectionFactory.StandaloneJedisClientConfiguration)BaseJedisConnectionFactory.StandaloneJedisClientConfiguration.create((GenericObjectPoolConfig)this.poolConfiguration());
        int timeout = (Integer)this.environment.getProperty("spring.redis.timeout", Integer.class, (Object)10000);
        clientConfig.setReadTimeout(Duration.ofMillis(timeout));
        BaseJedisConnectionFactory jedisConnectionFactory = new BaseJedisConnectionFactory(this.redisStandaloneConfig(), (JedisClientConfiguration)clientConfig);
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        return jedisConnectionFactory;
    }

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public JedisConnectionFactory clusterRedisConnectionFactory() {
        BaseJedisConnectionFactory jedisConnectionFactory = new BaseJedisConnectionFactory(this.clusterConfiguration(), this.poolConfiguration());
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        return jedisConnectionFactory;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public RedisClusterConfiguration clusterConfiguration() {
        Properties properties = new Properties();
        properties.put("spring.redis.cluster.nodes", this.environment.getProperty("spring.redis.cluster.nodes"));
        String maxRedirects = this.environment.getProperty("spring.redis.cluster.max-redirects");
        properties.put("spring.redis.cluster.max-redirects", (Object)Integer.parseInt(maxRedirects));
        PropertiesPropertySource redisPropertySource = new PropertiesPropertySource("redis", properties);
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration((PropertySource)redisPropertySource);
        String password = this.environment.getProperty("spring.redis.password");
        redisClusterConfiguration.setPassword(password);
        return redisClusterConfiguration;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public JedisPoolConfig poolConfiguration() {
        JedisPoolConfig config = new JedisPoolConfig();
        String maxActive = this.environment.getProperty("spring.redis.jedis.pool.max-active");
        String maxWait = this.environment.getProperty("spring.redis.jedis.pool.max-wait");
        String maxIdle = this.environment.getProperty("spring.redis.jedis.pool.max-idle");
        String minIdle = this.environment.getProperty("spring.redis.jedis.pool.min-idle");
        boolean testOnCreate = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-create", Boolean.class, (Object)false);
        boolean testOnBorrow = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-borrow", Boolean.class, (Object)false);
        boolean testOnReturn = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-return", Boolean.class, (Object)false);
        boolean testWhileIdle = (Boolean)this.environment.getProperty("spring.redis.pool.test-while-idle", Boolean.class, (Object)false);
        config.setMaxTotal(Integer.parseInt(maxActive));
        config.setMaxWaitMillis((long)Integer.parseInt(maxWait));
        config.setMaxIdle(Integer.parseInt(maxIdle));
        config.setMinIdle(Integer.parseInt(minIdle));
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnCreate(testOnCreate);
        config.setTestOnReturn(testOnReturn);
        config.setTestWhileIdle(testWhileIdle);
        return config;
    }
}

