/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.redis;

import com.efuture.redis.component.RedisClient;
import jakarta.annotation.Resource;
import java.time.Duration;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.UnifiedJedis;

@Configuration
public class RedisLettucePoolConfig {
    @Resource
    ConfigurableEnvironment environment;
    @Value(value="${redis.connection.mode:single}")
    private String connectionMode;
    @Value(value="${spring.redis.host:localhost}")
    private String host;
    @Value(value="${spring.redis.port:6379}")
    private int port;
    @Value(value="${spring.redis.password:xxx}")
    private String password;
    @Value(value="${spring.redis.database:0}")
    private int index;
    @Value(value="${spring.redis.timeout:5000}")
    private int timeout;

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public RedisStandaloneConfiguration redisStandaloneConfig() {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.host.trim());
        redisStandaloneConfiguration.setPort(this.port);
        redisStandaloneConfiguration.setDatabase(this.index);
        redisStandaloneConfiguration.setPassword(!StringUtils.isEmpty((CharSequence)this.password) ? this.password.trim() : "");
        return redisStandaloneConfiguration;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public LettucePoolingClientConfiguration lettucePoolingClientConfiguration() {
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
        builder.poolConfig((GenericObjectPoolConfig)this.poolConfiguration());
        builder.commandTimeout(Duration.ofMillis(this.timeout));
        return builder.build();
    }

    @Bean(value={"lettuceConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    @Primary
    public LettuceConnectionFactory redisConnectionFactory() {
        LettuceConnectionFactory connect = new LettuceConnectionFactory(this.redisStandaloneConfig(), (LettuceClientConfiguration)this.lettucePoolingClientConfiguration());
        connect.setConvertPipelineAndTxResults(false);
        return connect;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public RedisClusterConfiguration clusterConfiguration() {
        Properties properties = new Properties();
        properties.put("spring.redis.cluster.nodes", this.environment.getProperty("spring.redis.cluster.nodes"));
        String maxRedirects = this.environment.getProperty("spring.redis.cluster.max-redirects");
        properties.put("spring.redis.cluster.max-redirects", (Object)Integer.parseInt(maxRedirects));
        PropertiesPropertySource redisPropertySource = new PropertiesPropertySource("redis", properties);
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration((PropertySource)redisPropertySource);
        String password = this.environment.getProperty("spring.redis.password");
        redisClusterConfiguration.setPassword(password);
        return redisClusterConfiguration;
    }

    @Bean(value={"lettuceConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public LettuceConnectionFactory clusterConnectionFactory() {
        LettuceConnectionFactory connect = new LettuceConnectionFactory(this.clusterConfiguration(), (LettuceClientConfiguration)this.lettucePoolingClientConfiguration());
        connect.setConvertPipelineAndTxResults(false);
        return connect;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public JedisPoolConfig poolConfiguration() {
        JedisPoolConfig config = new JedisPoolConfig();
        String maxActive = this.environment.getProperty("spring.redis.jedis.pool.max-active");
        String maxWait = this.environment.getProperty("spring.redis.jedis.pool.max-wait");
        String maxIdle = this.environment.getProperty("spring.redis.jedis.pool.max-idle");
        String minIdle = this.environment.getProperty("spring.redis.jedis.pool.min-idle");
        boolean testOnCreate = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-create", Boolean.class, (Object)false);
        boolean testOnBorrow = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-borrow", Boolean.class, (Object)false);
        boolean testOnReturn = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-return", Boolean.class, (Object)false);
        boolean testWhileIdle = (Boolean)this.environment.getProperty("spring.redis.pool.test-while-idle", Boolean.class, (Object)false);
        config.setMaxTotal(Integer.parseInt(maxActive));
        config.setMaxWaitMillis((long)Integer.parseInt(maxWait));
        config.setMaxIdle(Integer.parseInt(maxIdle));
        config.setMinIdle(Integer.parseInt(minIdle));
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnCreate(testOnCreate);
        config.setTestOnReturn(testOnReturn);
        config.setTestWhileIdle(testWhileIdle);
        return config;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        if (this.connectionMode.equals("single")) {
            redisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
            redisTemplate.setEnableTransactionSupport(true);
        } else if (this.connectionMode.equals("cluster")) {
            redisTemplate.setConnectionFactory((RedisConnectionFactory)this.clusterConnectionFactory());
        }
        GenericJackson2JsonRedisSerializer jackson2JsonRedisSerializer = new GenericJackson2JsonRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    StringRedisTemplate stringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        if (this.connectionMode.equals("single")) {
            stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
            stringRedisTemplate.setEnableTransactionSupport(true);
        } else if (this.connectionMode.equals("cluster")) {
            stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.clusterConnectionFactory());
        }
        return stringRedisTemplate;
    }

    @Bean
    @Autowired
    RedisClient redisClient(@Qualifier(value="stringRedisTemplate") StringRedisTemplate stringRedisTemplate) {
        return new RedisClient(stringRedisTemplate);
    }

    @Bean
    public UnifiedJedis unifiedJedis(GenericObjectPoolConfig jedisPoolConfig) {
        JedisPooled client = StringUtils.isNotEmpty((CharSequence)this.password) ? new JedisPooled(jedisPoolConfig, this.host, this.port, this.timeout, this.password, this.index) : new JedisPooled(jedisPoolConfig, this.host, this.port, this.timeout, null, this.index);
        client = new JedisPooled();
        return client;
    }
}

