/*
 * Decompiled with CFR 0.152.
 */
package com.product.mybatisplus.entity;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.product.util.CopyUtil;
import java.util.List;

public class PageInfo<T> {
    private int page;
    private int pageSize;
    private String sidx;
    private String sord;
    private List<T> rows;
    private int records;
    private int total;

    public static <T> PageInfo<T> of(IPage page, Class<T> entityVoClass) {
        int pageSize;
        int records = (int)page.getTotal();
        int total = records % (pageSize = (int)page.getSize()) == 0 ? records / pageSize : records / pageSize + 1;
        PageInfo<T> pageInfo = new PageInfo<T>();
        pageInfo.setPage((int)page.getCurrent());
        pageInfo.setPageSize(pageSize);
        pageInfo.setRows(CopyUtil.copyList(page.getRecords(), entityVoClass));
        pageInfo.setRecords(records);
        pageInfo.setTotal(total);
        return pageInfo;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getSidx() {
        return this.sidx;
    }

    public String getSord() {
        return this.sord;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public int getRecords() {
        return this.records;
    }

    public int getTotal() {
        return this.total;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setRecords(int records) {
        this.records = records;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getRecords() != other.getRecords()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        String this$sidx = this.getSidx();
        String other$sidx = other.getSidx();
        if (this$sidx == null ? other$sidx != null : !this$sidx.equals(other$sidx)) {
            return false;
        }
        String this$sord = this.getSord();
        String other$sord = other.getSord();
        if (this$sord == null ? other$sord != null : !this$sord.equals(other$sord)) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getRecords();
        result = result * 59 + this.getTotal();
        String $sidx = this.getSidx();
        result = result * 59 + ($sidx == null ? 43 : $sidx.hashCode());
        String $sord = this.getSord();
        result = result * 59 + ($sord == null ? 43 : $sord.hashCode());
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    public String toString() {
        return "PageInfo(page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", sidx=" + this.getSidx() + ", sord=" + this.getSord() + ", rows=" + String.valueOf(this.getRows()) + ", records=" + this.getRecords() + ", total=" + this.getTotal() + ")";
    }
}

