/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.product.util.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONSerializeUtil {
    public static <T> JSONObject toQueryFilter(JSONObject paramsObject, Class<T> classzz) throws InstantiationException, IllegalAccessException {
        return JSONSerializeUtil.toQueryFilter(paramsObject, classzz, true);
    }

    public static <T> JSONObject toQueryFilter(JSONObject paramsObject, Class<T> classzz, boolean withPage) throws InstantiationException, IllegalAccessException {
        JSONObject response = new JSONObject();
        List<String> otherKeys = Arrays.asList("fields", "order_direction", "order_field", "page_no", "page_size");
        T model = classzz.newInstance();
        JSONObject paramsAll = (JSONObject)JSON.toJSON(model);
        if (paramsObject != null) {
            for (String jsonKey : paramsObject.keySet()) {
                if (paramsAll.containsKey((Object)jsonKey)) {
                    response.put(jsonKey, paramsObject.get((Object)jsonKey));
                    continue;
                }
                if (!withPage || !otherKeys.contains(jsonKey)) continue;
                response.put(jsonKey, paramsObject.get((Object)jsonKey));
            }
        }
        return response;
    }

    public static Object toNameJSONByKey(Object data, final Map<String, Object> config) {
        JSONObject jsondata = null;
        try {
            if (config == null || config.size() < 1) {
                jsondata = JSON.parseObject((String)TypeUtils.toJSONStringWithDateFormat((Object)data, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
            } else {
                final Set<String> keySet = config.keySet();
                jsondata = JSON.parseObject((String)JSON.toJSONString((Object)data, (SerializeFilter)new NameFilter(){

                    public String process(Object object, String name, Object value) {
                        for (String field : keySet) {
                            if (!name.equals(field)) continue;
                            return (String)config.get(field);
                        }
                        return name;
                    }
                }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            }
        }
        catch (Exception ex) {
            return data;
        }
        return jsondata;
    }

    public static Object toNameJSONByValue(Object data, Map<String, Object> config) {
        JSONObject jsondata = null;
        try {
            if (config == null || config.size() < 1) {
                jsondata = JSON.parseObject((String)TypeUtils.toJSONStringWithDateFormat((Object)data, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
            } else {
                final Set<Map.Entry<String, Object>> keySet = config.entrySet();
                jsondata = JSON.parseObject((String)JSON.toJSONString((Object)data, (SerializeFilter)new NameFilter(){

                    public String process(Object object, String name, Object value) {
                        for (Map.Entry entry : keySet) {
                            if (!name.equals(entry.getValue())) continue;
                            return (String)entry.getKey();
                        }
                        return name;
                    }
                }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            }
        }
        catch (Exception ex) {
            return data;
        }
        return jsondata;
    }

    public static Object toValueJSONByKey(Object data, final Map<String, String> config, final String flag1, final String flag2) {
        JSONObject jsondata = null;
        try {
            if (config == null || config.size() < 1) {
                jsondata = JSON.parseObject((String)TypeUtils.toJSONStringWithDateFormat((Object)data, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
            } else {
                final Set<String> keySet = config.keySet();
                jsondata = JSON.parseObject((String)JSON.toJSONString((Object)data, (SerializeFilter)new ValueFilter(){

                    public Object process(Object object, String name, Object value) {
                        for (String field : keySet) {
                            Map<String, Object> map;
                            if (!name.equals(field) || !(map = JSONSerializeUtil.replitMap((String)config.get(field), flag1, flag2)).containsKey(String.valueOf(value))) continue;
                            return map.get(String.valueOf(value));
                        }
                        return value;
                    }
                }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            }
        }
        catch (Exception ex) {
            return data;
        }
        return jsondata;
    }

    public static Object toValueJSONByKey(Object data, final Map<String, Object> config) {
        JSONObject jsondata = null;
        try {
            jsondata = config == null || config.size() < 1 ? JSON.parseObject((String)TypeUtils.toJSONStringWithDateFormat((Object)data, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0])) : JSON.parseObject((String)JSON.toJSONString((Object)data, (SerializeFilter)new ValueFilter(){

                public Object process(Object object, String name, Object value) {
                    String orderField;
                    String s;
                    if (name.equals("order_field") && value instanceof String && !(s = (String)value).isEmpty() && !(orderField = JSONSerializeUtil.onContins(s, config)).isEmpty()) {
                        return orderField;
                    }
                    if (value instanceof String) {
                        String st = (String)value;
                        if ("Y".equalsIgnoreCase(st)) {
                            return true;
                        }
                        if ("N".equalsIgnoreCase(st)) {
                            return false;
                        }
                    }
                    return value;
                }
            }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        }
        catch (Exception ex) {
            return data;
        }
        return jsondata;
    }

    public static JSONObject toValueByBoolean(Object data) {
        JSONObject jsondata = null;
        jsondata = JSON.parseObject((String)JSON.toJSONString((Object)data, (SerializeFilter)new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                Integer vresult = 0;
                if (value instanceof Boolean) {
                    vresult = (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
                    return vresult;
                }
                if (value instanceof String) {
                    if (value.equals("true")) {
                        vresult = 1;
                    } else if (value.equals("false")) {
                        vresult = 0;
                    }
                    return vresult;
                }
                return value;
            }
        }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        return jsondata;
    }

    private static Map<String, Object> replitMap(String str, String flag1, String flag2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] ss = str.split(flag1);
        if (ss.length > 0) {
            for (int i = 0; i < ss.length; ++i) {
                String[] kv = ss[i].split(flag2);
                if (kv.length != 2) continue;
                map.put(kv[0], kv[1]);
            }
        }
        return map;
    }

    private static String onContins(String value, Map<String, Object> config) {
        Object orderField = "";
        String[] ss = value.split(",");
        for (int i = 0; i < ss.length; ++i) {
            if (!config.containsKey(ss[i])) continue;
            orderField = i == 0 ? (String)orderField + String.valueOf(config.get(ss[i])) : (String)orderField + "," + String.valueOf(config.get(ss[i]));
        }
        return orderField;
    }

    public static Object distinctByKey(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            ArrayList newjson = new ArrayList();
            list.stream().distinct().forEach(newjson::add);
            return newjson;
        }
        return null;
    }

    public static void main(String[] args) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("lastflag", "1:Y,0:N");
        HashMap<String, String> config1 = new HashMap<String, String>();
        config1.put("lastflag", "leafFlag");
        HashMap<String, String> config2 = new HashMap<String, String>();
        config2.put("lastflag", "leafFlag");
        config2.put("aa", "code");
        config2.put("aa1", "name");
        config2.put("aa11", "cs");
        JSONObject jsondata = new JSONObject();
        jsondata.put("lastflag", (Object)"Y");
        jsondata.put("aa", (Object)"0");
        jsondata.put("aa11", (Object)"11");
        jsondata.put("aa112", (Object)"234");
        jsondata.put("aa113", (Object)"false");
        jsondata.put("aa114", (Object)false);
        jsondata.put("order_field", (Object)"lastflag,aa,aa11");
        System.out.println(jsondata);
        System.out.println(JSONSerializeUtil.toValueByBoolean(jsondata));
    }
}

