/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.service.AnnotationService;
import com.product.util.TypeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.StringUtils;

public abstract class BaseAnnotationService<T extends Annotation>
implements AnnotationService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String ruleField = "(\\$\\{[^>]*?\\})";
    private final Pattern pattern = Pattern.compile("(\\$\\{[^>]*?\\})");
    private Class<T> annotationClass;

    public Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public BaseAnnotationService(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void onValueSet(Object targetObject, String fieldname, Object fieldValue) {
        String name = this.getClass().getSimpleName();
        this.logger.debug(name + ".onValueSet--->" + targetObject.getClass().getSimpleName() + " fieldname:" + fieldname + " fieldvalue:" + String.valueOf(fieldValue));
        if (targetObject instanceof JSONObject) {
            JSONObject source = (JSONObject)targetObject;
            source.put(fieldname, fieldValue);
        } else if (targetObject instanceof Map) {
            Map source = (Map)targetObject;
            source.put(fieldname, fieldValue);
        } else {
            try {
                BeanWrapperImpl rowBean = new BeanWrapperImpl(targetObject);
                rowBean.setPropertyValue(fieldname, fieldValue);
            }
            catch (Exception e) {
                this.logger.error("write {} to {} faiure:{}", new Object[]{fieldname, fieldValue, e.getMessage(), e});
            }
        }
    }

    public Object onValueGet(Object targetObject, String fieldname) {
        String name = this.getClass().getSimpleName();
        this.logger.debug(name + ".onValueGet--->" + targetObject.getClass().getSimpleName());
        if (targetObject instanceof JSONObject) {
            JSONObject source = (JSONObject)targetObject;
            if (source.containsKey((Object)fieldname)) {
                return source.get((Object)fieldname);
            }
        } else if (targetObject instanceof Map) {
            Map source = (Map)targetObject;
            if (source.containsKey(fieldname)) {
                return source.get(fieldname);
            }
        } else {
            JSONObject source = (JSONObject)TypeUtils.toJSON((Object)targetObject, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
            if (source.containsKey((Object)fieldname)) {
                return source.get((Object)fieldname);
            }
        }
        return null;
    }

    protected void onMessageParse(StringBuffer buffer, String message, Object targetObject) {
        Matcher matcher = this.pattern.matcher(message);
        while (matcher.find()) {
            String keyName = matcher.group();
            Object keyValue = this.onValueGet(targetObject, keyName = keyName.replaceAll("\\$\\{", "").replaceAll("\\}", ""));
            if (StringUtils.isEmpty((Object)keyValue)) continue;
            matcher.appendReplacement(buffer, keyValue.toString());
        }
        matcher.appendTail(buffer);
    }

    protected void printStack(Logger logger, String tagName, String message) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        printWriter.print(String.format("%1$s\r\n", message));
        boolean first = true;
        for (StackTraceElement traceElement : elements) {
            if (!traceElement.getClassName().startsWith("java.lang.Thread") && !traceElement.getClassName().startsWith("com.product.component.BaseAnnotationService")) {
                first = false;
            }
            if (first || traceElement.getClassName().startsWith("org.springframework") || traceElement.getClassName().startsWith("sun.reflect") || traceElement.getClassName().startsWith("java.lang") || traceElement.getClassName().startsWith("org.junit") || traceElement.getClassName().startsWith("org.eclipse")) continue;
            printWriter.println("\tat " + String.valueOf(traceElement));
        }
        logger.debug(String.format("%1$s error:--->%2$s", tagName, stringWriter.toString()));
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (Exception e) {
            logger.debug(String.format("%1$s error CloseException:--->%2$s", tagName, e.getMessage()));
        }
    }

    protected void printStack(Logger logger, String tagName, Exception ex, String message) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        message = StringUtils.isEmpty((Object)message) ? ex.getMessage() : String.format("%1$s -> %2$s", message, ex.getMessage());
        logger.debug(String.format("%1$s error msg:--->%2$s", tagName, message));
        logger.debug(String.format("%1$s error detail:--->%2$s", tagName, stringWriter.toString()));
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (Exception e) {
            logger.debug(String.format("%1$s error CloseException:--->%2$s", tagName, e.getMessage()));
        }
    }
}

