/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.component.BatchBaseService;
import com.product.component.BeanField;
import com.product.exception.ServiceException;
import com.product.model.AbstractEntityBean;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.TypeUtils;
import com.shiji.core.util.ReflectUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="batchinsservice")
public class BatchInsService
extends BatchBaseService {
    @Value(value="${batchinsert.batch_rows:1000}")
    private int BATCH_ROWS = 1000;

    public void batchInsert(FMybatisTemplate storage, List<Map<String, Object>> lists, String tableName) throws Exception {
        this.batchInsert(storage, lists, tableName, this.BATCH_ROWS);
    }

    public void batchInsert(FMybatisTemplate storage, List<Map<String, Object>> lists, String tableName, int batch_rows) throws Exception {
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        Map<String, Object> firstRow = lists.get(0);
        Set<String> flds = firstRow.keySet();
        for (String col : flds) {
            BeanField bf = new BeanField();
            bf.setColName(col);
            if (firstRow.get(col) != null) {
                bf.setColType(firstRow.get(col).getClass().toString().toLowerCase());
            } else {
                bf.setColType("string");
            }
            beanFields.add(bf);
        }
        this.batchInsertFields(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String tableName, List<T> lists) throws Exception {
        this.batchInsert(storage, objClass, tableName, lists, this.BATCH_ROWS);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String tableName, List<T> lists, String keyFieldName) throws Exception {
        this.batchInsert(storage, objClass, tableName, lists, keyFieldName, this.BATCH_ROWS);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String tableName, List<T> lists, int batch_rows) throws Exception {
        List fields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        Set<BeanField> beanFields = this.transform(fields);
        this.batchInsertFields(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String tableName, List<T> lists, String keyFieldName, int batch_rows) throws Exception {
        List fields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        Set<BeanField> beanFields = this.transform(fields);
        this.batchInsertFields(storage, objClass, beanFields, lists, tableName, keyFieldName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, Set<String> fields, List<T> lists, String tableName) throws Exception {
        this.batchInsert(storage, objClass, fields, lists, tableName, this.BATCH_ROWS);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, Set<String> fields, List<T> lists, String tableName, String keyFieldName) throws Exception {
        this.batchInsert(storage, objClass, fields, lists, tableName, keyFieldName, this.BATCH_ROWS);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, Set<String> fields, List<T> lists, String tableName, int batch_rows) throws Exception {
        List allBeanFields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        List<Field> fieldList = this.filter(allBeanFields, fields);
        Set<BeanField> beanFields = this.transform(fieldList);
        this.batchInsertFields(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, Set<String> fields, List<T> lists, String tableName, String keyFieldName, int batch_rows) throws Exception {
        List allBeanFields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        List<Field> fieldList = this.filter(allBeanFields, fields);
        Set<BeanField> beanFields = this.transform(fieldList);
        this.batchInsertFields(storage, objClass, beanFields, lists, tableName, keyFieldName, batch_rows);
    }

    public <T> void batchInsertFields(FMybatisTemplate storage, Set<BeanField> beanFields, List<T> lists, String tableName, int batch_rows) throws Exception {
        if (StringUtils.isEmpty(lists) || lists.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty(beanFields) || beanFields.isEmpty()) {
            return;
        }
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new ServiceException("5000", "unsupport DBMS Type!", new Object[0]);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tableName).append(" (");
        for (BeanField col : beanFields) {
            tabsql.append(col.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer sql = new StringBuffer();
            sql.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                JSONObject rowjson = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        value = rowjson.get((Object)col.getColName());
                        if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)col.getDefalueValue())) {
                            value = col.getDefalueValue();
                        }
                        sql.append(this.getColData(dbtype, value, col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        value = rowjson.get((Object)col.getColName());
                        if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)col.getDefalueValue())) {
                            value = col.getDefalueValue();
                        }
                        sql.append(this.getColData(dbtype, value, col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" \r\n ");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    if (firstrow) {
                        sql.append(" values ");
                    } else {
                        sql.append(",");
                    }
                    sql.append("(");
                    for (BeanField col : beanFields) {
                        value = rowjson.get((Object)col.getColName());
                        if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)col.getDefalueValue())) {
                            value = col.getDefalueValue();
                        }
                        sql.append(this.getColData(dbtype, value, col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(")");
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", sql.toString());
        }
    }

    public <T> void batchInsertFields(FMybatisTemplate storage, Class<?> objClass, Set<BeanField> beanFields, List<T> lists, String tableName, String keyFieldName, int batch_rows) throws Exception {
        if (StringUtils.isEmpty(lists) || lists.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty(beanFields) || beanFields.isEmpty()) {
            return;
        }
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new ServiceException("5000", "unsupport DBMS Type!", new Object[0]);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tableName).append(" (");
        for (BeanField col : beanFields) {
            tabsql.append(col.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer sql = new StringBuffer();
            sql.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                JSONObject rowjson = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        value = this.getColValue(rowjson, col.getColName(), keyFieldName);
                        if (col.getColName().equalsIgnoreCase(keyFieldName)) {
                            AbstractEntityBean.setFieldValue(objClass, bean, (String)col.getColName(), (Object)value);
                        }
                        if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)col.getDefalueValue())) {
                            value = col.getDefalueValue();
                            AbstractEntityBean.setFieldValue(objClass, bean, (String)col.getColName(), (Object)value);
                        }
                        sql.append(this.getColData(dbtype, value, col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        value = this.getColValue(rowjson, col.getColName(), keyFieldName);
                        if (col.getColName().equalsIgnoreCase(keyFieldName)) {
                            AbstractEntityBean.setFieldValue(objClass, bean, (String)col.getColName(), (Object)value);
                        }
                        if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)col.getDefalueValue())) {
                            value = col.getDefalueValue();
                            AbstractEntityBean.setFieldValue(objClass, bean, (String)col.getColName(), (Object)value);
                        }
                        sql.append(this.getColData(dbtype, value, col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" \r\n ");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    this.joinInsertMysql(objClass, beanFields, bean, keyFieldName, firstrow, sql);
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", sql.toString());
        }
    }

    public void joinInsertMysql(Class<?> objClass, Set<BeanField> beanFields, Object bean, String keyFieldName, boolean firstrow, StringBuffer sql) throws Exception {
        if (firstrow) {
            sql.append(" values ");
        } else {
            sql.append(",");
        }
        sql.append("(");
        JSONObject rowjson = TypeUtils.toJSONObj((Object)bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        for (BeanField col : beanFields) {
            Object value = this.getColValue(rowjson, col.getColName(), keyFieldName);
            if (col.getColName().equalsIgnoreCase(keyFieldName)) {
                AbstractEntityBean.setFieldValue(objClass, (Object)bean, (String)col.getColName(), (Object)value);
            }
            if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)col.getDefalueValue())) {
                value = col.getDefalueValue();
                AbstractEntityBean.setFieldValue(objClass, (Object)bean, (String)col.getColName(), (Object)value);
            }
            sql.append(this.getColData(QueryExtractor.DBTYPE.MYSQL, value, col.getColType()));
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
    }

    public void joinInsertOracle() {
    }

    public void joinInsertSqlite() {
    }
}

