/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.component.QueryBlankValuePreFilter;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class CommonServiceImpl<M, S>
extends JDBCCompomentServiceImpl<M> {
    public Logger logger;
    private Class<M> t;

    public CommonServiceImpl(FMybatisTemplate mybatisTemplate, String collectionName, String keyfieldName) {
        super(mybatisTemplate, collectionName, keyfieldName);
        ParameterizedType superclass = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        Type[] actualTypeArguments = superclass.getActualTypeArguments();
        this.t = (Class)actualTypeArguments[0];
        this.logger = LoggerFactory.getLogger((Class)((Class)actualTypeArguments[1]));
    }

    @Override
    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    public M wrapQueryBean(ServiceSession session, JSONObject paramsObject) throws Exception {
        Map map;
        ServiceResponse response = this.onQuery(session, paramsObject);
        if (!"0".equals(response.getReturncode())) {
            this.logger.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " --- " + String.valueOf(response.getData()));
        }
        return (M)(((List)(map = (Map)response.getData()).get(this.getCollectionName())).isEmpty() ? null : JSONObject.toJavaObject((JSON)new JSONObject((Map)((List)map.get(this.getCollectionName())).get(0)), this.t));
    }

    public List<M> wrapQueryBeanList(ServiceSession session, JSONObject paramsObject) throws Exception {
        ServiceResponse response = this.onQuery(session, paramsObject);
        if (!"0".equals(response.getReturncode())) {
            this.logger.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " --- " + String.valueOf(response.getData()));
        }
        Map map = (Map)response.getData();
        List rowMapList = (List)map.get(this.getCollectionName());
        return JSON.parseArray((String)JSON.toJSONString((Object)rowMapList), this.t);
    }

    public ServiceResponse wrapQuery(ServiceSession session, JSONObject paramsObject, String ... requiredFields) throws Exception {
        ServiceResponse response;
        if (!StringUtils.isEmpty((Object)requiredFields) && "50003".equals((response = QueryBlankValuePreFilter.getInstance().checkRequiredField(session, paramsObject, requiredFields)).getReturncode())) {
            return response;
        }
        response = this.onQuery(session, paramsObject);
        if (!"0".equals(response.getReturncode())) {
            this.logger.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " --- " + String.valueOf(response.getData()));
        }
        return response;
    }

    public ServiceResponse wrapInsert(ServiceSession session, JSONObject paramsObject, String ... requiredFields) throws Exception {
        ServiceResponse response;
        if (!StringUtils.isEmpty((Object)requiredFields) && "50003".equals((response = QueryBlankValuePreFilter.getInstance().checkRequiredField(session, paramsObject, requiredFields)).getReturncode())) {
            return response;
        }
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String userId = Long.toString(session.getUser_id());
        paramsObject.put("userId", (Object)userId);
        paramsObject.put("createDate", (Object)date);
        response = this.onInsert(session, paramsObject);
        if (!"0".equals(response.getReturncode())) {
            this.logger.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " --- " + String.valueOf(response.getData()));
        }
        return response;
    }

    public ServiceResponse wrapUpdate(ServiceSession session, JSONObject paramsObject, String ... requiredFields) throws Exception {
        ServiceResponse response;
        if (!StringUtils.isEmpty((Object)requiredFields) && "50003".equals((response = QueryBlankValuePreFilter.getInstance().checkRequiredField(session, paramsObject, requiredFields)).getReturncode())) {
            return response;
        }
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String userId = Long.toString(session.getUser_id());
        paramsObject.put("userId", (Object)userId);
        paramsObject.put("updateDate", (Object)date);
        this.setUpsert(false);
        response = this.onUpdate(session, paramsObject);
        if (!"0".equals(response.getReturncode())) {
            this.logger.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " --- " + String.valueOf(response.getData()));
        }
        return response;
    }

    public ServiceResponse wrapDelete(ServiceSession session, JSONObject paramsObject, String ... requiredFields) throws Exception {
        ServiceResponse response;
        if (!StringUtils.isEmpty((Object)requiredFields) && "50003".equals((response = QueryBlankValuePreFilter.getInstance().checkRequiredField(session, paramsObject, requiredFields)).getReturncode())) {
            return response;
        }
        response = this.onDelete(session, paramsObject);
        if (!"0".equals(response.getReturncode())) {
            this.logger.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " --- " + String.valueOf(response.getData()));
        }
        return response;
    }
}

