/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ParameterRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> params;

    public ParameterRequestWrapper(HttpServletRequest request, Map<String, String[]> newParams) {
        super(request);
        this.params = newParams;
        this.renewParameterMap(request);
    }

    public String getQueryString() {
        Object queryString = "";
        for (Map.Entry<String, String[]> entry : this.params.entrySet()) {
            queryString = (String)queryString + entry.getKey() + "=" + entry.getValue()[0].toString() + "&";
        }
        return ((String)queryString).substring(0, ((String)queryString).length() - 1);
    }

    private void renewParameterMap(HttpServletRequest req) {
        String queryString = req.getQueryString();
        if (StringUtils.hasText((String)queryString)) {
            String[] params = queryString.split("&");
            for (int i = 0; i < params.length; ++i) {
                int splitIndex = params[i].indexOf("=");
                String key = params[i].substring(0, splitIndex);
                if (key.equalsIgnoreCase("method")) continue;
                try {
                    String value = URLEncoder.encode(params[i].substring(splitIndex + 1, params[i].length()), "UTF-8");
                    this.params.put(key, new String[]{value});
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

