/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter.standard;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.filter.FtSqlSource;
import com.product.storage.slice.filter.standard.CollectionSelectWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public abstract class CollectionDeleteWrapper
extends CollectionSelectWrapper {
    protected void onDeleteStatement(Logger logger, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt) throws Throwable {
        SQLDeleteStatement deleteStmt = (SQLDeleteStatement)stmt;
        String collectionName = deleteStmt.getTableName().getSimpleName().toLowerCase();
        SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
        String authWhereSql = this.getWhere(collectionName, null);
        if (!StringUtils.isEmpty((Object)authWhereSql)) {
            SQLExpr authWhereExpr = this.getWhereInfo(authWhereSql);
            if (deleteStmt.getWhere() != null && deleteStmt.getWhere() instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)deleteStmt.getWhere();
                if (whereExpr != null) {
                    newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                    newWhereExpr.setLeft((SQLExpr)whereExpr);
                    newWhereExpr.setRight(authWhereExpr);
                }
            } else {
                newWhereExpr = authWhereExpr;
            }
            deleteStmt.setWhere((SQLExpr)newWhereExpr);
        }
        StringBuffer newSql = new StringBuffer();
        MySqlOutputVisitor visitor = null;
        if (this.getDbType().equals("mysql")) {
            visitor = new MySqlOutputVisitor((Appendable)newSql);
        } else if (this.getDbType().equals("oracle")) {
            visitor = new OracleOutputVisitor((Appendable)newSql);
        } else {
            throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
        }
        visitor.visit(deleteStmt);
        visitor.println();
        visitor.endVisit(deleteStmt);
        FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
        invocation.getArgs()[0] = newMs;
        logJson.put("newSql", (Object)newSql.toString());
        logger.debug(String.format("newSQL --->%1$s", newSql.toString()));
    }
}

