/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanMap;
import org.springframework.beans.BeanWrapperImpl;

public class CopyUtil {
    public static <T> T copy(Object src, Class<T> targetType) {
        T target = null;
        try {
            target = targetType.newInstance();
            BeanWrapperImpl targetBean = new BeanWrapperImpl(target);
            BeanMap srcBean = new BeanMap(src);
            for (Object key : srcBean.keySet()) {
                String srcPropertyName = String.valueOf(key);
                Object srcPropertyVal = srcBean.get(key);
                Class srcPropertyType = srcBean.getType(srcPropertyName);
                Class targetPropertyType = targetBean.getPropertyType(srcPropertyName);
                if ("class".equals(srcPropertyName) || targetPropertyType == null) continue;
                if (srcPropertyType == targetPropertyType) {
                    targetBean.setPropertyValue(srcPropertyName, srcPropertyVal);
                    continue;
                }
                if (srcPropertyVal == null) continue;
                Object targetPropertyVal = targetPropertyType.newInstance();
                BeanWrapperImpl targetPropertyBean = new BeanWrapperImpl(targetPropertyVal);
                BeanMap srcPropertyBean = new BeanMap(srcPropertyVal);
                for (Object srcPropertyBeanKey : srcPropertyBean.keySet()) {
                    String srcPropertyBeanPropertyName = String.valueOf(srcPropertyBeanKey);
                    Object srcPropertyBeanPropertyVal = srcPropertyBean.get(srcPropertyBeanKey);
                    Class srcPropertyBeanPropertyType = srcPropertyBean.getType(srcPropertyBeanPropertyName);
                    Class targetPropertyBeanPropertyType = targetPropertyBean.getPropertyType(srcPropertyBeanPropertyName);
                    if ("class".equals(srcPropertyBeanPropertyName) || targetPropertyBeanPropertyType == null || srcPropertyBeanPropertyType != targetPropertyBeanPropertyType) continue;
                    targetPropertyBean.setPropertyValue(srcPropertyBeanPropertyName, srcPropertyBeanPropertyVal);
                }
                targetBean.setPropertyValue(srcPropertyName, targetPropertyBean.getWrappedInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    public static <T> List<T> copyList(List srcList, Class<T> targetType) {
        ArrayList<T> newList = new ArrayList<T>();
        for (Object entity : srcList) {
            newList.add(CopyUtil.copy(entity, targetType));
        }
        return newList;
    }
}

