/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.util.ServiceAssert;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.document.AbstractXlsxStreamingView;

public class ExcelStreamView
extends AbstractXlsxStreamingView {
    private String fileName = "reponse";
    private int rowNum = 0;
    private Workbook workbook;
    private Sheet sheet;
    private boolean numberToText = true;
    private Consumer<ExcelStreamView> beforeStrength;
    private Consumer<ExcelStreamView> afterStrength;
    private CellStyle textCellStype;
    List<Object> headList;
    List<Object> fieldList;
    List<Object> dataList;
    List<Integer> widthList;

    public ExcelStreamView(List<Object> headList, List<Object> fieldList, List<Object> dataList) {
        this.headList = headList;
        this.fieldList = fieldList;
        this.dataList = dataList;
    }

    public ExcelStreamView(List<Object> headAndField, List<Object> dataList) {
        ArrayList<Object> headArrayList = new ArrayList<Object>();
        ArrayList<Object> fieldArrayList = new ArrayList<Object>();
        ArrayList<Integer> widthArrayList = new ArrayList<Integer>();
        for (Object obj : headAndField) {
            String haf = obj.toString();
            String[] haw = haf.split("##");
            ServiceAssert.isTrue(haw.length == 3, String.format("EXCEL\u5bfc\u51faHEAD\u5934\u8bbe\u7f6e\u5b57\u6bb5\u957f\u5ea6\u51fa\u9519[%s]", haf));
            headArrayList.add(haw[0]);
            fieldArrayList.add(haw[1]);
            widthArrayList.add(Integer.parseInt(haw[2]));
        }
        this.headList = headArrayList;
        this.fieldList = fieldArrayList;
        this.widthList = widthArrayList;
        this.dataList = dataList;
    }

    protected void buildExcelDocument(Map<String, Object> model, Workbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.workbook = workbook;
        this.textCellStype = this.workbook.createCellStyle();
        DataFormat dataFormat = this.workbook.createDataFormat();
        this.textCellStype.setDataFormat(dataFormat.getFormat("@"));
        this.sheet = workbook.createSheet("page-1");
        if (this.beforeStrength != null) {
            this.beforeStrength.accept(this);
        }
        this.setHead();
        this.setWidth();
        this.setBody();
        if (this.afterStrength != null) {
            this.beforeStrength.accept(this);
        }
        response.setHeader("Content-disposition", "attachment;filename=" + this.fileName + ".xlsx");
    }

    public Row newRow() {
        Row row = this.sheet.createRow(this.rowNum++);
        return row;
    }

    private void setBody() {
        for (int j = 0; j < this.dataList.size(); ++j) {
            JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)this.dataList.get(j)));
            Row row = this.newRow();
            for (int i = 0; i < this.fieldList.size(); ++i) {
                String s = this.fieldList.get(i).toString();
                Cell cell = row.createCell(i);
                Object value = data.get(s);
                if (value == null) {
                    value = "";
                }
                if (value instanceof Number) {
                    if (this.numberToText) {
                        cell.setCellType(1);
                        cell.setCellStyle(this.textCellStype);
                    }
                    cell.setCellValue(Double.valueOf(String.valueOf(value)).doubleValue());
                    continue;
                }
                if (value instanceof Timestamp) {
                    cell.setCellValue(new Date(((Timestamp)value).getTime()));
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                    continue;
                }
                if (value instanceof Calendar) {
                    cell.setCellValue((Calendar)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                    continue;
                }
                cell.setCellValue(String.valueOf(value));
            }
        }
    }

    private void setWidth() {
        if (this.widthList != null && this.widthList.size() > 0) {
            for (int i = 0; i < this.widthList.size(); ++i) {
                this.sheet.setColumnWidth(i, this.widthList.get(i) * 268);
            }
        }
    }

    private void setHead() {
        Row row = this.newRow();
        for (int i = 0; i < this.headList.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(this.headList.get(i).toString());
        }
    }

    public ModelAndView mav() {
        return new ModelAndView((View)this);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Consumer<ExcelStreamView> getBeforeStrength() {
        return this.beforeStrength;
    }

    public void setBeforeStrength(Consumer<ExcelStreamView> beforeStrength) {
        this.beforeStrength = beforeStrength;
    }

    public Consumer<ExcelStreamView> getAfterStrength() {
        return this.afterStrength;
    }

    public void setAfterStrength(Consumer<ExcelStreamView> afterStrength) {
        this.afterStrength = afterStrength;
    }

    public boolean isNumberToText() {
        return this.numberToText;
    }

    public void setNumberToText(boolean numberToText) {
        this.numberToText = numberToText;
    }
}

