/*
 * Decompiled with CFR 0.152.
 */
package com.product.rest.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.product.model.ServiceResponse;
import com.product.rest.interceptor.ClientHttpResponseWrapper;
import com.product.util.MapAs;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class CustomClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CustomClientHttpRequestInterceptor.class);
    private static final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    ConfigurableEnvironment environment;

    public CustomClientHttpRequestInterceptor(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response;
        String deployMode = this.environment.getProperty("service.deploy.mode");
        if ("tomcat".equals(deployMode)) {
            ClientHttpResponse mockResponse = this.forwardRequest(request, body);
            return mockResponse;
        }
        String successTag = "\u6210\u529f";
        Map<String, Object> requestMap = this.getRequest(request, body);
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        long startTimeMillis = System.currentTimeMillis();
        try {
            response = execution.execute(request, body);
        }
        catch (IOException ioe) {
            successTag = "\u5931\u8d25";
            throw ioe;
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTimeMillis;
            stateMap.put("CurrentTime", formatter.format(new Date()));
            stateMap.put("RestURI", request.getURI());
            stateMap.put("StateTag", successTag);
            stateMap.put("elapsed", elapsed);
        }
        ClientHttpResponseWrapper wraper = new ClientHttpResponseWrapper(response);
        Map<String, Object> responseMap = this.getResponse(wraper);
        Map<String, Map<String, Object>> loggerMap = MapAs.of("requestMap", requestMap, "stateMap", stateMap, "responseMap", responseMap);
        logger.info("intercept->{}", (Object)JSON.toJSONString(loggerMap));
        return wraper;
    }

    private ClientHttpResponse forwardRequest(HttpRequest request, byte[] body) {
        String result = this.run(this.parseParameter(request.getURI().getQuery(), body), request, body);
        if (result == null) {
            ServiceResponse serviceResponse = ServiceResponse.buildFailure(null, "10000", "\u672c\u5730\u670d\u52a1\u5f02\u5e38\uff0c\u83b7\u53d6\u4e0d\u5230\u8fd4\u56de\u6570\u636e\uff01\uff01\uff01");
            result = JSON.toJSONString((Object)serviceResponse);
        }
        MockClientHttpResponse mockResponse = new MockClientHttpResponse(result.getBytes(StandardCharsets.UTF_8), HttpStatus.OK);
        mockResponse.getHeaders().set("Accept", "text/plain, application/json, application/*+json, */*");
        mockResponse.getHeaders().set("Content-Type", "application/json;charset=UTF-8");
        mockResponse.getHeaders().set("Accept-Charset", "big5, big5-hkscs, cesu-8, euc-jp, euc-kr, gb18030, gb2312, gbk, ibm-thai, ibm00858, ibm01140, ibm01141, ibm01142, ibm01143, ibm01144, ibm01145, ibm01146, ibm01147, ibm01148, ibm01149, ibm037, ibm1026, ibm1047, ibm273, ibm277, ibm278, ibm280, ibm284, ibm285, ibm290, ibm297, ibm420, ibm424, ibm437, ibm500, ibm775, ibm850, ibm852, ibm855, ibm857, ibm860, ibm861, ibm862, ibm863, ibm864, ibm865, ibm866, ibm868, ibm869, ibm870, ibm871, ibm918, iso-2022-cn, iso-2022-jp, iso-2022-jp-2, iso-2022-kr, iso-8859-1, iso-8859-13, iso-8859-15, iso-8859-2, iso-8859-3, iso-8859-4, iso-8859-5, iso-8859-6, iso-8859-7, iso-8859-8, iso-8859-9, jis_x0201, jis_x0212-1990, koi8-r, koi8-u, shift_jis, tis-620, us-ascii, utf-16, utf-16be, utf-16le, utf-32, utf-32be, utf-32le, utf-8, windows-1250, windows-1251, windows-1252, windows-1253, windows-1254, windows-1255, windows-1256, windows-1257, windows-1258, windows-31j, x-big5-hkscs-2001, x-big5-solaris, x-compound_text, x-euc-jp-linux, x-euc-tw, x-eucjp-open, x-ibm1006, x-ibm1025, x-ibm1046, x-ibm1097, x-ibm1098, x-ibm1112, x-ibm1122, x-ibm1123, x-ibm1124, x-ibm1166, x-ibm1364, x-ibm1381, x-ibm1383, x-ibm300, x-ibm33722, x-ibm737, x-ibm833, x-ibm834, x-ibm856, x-ibm874, x-ibm875, x-ibm921, x-ibm922, x-ibm930, x-ibm933, x-ibm935, x-ibm937, x-ibm939, x-ibm942, x-ibm942c, x-ibm943, x-ibm943c, x-ibm948, x-ibm949, x-ibm949c, x-ibm950, x-ibm964, x-ibm970, x-iscii91, x-iso-2022-cn-cns, x-iso-2022-cn-gb, x-iso-8859-11, x-jis0208, x-jisautodetect, x-johab, x-macarabic, x-maccentraleurope, x-maccroatian, x-maccyrillic, x-macdingbat, x-macgreek, x-machebrew, x-maciceland, x-macroman, x-macromania, x-macsymbol, x-macthai, x-macturkish, x-macukraine, x-ms932_0213, x-ms950-hkscs, x-ms950-hkscs-xp, x-mswin-936, x-pck, x-sjis_0213, x-utf-16le-bom, x-utf-32be-bom, x-utf-32le-bom, x-windows-50220, x-windows-50221, x-windows-874, x-windows-949, x-windows-950, x-windows-iso2022jp");
        return mockResponse;
    }

    private Map<String, Object> getRequest(HttpRequest request, byte[] body) throws IOException {
        Map<String, Object> requestMap = MapAs.of("URI", request.getURI(), "Method", request.getMethod(), "Headers", request.getHeaders(), "Body", new String(body, "UTF-8"));
        return requestMap;
    }

    private Map<String, Object> getResponse(ClientHttpResponseWrapper response) throws IOException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        StringBuilder inputStringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
        String line = bufferedReader.readLine();
        while (line != null) {
            inputStringBuilder.append(line);
            inputStringBuilder.append('\n');
            line = bufferedReader.readLine();
        }
        response.getBody().close();
        ByteArrayInputStream bais = new ByteArrayInputStream(inputStringBuilder.toString().getBytes("UTF-8"));
        response.setDataBody(bais);
        responseMap.put("StatusCode", response.getStatusCode());
        responseMap.put("StatusText", response.getStatusText());
        responseMap.put("Headers", response.getHeaders());
        if (logger.isDebugEnabled()) {
            responseMap.put("Body", inputStringBuilder.toString());
        }
        return responseMap;
    }

    private String run(Map<String, String> parameters, HttpRequest request, byte[] body) {
        long start = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        ServiceResponse response = null;
        String service_forward_rule = this.environment.getProperty("service.forward.rule");
        if (StringUtils.isBlank((CharSequence)service_forward_rule)) {
            response = ServiceResponse.buildFailure(null, "10000", "\u83b7\u53d6\u4e0d\u5230\u6620\u5c04\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\uff01\uff01\uff01");
            return JSON.toJSONString((Object)response);
        }
        Map<String, String> ruleMap = this.arraytoMap(service_forward_rule.split(";"));
        String result = this.onRoute(request, body, ruleMap);
        logger.info("run\u65b9\u6cd5\u5171\u8017\u8d39: {}", (Object)(end - start));
        return result;
    }

    private Map<String, String> arraytoMap(String[] array) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String element : array) {
            String key = StringUtils.substringBefore((String)element, (String)":");
            String value = StringUtils.substringAfter((String)element, (String)":");
            value = value.replaceAll("\\{", "").replaceAll("\\}", "");
            map.put(key, value);
        }
        return map;
    }

    private Map<String, String> parseParameter(String queryStr, byte[] body) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)queryStr)) {
            String[] kvs = queryStr.split("&");
            if (kvs.length > 0) {
                for (String kv : kvs) {
                    String[] param = kv.split("=");
                    if (param.length <= 1) continue;
                    params.put(param[0], param[1]);
                }
            }
            if (body != null && body.length > 0) {
                String bodyStr = new String(body);
                params.putAll((Map)JSONObject.parseObject((String)bodyStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]));
            }
        }
        return params;
    }

    private String onRoute(HttpRequest request, byte[] body, Map<String, String> ruleMap) {
        RestTemplate template = null;
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(3000);
        requestFactory.setReadTimeout(10000);
        template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        template.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        ServiceResponse response = null;
        String result = "";
        try {
            String requestURI = request.getURI().getPath();
            String httpMethod = request.getMethod().toString();
            StringBuffer buffer = new StringBuffer();
            Map<String, String> params = this.onGetURLParams(request, buffer);
            HttpEntity<String> postEntity = null;
            try {
                postEntity = this.onGetHttpEntity(request, httpMethod, body);
                ResponseEntity responseEntity = null;
                String requestUrl = request.getURI().toString();
                String relativePath = StringUtils.substringAfter((String)StringUtils.substringAfter((String)requestUrl, (String)"//"), (String)"/");
                String instanceId = request.getURI().getHost().toLowerCase();
                if (relativePath.indexOf("%25") > 0) {
                    relativePath = relativePath.replaceAll("25", "");
                }
                if (StringUtils.isBlank((CharSequence)ruleMap.get(instanceId))) {
                    logger.info(String.format("instanceId:{%1$s}\u672a\u914d\u7f6e\u6620\u5c04", instanceId));
                    ServiceResponse.buildFailure(null, "10000", String.format("instanceId:{%1$s}\u672a\u914d\u7f6e\u6620\u5c04", instanceId));
                }
                String remoteURL = "http://" + ruleMap.get(instanceId).toString() + "/" + relativePath;
                logger.info("### \u62e6\u622a\u540enew URL: {}", (Object)remoteURL);
                if (!StringUtils.isEmpty((CharSequence)remoteURL)) {
                    URI uRI = template.getUriTemplateHandler().expand(remoteURL, params);
                }
                if ("POST".equalsIgnoreCase(httpMethod)) {
                    result = (String)template.postForEntity(remoteURL, postEntity, String.class, params).getBody();
                    responseEntity = ResponseEntity.ok((Object)result);
                } else {
                    responseEntity = template.getForEntity(remoteURL, String.class, params);
                }
                result = (String)responseEntity.getBody();
            }
            catch (IOException e) {
                response = ServiceResponse.buildFailure(null, "10000", "\u8f6c\u6362\u670d\u52a1POST\u53c2\u6570\u5f02\u5e38:\u3010{0}\u3011", e.getMessage());
                return JSON.toJSONString((Object)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Map<String, String> onGetURLParams(HttpRequest request, StringBuffer buffer) {
        Map<String, String> response = this.parseParameter(request.getURI().getQuery(), null);
        buffer.append("?").append(request.getURI().getQuery());
        return response;
    }

    private HttpEntity<String> onGetHttpEntity(HttpRequest request, String httpMethod, byte[] body) throws IOException {
        HttpEntity response = null;
        String postParams = null;
        if ("POST".equalsIgnoreCase(httpMethod)) {
            HttpHeaders headers = request.getHeaders();
            postParams = new String(body, StandardCharsets.UTF_8);
            logger.info("\u8f6c\u53d1\u8bf7\u6c42\u53c2\u6570\uff1a---->>>>>{}", (Object)postParams);
            response = new HttpEntity((Object)postParams, (MultiValueMap)headers);
        }
        return response;
    }
}

