/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.parser;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Joiner;
import com.product.storage.parser.QuerySelectExtractor;
import com.product.storage.parser.QuerySelectField;
import com.product.util.MapAs;
import com.shiji.core.annotation.ModelSensor;
import com.shiji.core.annotation.ModelSensors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class QuerySelectBeanExtractor<T>
extends QuerySelectExtractor {
    private static final Logger log = LoggerFactory.getLogger(QuerySelectBeanExtractor.class);
    private Class<T> classzz;
    private ModelSensor[] sensors;
    private Map<String, ModelSensor> sensorMap;

    public QuerySelectBeanExtractor(String collectionName, Query query, String mycatTag, Class<T> classzz) {
        super(collectionName, query, mycatTag);
        this.classzz = classzz;
        this.sensors = null;
        this.sensorMap = new HashMap<String, ModelSensor>();
        if (this.classzz.isAnnotationPresent(ModelSensors.class) || this.classzz.isAnnotationPresent(ModelSensor.class)) {
            for (ModelSensor sensor : this.sensors = (ModelSensor[])this.classzz.getAnnotationsByType(ModelSensor.class)) {
                System.out.println(String.format("tableName:%1$s Alias:%2$s Relation:%3$s Fields:%4$s", sensor.tableName(), sensor.tableAlias(), sensor.conjunction(), Joiner.on((String)",").join((Object[])sensor.fields())));
                for (String fieldName : sensor.fields()) {
                    if (this.sensorMap.containsKey(fieldName)) continue;
                    this.sensorMap.put(fieldName, sensor);
                }
            }
        }
    }

    private void output(Query query) {
        System.out.println(String.format("--->query.getQueryObject:%1$s", JSON.toJSONString((Object)(query.getQueryObject() == null ? "" : query.getQueryObject()))));
        System.out.println(String.format("--->query.getHint:%1$s", JSON.toJSONString((Object)(query.getHint() == null ? "" : query.getHint()))));
        System.out.println(String.format("--->query.getLimit:%1$s", JSON.toJSONString((Object)query.getLimit())));
        System.out.println(String.format("--->query.getFieldsObject:%1$s", JSON.toJSONString((Object)(query.getFieldsObject() == null ? "" : query.getFieldsObject()))));
        System.out.println(String.format("--->query.getSkip:%1$s", JSON.toJSONString((Object)query.getSkip())));
        System.out.println(String.format("--->query.getSortObject:%1$s", JSON.toJSONString((Object)(query.getSortObject() == null ? "" : query.getSortObject()))));
    }

    private Map.Entry<Boolean, Boolean> generateFieldList(Query query, List<QuerySelectField> fieldList, List<QuerySelectField> sortList, List<QuerySelectField> queryList) {
        HashMap<Boolean, Boolean> responseMap = new HashMap<Boolean, Boolean>();
        boolean isAllField = false;
        boolean isSensors = false;
        if (query != null) {
            Object fieldValue;
            ModelSensor sensor;
            QuerySelectField field;
            Document fieldObj;
            if (query.getFieldsObject() != null) {
                fieldObj = query.getFieldsObject();
                if (fieldObj.keySet().isEmpty()) {
                    isAllField = true;
                    QuerySelectField field2 = new QuerySelectField();
                    field2.setFieldName("*");
                    field2.setAliasName("");
                    fieldList.add(field2);
                    Iterator<String> iterator = this.sensorMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        isSensors = true;
                        String fieldName = iterator.next();
                        QuerySelectField addField = new QuerySelectField();
                        fieldList.add(addField);
                        addField.setFieldName(fieldName);
                        addField.setAliasName(this.sensorMap.get(fieldName).tableAlias());
                    }
                } else {
                    for (String key : fieldObj.keySet()) {
                        Object value = fieldObj.get((Object)key);
                        if (!(value instanceof Integer) || (Integer)value != 1) continue;
                        field = new QuerySelectField();
                        fieldList.add(field);
                        field.setFieldName(key);
                        if (this.sensorMap.containsKey(key)) {
                            sensor = this.sensorMap.get(key);
                            field.setAliasName(sensor.tableAlias());
                            isSensors = true;
                            continue;
                        }
                        field.setAliasName("");
                    }
                }
            }
            if (query.getSortObject() != null) {
                fieldObj = query.getSortObject();
                for (String fieldName : fieldObj.keySet()) {
                    fieldValue = fieldObj.get((Object)fieldName);
                    field = new QuerySelectField();
                    sortList.add(field);
                    field.setFieldName(fieldName);
                    field.setFieldValue(fieldValue);
                    if (this.sensorMap.containsKey(fieldName)) {
                        sensor = this.sensorMap.get(fieldName);
                        field.setAliasName(sensor.tableAlias());
                        isSensors = true;
                        continue;
                    }
                    field.setAliasName("");
                }
            }
            if (query.getQueryObject() != null) {
                fieldObj = query.getQueryObject();
                for (String fieldName : fieldObj.keySet()) {
                    fieldValue = fieldObj.get((Object)fieldName);
                    field = new QuerySelectField();
                    queryList.add(field);
                    field.setFieldName(fieldName);
                    field.setFieldValue(fieldValue);
                    if (this.sensorMap.containsKey(fieldName)) {
                        sensor = this.sensorMap.get(fieldName);
                        field.setAliasName(sensor.tableAlias());
                        isSensors = true;
                        continue;
                    }
                    field.setAliasName("");
                }
            }
        }
        responseMap.put(isAllField, isSensors);
        return (Map.Entry)responseMap.entrySet().stream().findFirst().get();
    }

    private String generateTable(List<QuerySelectField> fieldList, List<QuerySelectField> sortList, List<QuerySelectField> queryList) {
        LinkedHashSet<ModelSensor> sensorSet = new LinkedHashSet<ModelSensor>();
        ArrayList<QuerySelectField> allFieldList = new ArrayList<QuerySelectField>();
        allFieldList.addAll(fieldList);
        allFieldList.addAll(sortList);
        allFieldList.addAll(queryList);
        for (QuerySelectField field : allFieldList) {
            if (StringUtils.isEmpty((String)field.getAliasName())) {
                field.setAliasName("TA");
            }
            if (!this.sensorMap.containsKey(field.getFieldName())) continue;
            ModelSensor sensor = this.sensorMap.get(field.getFieldName());
            sensorSet.add(sensor);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("%1$s TA ", this.collectionName));
        for (ModelSensor sensor : sensorSet) {
            buffer.append(String.format(" inner join %1$s %2$s ", sensor.tableName(), sensor.tableAlias()));
            buffer.append(String.format(" on %1$s ", sensor.conjunction()));
        }
        return buffer.toString();
    }

    @Override
    protected Optional<Map.Entry<String, Query>> exchangeQuery(String collectionName, Query query) {
        ArrayList<QuerySelectField> fieldList = new ArrayList<QuerySelectField>();
        ArrayList<QuerySelectField> sortList = new ArrayList<QuerySelectField>();
        ArrayList<QuerySelectField> queryList = new ArrayList<QuerySelectField>();
        boolean isAllField = false;
        boolean isSensors = false;
        this.output(query);
        Map.Entry<Boolean, Boolean> entry = this.generateFieldList(query, fieldList, sortList, queryList);
        isAllField = entry.getKey();
        isSensors = entry.getValue();
        if (isSensors) {
            String tableName = this.generateTable(fieldList, sortList, queryList);
            Query nQuery = new Query();
            if (queryList.size() > 0) {
                for (QuerySelectField field : queryList) {
                    Criteria criteria = Criteria.where((String)String.format("%1$s.%2$s", field.getAliasName(), field.getFieldName())).is(field.getFieldValue());
                    nQuery.addCriteria((CriteriaDefinition)criteria);
                }
            }
            for (QuerySelectField queryField : fieldList) {
                if (!StringUtils.isEmpty((String)queryField.getAliasName())) {
                    nQuery.fields().include(String.format("%1$s.%2$s", queryField.getAliasName(), queryField.getFieldName()));
                    continue;
                }
                nQuery.fields().include(queryField.getFieldName());
            }
            nQuery.limit(query.getLimit());
            nQuery.skip(query.getSkip());
            if (sortList.size() > 0) {
                ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
                Sort sort = Sort.by(orders);
                for (QuerySelectField field : sortList) {
                    String fieldName = String.format("%1$s.%2$s", field.getAliasName(), field.getFieldName());
                    Integer orderValue = TypeUtils.castToInt((Object)field.getFieldValue());
                    Sort.Order order = new Sort.Order(orderValue.equals(1) ? Sort.Direction.ASC : Sort.Direction.DESC, fieldName);
                    orders.add(order);
                }
                nQuery.with(sort);
            }
            Map<String, Query> responseMap = MapAs.of(tableName, nQuery);
            Optional<Map.Entry<String, Query>> response = responseMap.entrySet().stream().findFirst();
            return response;
        }
        return super.exchangeQuery(collectionName, query);
    }
}

