/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.product.storage.parser.ExprTranslator;
import com.product.storage.parser.QueryExtractor;
import com.product.util.MapAs;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;

public class QuerySelectExtractor
extends QueryExtractor {
    private Query query;
    private boolean needOrderBy = true;
    private String mycatTag;

    public QuerySelectExtractor(String collectionName, Query query, String mycatTag) {
        this.collectionName = collectionName;
        this.query = query;
        this.mycatTag = mycatTag;
    }

    @Override
    protected String getMyCatTag() {
        return StringUtils.isBlank((String)this.mycatTag) ? "" : this.mycatTag;
    }

    @Override
    public String getQueryForMongo() {
        StringBuilder sb = new StringBuilder();
        sb.append("db").append(".").append(this.collectionName).append(".find(").append(this.getMongoQueryString(this.query));
        if (this.query != null && this.query.getFieldsObject() != null) {
            sb.append(",").append(SerializationUtils.serializeToJsonSafely((Object)this.query.getFieldsObject()));
        }
        sb.append(")");
        if (this.query != null && this.query.getSortObject() != null) {
            sb.append(".sort(").append(SerializationUtils.serializeToJsonSafely((Object)this.query.getSortObject())).append(")");
        }
        if (this.query != null && this.query.getLimit() > 0) {
            sb.append(".limit(").append(this.query.getLimit()).append(")");
        }
        return sb.toString();
    }

    protected Optional<Map.Entry<String, Query>> exchangeQuery(String collectionName, Query query) {
        Map<String, Query> responseMap = MapAs.of(collectionName, query);
        Optional<Map.Entry<String, Query>> response = responseMap.entrySet().stream().findFirst();
        return response;
    }

    @Override
    public String getQueryForSQL() {
        SQLSelect select = null;
        switch (this.SQLDBType) {
            case ORACLE: {
                select = new SQLSelect();
                break;
            }
            case SQLSERVER: {
                select = new SQLSelect();
                break;
            }
            default: {
                select = new SQLSelect();
            }
        }
        Optional<Map.Entry<String, Query>> optionalEntry = this.exchangeQuery(this.collectionName, this.query);
        String tableName = optionalEntry.get().getKey();
        Query newQuery = optionalEntry.get().getValue();
        select.setQuery(this.parseSelectQuery(tableName, newQuery));
        if (this.needOrderBy) {
            select.setOrderBy(this.parseOrderBy(newQuery));
        }
        PGSelectStatement stmt = null;
        switch (this.SQLDBType) {
            case POSTGRESQL: {
                stmt = new PGSelectStatement(select);
                break;
            }
            default: {
                stmt = new SQLSelectStatement(select);
            }
        }
        return this.getSQL((SQLStatement)stmt);
    }

    private SQLOrderBy parseOrderBy(Query query) {
        SQLOrderBy orderBy = new SQLOrderBy();
        if (query != null && query.getSortObject() != null) {
            Document sortObj = query.getSortObject();
            for (String key : sortObj.keySet()) {
                SQLSelectOrderByItem item = new SQLSelectOrderByItem();
                item.setExpr(ExprTranslator.translateKey(key));
                Integer value = (Integer)sortObj.get((Object)key);
                if (value == 1) {
                    item.setType(SQLOrderingSpecification.ASC);
                } else if (value == -1) {
                    item.setType(SQLOrderingSpecification.DESC);
                }
                orderBy.addItem(item);
            }
        }
        return orderBy;
    }

    private SQLSelectQuery parseSelectQuery(String collectionName, Query query) {
        DB2SelectQueryBlock queryBlock = null;
        switch (this.SQLDBType) {
            case DB2: {
                queryBlock = new DB2SelectQueryBlock();
                break;
            }
            case MYSQL: 
            case SQLITE: {
                queryBlock = new MySqlSelectQueryBlock();
                break;
            }
            case ORACLE: {
                queryBlock = new OracleSelectQueryBlock();
                break;
            }
            case SQLSERVER: {
                queryBlock = new SQLServerSelectQueryBlock();
                break;
            }
            case POSTGRESQL: {
                queryBlock = new PGSelectQueryBlock();
                break;
            }
            default: {
                queryBlock = new SQLSelectQueryBlock();
            }
        }
        if (query != null && query.getLimit() > 0 && queryBlock instanceof MySqlSelectQueryBlock) {
            ((MySqlSelectQueryBlock)queryBlock).setOrderBy(this.parseOrderBy(query));
            this.needOrderBy = false;
        }
        queryBlock.setFrom((SQLTableSource)ExprTranslator.translateTableName(collectionName));
        this.parseSelectList(query, (SQLSelectQueryBlock)queryBlock);
        this.parseWhere(query, (SQLSelectQueryBlock)queryBlock);
        return queryBlock;
    }

    private void parseWhere(Query query, SQLSelectQueryBlock queryBlock) {
        if (query != null && query.getQueryObject() != null) {
            Document queryObj = query.getQueryObject();
            queryBlock.setWhere(ExprTranslator.translateWhere(queryObj, this.SQLDBType));
        }
    }

    private void parseSelectList(Query query, SQLSelectQueryBlock queryBlock) {
        List selectList = queryBlock.getSelectList();
        if (query != null && query.getFieldsObject() != null) {
            Document fieldObj = query.getFieldsObject();
            if (fieldObj.keySet().isEmpty()) {
                SQLSelectItem selectItem = new SQLSelectItem((SQLExpr)new SQLAllColumnExpr(), null);
                selectList.add(selectItem);
            } else {
                for (String key : fieldObj.keySet()) {
                    Object value = fieldObj.get((Object)key);
                    if (!(value instanceof Integer) || (Integer)value != 1) continue;
                    SQLSelectItem selectItem = new SQLSelectItem(ExprTranslator.translateKey(key), null);
                    selectList.add(selectItem);
                }
            }
        } else {
            SQLSelectItem selectItem = new SQLSelectItem((SQLExpr)new SQLAllColumnExpr(), null);
            selectList.add(selectItem);
        }
    }
}

