/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.product.storage.parser.ExprTranslator;
import com.product.storage.parser.MongoExpr;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.parser.SQLTextExpr;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.Update;

public class QueryUpdateExtractor
extends QueryExtractor {
    private Query query;
    private Update update;
    private boolean upsert;
    private boolean multi;
    private String mycatTag;

    public QueryUpdateExtractor(String collectionName, Query query, Update update, String mycatTag) {
        this(collectionName, query, update, false, true, mycatTag);
    }

    public QueryUpdateExtractor(String collectionName, Query query, Update update, boolean upsert, boolean multi, String mycatTag) {
        this.collectionName = collectionName;
        this.query = query;
        this.update = update;
        this.upsert = upsert;
        this.multi = multi;
        this.mycatTag = mycatTag;
    }

    @Override
    protected String getMyCatTag() {
        return StringUtils.isBlank((String)this.mycatTag) ? "" : this.mycatTag;
    }

    @Override
    public String getQueryForMongo() {
        StringBuilder sb = new StringBuilder();
        sb.append("db").append(".").append(this.collectionName).append(".update(").append(this.getMongoQueryString(this.query));
        if (this.update != null) {
            sb.append(", ");
            sb.append(SerializationUtils.serializeToJsonSafely((Object)this.update.getUpdateObject()));
        }
        if (this.upsert || this.multi) {
            sb.append(", {");
            String key = "upsert";
            if (this.multi) {
                key = "multi";
            }
            sb.append("\"").append(key).append("\" : true");
            sb.append("}");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getQueryForSQL() {
        if (this.upsert) {
            throw new IllegalArgumentException("Upsert not supported");
        }
        MySqlUpdateStatement stmt = null;
        switch (this.SQLDBType) {
            case MYSQL: {
                stmt = new MySqlUpdateStatement();
                break;
            }
            case ORACLE: {
                stmt = new OracleUpdateStatement();
                break;
            }
            case SQLSERVER: {
                stmt = new SQLServerUpdateStatement();
                break;
            }
            case POSTGRESQL: {
                stmt = new PGUpdateStatement();
                break;
            }
            default: {
                stmt = new SQLUpdateStatement();
            }
        }
        stmt.setTableSource((SQLTableSource)ExprTranslator.translateTableName(this.collectionName));
        if (this.query != null && this.query.getQueryObject() != null) {
            stmt.setWhere(ExprTranslator.translateWhere(this.query.getQueryObject(), this.SQLDBType));
        }
        this.parseSetItems(this.update, (SQLUpdateStatement)stmt);
        if (!this.multi && stmt instanceof MySqlUpdateStatement) {
            SQLLimit limit = new SQLLimit();
            limit.setRowCount((SQLExpr)new SQLNumberExpr((Number)1));
            stmt.setLimit(limit);
        }
        return this.getSQL((SQLStatement)stmt);
    }

    private void parseSetItems(Update update, SQLUpdateStatement stmt) {
        List updateItems = stmt.getItems();
        Document updateObj = update.getUpdateObject();
        block5: for (String op : updateObj.keySet()) {
            Document obj = (Document)updateObj.get((Object)op);
            switch (MongoExpr.fromString(op)) {
                case 22: {
                    SQLUpdateSetItem item;
                    for (String key : obj.keySet()) {
                        item = new SQLUpdateSetItem();
                        item.setColumn(ExprTranslator.translateKey(key));
                        item.setValue(ExprTranslator.parseObject(obj.get((Object)key), this.SQLDBType));
                        updateItems.add(item);
                    }
                    continue block5;
                }
                case 24: {
                    SQLUpdateSetItem item;
                    for (String key : obj.keySet()) {
                        item = new SQLUpdateSetItem();
                        item.setColumn(ExprTranslator.translateKey(key));
                        item.setValue((SQLExpr)new SQLTextExpr("null"));
                        updateItems.add(item);
                    }
                    continue block5;
                }
                case 23: {
                    SQLUpdateSetItem item;
                    for (String key : obj.keySet()) {
                        item = new SQLUpdateSetItem();
                        SQLExpr keyExpr = ExprTranslator.translateKey(key);
                        item.setColumn(keyExpr);
                        SQLExpr incValueExpr = ExprTranslator.parseObject(obj.get((Object)key), this.SQLDBType);
                        SQLBinaryOpExpr valExpr = new SQLBinaryOpExpr(keyExpr, SQLBinaryOperator.Add, incValueExpr);
                        item.setValue((SQLExpr)valExpr);
                        updateItems.add(item);
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported array operator: " + op);
                }
            }
        }
    }
}

