/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.fastjson.serializer.Jdk8DateDeserializer;
import com.product.fastjson.serializer.Jdk8DateSerializer;
import com.product.model.ServiceSession;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringContext {
    private static final ThreadLocal<ServiceSession> sessionThreadLocal = new InheritableThreadLocal<ServiceSession>();
    private static final ThreadLocal<Integer> pagenoThreadLocal = new InheritableThreadLocal<Integer>();
    private static final ThreadLocal<Integer> pageSizeThreadLocal = new InheritableThreadLocal<Integer>();
    private static Boolean initComplete = false;
    static ConfigurableApplicationContext context = null;
    static String applicationName;
    static String uniqueKey;
    static String eurekaValue;
    static String dataSourcekey;
    static String redisKey;
    static String eurekaKey;

    public static boolean isInitComplete() {
        return initComplete;
    }

    public static void setInitComplete(boolean initComplete) {
        SpringContext.initComplete = initComplete;
    }

    public static ServiceSession getSession() {
        return sessionThreadLocal.get();
    }

    public static void putSession(ServiceSession session) {
        sessionThreadLocal.set(session);
    }

    public static void removeSession() {
        sessionThreadLocal.remove();
    }

    public static Integer getPageSize() {
        return pageSizeThreadLocal.get();
    }

    public static void putPageSize(int pageSize) {
        pageSizeThreadLocal.set(pageSize);
    }

    public static void removePageSize() {
        pageSizeThreadLocal.remove();
    }

    public static Integer getPageno() {
        return pagenoThreadLocal.get();
    }

    public static void putPageno(int pageStart) {
        pagenoThreadLocal.set(pageStart);
    }

    public static void removePageno() {
        pagenoThreadLocal.remove();
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        SpringApplication application = new SpringApplication(new Class[]{primarySource});
        SerializeConfig.getGlobalInstance().put(LocalDateTime.class, (ObjectSerializer)new Jdk8DateSerializer());
        SerializeConfig.getGlobalInstance().put(LocalDate.class, (ObjectSerializer)new Jdk8DateSerializer());
        ParserConfig.getGlobalInstance().putDeserializer(LocalDateTime.class, (ObjectDeserializer)new Jdk8DateDeserializer());
        ParserConfig.getGlobalInstance().putDeserializer(LocalDate.class, (ObjectDeserializer)new Jdk8DateDeserializer());
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
        context = application.run(args);
        ConfigurableEnvironment environment = context.getEnvironment();
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        HashMap dataSourceMap = new HashMap();
        HashMap redisMap = new HashMap();
        mutablePropertySources.stream().forEach(propertySource -> {
            if (propertySource.getName().indexOf("application.properties") != -1) {
                Map map = (Map)propertySource.getSource();
                map.forEach((k, v) -> {
                    if (k.equals("spring.application.name")) {
                        applicationName = v.toString();
                    }
                    if (k.indexOf("datasource") != -1) {
                        if (v.toString().indexOf("$") != -1) {
                            dataSourceMap.put(k, environment.resolvePlaceholders(v.toString()));
                        } else {
                            dataSourceMap.put(k, v.toString());
                        }
                    }
                    if (k.indexOf("redis") != -1) {
                        if (v.toString().indexOf("$") != -1) {
                            redisMap.put(k, environment.resolvePlaceholders(v.toString()));
                        } else {
                            redisMap.put(k, v.toString());
                        }
                    }
                    if (k.indexOf("defaultZone") != -1) {
                        eurekaValue = environment.resolvePlaceholders(v.toString());
                    }
                });
            }
        });
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)context.getBean(StringRedisTemplate.class);
        InetUtils.HostInfo hostInfo = SpringContext.getFirstNonLoopbackHostInfo(environment);
        uniqueKey = new StringBuffer("properties:").append(applicationName).append(":").append(hostInfo.getIpAddress()).toString();
        String key = new StringBuffer(uniqueKey).append(":").toString();
        dataSourcekey = new StringBuffer(key).append("db").toString();
        redisKey = new StringBuffer(key).append("redis").toString();
        eurekaKey = new StringBuffer(key).append("eureka").toString();
        stringRedisTemplate.opsForHash().putAll((Object)dataSourcekey, dataSourceMap);
        stringRedisTemplate.opsForHash().putAll((Object)redisKey, redisMap);
        if (!StringUtils.isEmpty((Object)eurekaValue)) {
            stringRedisTemplate.opsForValue().set((Object)eurekaKey, (Object)eurekaValue);
        }
        SpringContext.setInstance(context);
        SpringContext.setInitComplete(true);
        return context;
    }

    public static String getDataSourcekey() {
        return dataSourcekey;
    }

    public static String getRedisKey() {
        return redisKey;
    }

    public static String getEurekaKey() {
        return eurekaKey;
    }

    public static String getUniqueKey() {
        return uniqueKey;
    }

    private static InetUtils.HostInfo getFirstNonLoopbackHostInfo(ConfigurableEnvironment environment) {
        InetUtilsProperties target = new InetUtilsProperties();
        ConfigurationPropertySources.attach((Environment)environment);
        Binder.get((Environment)environment).bind("spring.cloud.inetutils", Bindable.ofInstance((Object)target));
        try (InetUtils utils = new InetUtils(target);){
            InetUtils.HostInfo hostInfo = utils.findFirstNonLoopbackHostInfo();
            return hostInfo;
        }
    }

    public static Object getBean(String name) {
        return SpringContext.getContext().getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContext.getContext().getBean(name, clazz);
    }

    public static Object getBean(String name, Object ... args) {
        return SpringContext.getContext().getBean(name, args);
    }

    public static <T> T getBean(Class<T> requiredType, Object ... args) {
        return (T)SpringContext.getContext().getBean(requiredType, args);
    }

    public static BeanFactory getContext() {
        return context;
    }

    public static synchronized void setInstance(ConfigurableApplicationContext myContext) {
        context = myContext;
    }

    public static String getActiveProfile() {
        if (context == null || context.getEnvironment() == null) {
            return "";
        }
        String[] activeProfiles = context.getEnvironment().getActiveProfiles();
        if (activeProfiles.length == 0) {
            return "default";
        }
        return context.getEnvironment().getActiveProfiles()[0];
    }

    public static ConfigurableEnvironment getEnvironment() {
        return context.getEnvironment();
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes ra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ra.getRequest();
        return request;
    }

    public static class HookBean {
        @Autowired
        StringRedisTemplate stringRedisTemplate;

        @PreDestroy
        public void destroy() {
            this.stringRedisTemplate.delete((Object)SpringContext.getDataSourcekey());
            this.stringRedisTemplate.delete((Object)SpringContext.getRedisKey());
            this.stringRedisTemplate.delete((Object)SpringContext.getEurekaKey());
        }
    }
}

