/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import com.product.util.StaticVariable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class JdbcTemplateImpl
extends JdbcTemplate {
    public JdbcTemplateImpl() {
    }

    public JdbcTemplateImpl(DataSource dataSource, boolean lazyInit) {
        super(dataSource, lazyInit);
    }

    public JdbcTemplateImpl(DataSource dataSource) {
        super(dataSource);
    }

    protected String exchange(String sql) {
        String schema = StaticVariable.get("context.schema") + "";
        String entId = StaticVariable.get("context.entId") + "";
        String responseSQL = sql;
        if (!(StringUtils.isEmpty((CharSequence)schema) || StringUtils.isEmpty((CharSequence)entId) || "null".equals(schema) || "null".equals(entId))) {
            if (!sql.startsWith("/* !mycat:schema")) {
                responseSQL = String.format("/* !mycat:schema = %1$s-%2$s*/%3$s", schema, entId, sql);
            }
            System.out.println("\u5728\u6b64\u4fee\u6539SQL\uff1a" + sql + " \u6700\u7ec8SQL:" + responseSQL);
        }
        return responseSQL;
    }

    protected String[] batchExchange(String ... sql) {
        List<String> list = Arrays.asList(sql);
        ArrayList<String> response = new ArrayList<String>();
        for (String itemSQL : list) {
            String oSQL = this.exchange(itemSQL);
            response.add(oSQL);
        }
        return response.toArray(new String[response.size()]);
    }

    public void execute(String sql) throws DataAccessException {
        super.execute(this.exchange(sql));
    }

    public <T> T query(String sql, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.exchange(sql), rse);
    }

    public void query(String sql, RowCallbackHandler rch) throws DataAccessException {
        super.query(this.exchange(sql), rch);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return super.query(this.exchange(sql), rowMapper);
    }

    public Map<String, Object> queryForMap(String sql) throws DataAccessException {
        return super.queryForMap(this.exchange(sql));
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), rowMapper);
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), requiredType);
    }

    public <T> List<T> queryForList(String sql, Class<T> elementType) throws DataAccessException {
        return super.queryForList(this.exchange(sql), elementType);
    }

    public List<Map<String, Object>> queryForList(String sql) throws DataAccessException {
        return super.queryForList(this.exchange(sql));
    }

    public SqlRowSet queryForRowSet(String sql) throws DataAccessException {
        return super.queryForRowSet(this.exchange(sql));
    }

    public int update(String sql) throws DataAccessException {
        return super.update(this.exchange(sql));
    }

    public int[] batchUpdate(String ... sql) throws DataAccessException {
        String[] sqls = this.batchExchange(sql);
        return super.batchUpdate(sqls);
    }

    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException {
        return (T)super.execute(this.exchange(sql), action);
    }

    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.exchange(sql), pss, rse);
    }

    public <T> T query(String sql, Object[] args, int[] argTypes, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.exchange(sql), args, argTypes, rse);
    }

    public <T> T query(String sql, Object[] args, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.exchange(sql), args, rse);
    }

    public <T> T query(String sql, ResultSetExtractor<T> rse, Object ... args) throws DataAccessException {
        return (T)super.query(this.exchange(sql), rse, args);
    }

    public void query(String sql, PreparedStatementSetter pss, RowCallbackHandler rch) throws DataAccessException {
        super.query(this.exchange(sql), pss, rch);
    }

    public void query(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch) throws DataAccessException {
        super.query(this.exchange(sql), args, argTypes, rch);
    }

    public void query(String sql, Object[] args, RowCallbackHandler rch) throws DataAccessException {
        super.query(this.exchange(sql), args, rch);
    }

    public void query(String sql, RowCallbackHandler rch, Object ... args) throws DataAccessException {
        super.query(this.exchange(sql), rch, args);
    }

    public <T> List<T> query(String sql, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        return super.query(this.exchange(sql), pss, rowMapper);
    }

    public <T> List<T> query(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        return super.query(this.exchange(sql), args, argTypes, rowMapper);
    }

    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return super.query(sql, args, rowMapper);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return super.query(this.exchange(sql), rowMapper, args);
    }

    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), args, argTypes, rowMapper);
    }

    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), args, rowMapper);
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), rowMapper, args);
    }

    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, Class<T> requiredType) throws DataAccessException {
        return (T)super.queryForObject(sql, args, argTypes, requiredType);
    }

    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), args, requiredType);
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), requiredType, args);
    }

    public Map<String, Object> queryForMap(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return super.queryForMap(this.exchange(sql), args, argTypes);
    }

    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        return super.queryForMap(this.exchange(sql), args);
    }

    public <T> List<T> queryForList(String sql, Object[] args, int[] argTypes, Class<T> elementType) throws DataAccessException {
        return super.queryForList(this.exchange(sql), args, argTypes, elementType);
    }

    public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) throws DataAccessException {
        return super.queryForList(this.exchange(sql), args, elementType);
    }

    public <T> List<T> queryForList(String sql, Class<T> elementType, Object ... args) throws DataAccessException {
        return super.queryForList(this.exchange(sql), elementType, args);
    }

    public List<Map<String, Object>> queryForList(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return super.queryForList(this.exchange(sql), args, argTypes);
    }

    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return super.queryForList(this.exchange(sql), args);
    }

    public SqlRowSet queryForRowSet(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return super.queryForRowSet(this.exchange(sql), args, argTypes);
    }

    public SqlRowSet queryForRowSet(String sql, Object ... args) throws DataAccessException {
        return super.queryForRowSet(this.exchange(sql), args);
    }

    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException {
        return super.update(this.exchange(sql), pss);
    }

    public int update(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return super.update(this.exchange(sql), args, argTypes);
    }

    public int update(String sql, Object ... args) throws DataAccessException {
        return super.update(this.exchange(sql), args);
    }

    public int[] batchUpdate(String sql, BatchPreparedStatementSetter pss) throws DataAccessException {
        return super.batchUpdate(this.exchange(sql), pss);
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs) throws DataAccessException {
        return super.batchUpdate(this.exchange(sql), batchArgs);
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs, int[] argTypes) throws DataAccessException {
        return super.batchUpdate(this.exchange(sql), batchArgs, argTypes);
    }

    public <T> int[][] batchUpdate(String sql, Collection<T> batchArgs, int batchSize, ParameterizedPreparedStatementSetter<T> pss) throws DataAccessException {
        return super.batchUpdate(this.exchange(sql), batchArgs, batchSize, pss);
    }

    public <T> T execute(String callString, CallableStatementCallback<T> action) throws DataAccessException {
        return (T)super.execute(callString, action);
    }

    protected DataAccessException translateException(String task, String sql, SQLException ex) {
        System.out.println("\u5728\u6b64\u4fee\u6539SQL\uff1atranslateException(task)");
        return super.translateException(task, this.exchange(sql), ex);
    }

    public <T> T execute(ConnectionCallback<T> action) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539execute(ConnectionCallback)");
        return (T)super.execute(action);
    }

    public <T> T execute(StatementCallback<T> action) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539execute(StatementCallback)");
        return (T)super.execute(action);
    }

    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) throws DataAccessException {
        StackTraceElement[] traces;
        System.out.println("\u5728\u6b64\u4fee\u6539execute(PreparedStatementCreator)");
        for (StackTraceElement trace : traces = Thread.currentThread().getStackTrace()) {
            if (!trace.getClassName().equals("com.shiji.core.component.JdbcTemplateImpl")) continue;
            System.out.println(trace);
        }
        return (T)super.execute(psc, action);
    }

    public <T> T query(PreparedStatementCreator psc, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539query(PreparedStatementCreator)");
        return (T)super.query(psc, pss, rse);
    }

    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539query(PreparedStatementCreator)");
        return (T)super.query(psc, rse);
    }

    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539query(PreparedStatementCreator)");
        super.query(psc, rch);
    }

    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539query(PreparedStatementCreator)");
        return super.query(psc, rowMapper);
    }

    protected int update(PreparedStatementCreator psc, PreparedStatementSetter pss) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539update(PreparedStatementCreator)");
        return super.update(psc, pss);
    }

    public int update(PreparedStatementCreator psc) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539update(PreparedStatementCreator)");
        return super.update(psc);
    }

    public int update(PreparedStatementCreator psc, KeyHolder generatedKeyHolder) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539update(PreparedStatementCreator)");
        return super.update(psc, generatedKeyHolder);
    }

    public <T> T execute(CallableStatementCreator csc, CallableStatementCallback<T> action) throws DataAccessException {
        System.out.println("\u5728\u6b64\u4fee\u6539execute(CallableStatementCreator)");
        return (T)super.execute(csc, action);
    }
}

