/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.product.model.BaseQueryModel;
import com.product.model.ServiceSession;
import com.product.service.OperationFlag;
import com.product.util.StaticVariable;
import com.product.util.TypeUtils;
import com.shiji.core.annotation.ModelProperty;
import com.shiji.core.annotation.OpLog;
import com.shiji.core.model.OpLogModel;
import com.shiji.core.service.ILogRecoderService;
import com.shiji.core.service.OpLogService;
import com.shiji.core.util.SnowFlakeID;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnBean(name={"JdbcTemplate"})
public class OpLogServiceImpl
implements OpLogService {
    private static final Logger log = LoggerFactory.getLogger(OpLogServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ILogRecoderService recoder;
    private SnowFlakeID snowFlake = new SnowFlakeID(2L, 3L);

    public List<Map<String, Object>> onQuery(String querySQL, Long dataID) {
        log.info("OpLogServiceImpl.onQuery({},{})", (Object)querySQL, (Object)dataID);
        List response = this.jdbcTemplate.queryForList(querySQL, new Object[]{dataID});
        return response;
    }

    public void onRecoder(OpLogModel oplogModel) {
        if (this.recoder != null) {
            this.recoder.onRecoder(oplogModel);
        }
    }

    protected <T extends BaseQueryModel> OpLogModel initModel(ServiceSession session, BeanWrapper wraper, OpLog opLog) {
        OpLogModel response = new OpLogModel();
        String[] businessKeys = opLog.businessKeys();
        String[] contentKeys = opLog.contentKeys();
        Long tableKey = TypeUtils.castToLong(wraper.getPropertyValue(opLog.idKey()));
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (String fieldName : businessKeys) {
            Object value = wraper.getPropertyValue(fieldName);
            keyList.add(value);
        }
        ArrayList<Object> contentList = new ArrayList<Object>();
        for (String fieldName : contentKeys) {
            Object value = wraper.getPropertyValue(fieldName);
            contentList.add(value);
        }
        response.setOpId(this.snowFlake.nextId());
        response.setTableKey(tableKey);
        response.setOperator(session.getUser_code());
        response.setOperatDate(new Date());
        String moduleCode = StaticVariable.get("context.moduleCode") + "";
        response.setModuleCode(moduleCode);
        response.setCompanyCode(session.getErpCode());
        response.setMarketCode(session.getShop_code());
        String terminalCode = "";
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)opLog.terminalName())) {
            terminalCode = this.getValue(wraper, opLog.terminalName(), "");
        }
        response.setTerminalCode(terminalCode);
        response.setBusinessKey(Joiner.on((String)",").useForNull("none").join(keyList));
        response.setNContent(Joiner.on((String)",").useForNull("none").join(contentList));
        return response;
    }

    protected <T> T getValue(Map<String, Object> source, String keyName, T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        if (!source.containsKey(keyName)) {
            return defaultValue;
        }
        return (T)source.get(keyName);
    }

    protected <T> T getValue(BeanWrapper source, String keyName, T defaultValue) {
        PropertyDescriptor[] props;
        if (source == null) {
            return defaultValue;
        }
        for (PropertyDescriptor prop : props = source.getPropertyDescriptors()) {
            if (!prop.getName().equalsIgnoreCase(keyName)) continue;
            return (T)source.getPropertyValue(prop.getName());
        }
        return defaultValue;
    }

    protected void onInsert(ServiceSession session, BeanWrapper wraper, OpLog opLog) {
        OpLogModel oplogModel = this.initModel(session, wraper, opLog);
        oplogModel.setOperType("\u589e\u52a0");
        this.onRecoder(oplogModel);
    }

    protected void onUpdate(ServiceSession session, BeanWrapper oWraper, BeanWrapper nWraper, OpLog opLog) {
        OpLogModel oplogModel = this.initModel(session, oWraper, opLog);
        oplogModel.setOperType("\u4fee\u6539");
        Field[] fields = oWraper.getWrappedClass().getDeclaredFields();
        String[] businessKeys = opLog.businessKeys();
        String[] contentKeys = opLog.contentKeys();
        ArrayList<String> keyList = new ArrayList<String>();
        String[] stringArray = businessKeys;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ModelProperty modelProperty;
            String fieldName;
            String fileMemo = fieldName = stringArray[i];
            List fieldsfilter = Arrays.stream(fields).filter(e -> fieldName.equals(e.getName())).collect(Collectors.toList());
            if (!StringUtils.isEmpty(fieldsfilter) && fieldsfilter.size() > 0 && ((Field)fieldsfilter.get(0)).isAnnotationPresent(ModelProperty.class) && !StringUtils.isEmpty((Object)(modelProperty = ((Field)fieldsfilter.get(0)).getAnnotation(ModelProperty.class)).note())) {
                fileMemo = modelProperty.note();
            }
            String newValue = this.getValue(nWraper, fieldName, "none");
            String oldValue = this.getValue(oWraper, fieldName, "none");
            String keyValue = String.format("%1$s:%2$s -> %3$s", fileMemo, TypeUtils.castToString(oldValue), TypeUtils.castToString(newValue));
            keyList.add(keyValue);
        }
        ArrayList<String> oContentList = new ArrayList<String>();
        ArrayList<String> nContentList = new ArrayList<String>();
        String[] stringArray2 = contentKeys;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            ModelProperty modelProperty;
            String fieldName;
            String fileMemo = fieldName = stringArray2[i];
            List fieldsfilter = Arrays.stream(fields).filter(e -> fieldName.equals(e.getName())).collect(Collectors.toList());
            if (!StringUtils.isEmpty(fieldsfilter) && fieldsfilter.size() > 0 && ((Field)fieldsfilter.get(0)).isAnnotationPresent(ModelProperty.class) && !StringUtils.isEmpty((Object)(modelProperty = ((Field)fieldsfilter.get(0)).getAnnotation(ModelProperty.class)).note())) {
                fileMemo = modelProperty.note();
            }
            Object newValue = this.getValue(nWraper, fieldName, null);
            String oldValue = this.getValue(oWraper, fieldName, "none");
            String oContentValue = String.format("%1$s:%2$s", fileMemo, TypeUtils.castToString(oldValue));
            String nContentValue = String.format("%1$s:%2$s", fileMemo, TypeUtils.castToString(newValue));
            oContentList.add(oContentValue);
            nContentList.add(nContentValue);
        }
        oplogModel.setBusinessKey(Joiner.on((String)",").useForNull("none").join(keyList));
        oplogModel.setOContent(Joiner.on((String)",").useForNull("none").join(oContentList));
        oplogModel.setNContent(Joiner.on((String)",").useForNull("none").join(nContentList));
        this.onRecoder(oplogModel);
    }

    protected void onDelete(ServiceSession session, BeanWrapper wraper, OpLog opLog) {
        int n;
        OpLogModel oplogModel = this.initModel(session, wraper, opLog);
        oplogModel.setOperType("\u5220\u9664");
        Field[] fields = wraper.getWrappedClass().getDeclaredFields();
        String[] businessKeys = opLog.businessKeys();
        String[] contentKeys = opLog.contentKeys();
        ArrayList<String> keyList = new ArrayList<String>();
        String[] stringArray = businessKeys;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            ModelProperty modelProperty;
            String fieldName;
            String fileMemo = fieldName = stringArray[n];
            List fieldsfilter = Arrays.stream(fields).filter(e -> fieldName.equals(e.getName())).collect(Collectors.toList());
            if (!StringUtils.isEmpty(fieldsfilter) && fieldsfilter.size() > 0 && ((Field)fieldsfilter.get(0)).isAnnotationPresent(ModelProperty.class) && !StringUtils.isEmpty((Object)(modelProperty = ((Field)fieldsfilter.get(0)).getAnnotation(ModelProperty.class)).note())) {
                fileMemo = modelProperty.note();
            }
            String oldValue = this.getValue(wraper, fieldName, "none");
            String keyValue = String.format("%1$s:%2$s", fileMemo, TypeUtils.castToString(oldValue));
            keyList.add(keyValue);
        }
        ArrayList<String> contentList = new ArrayList<String>();
        String[] stringArray2 = contentKeys;
        n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            ModelProperty modelProperty;
            String fieldName;
            String fileMemo = fieldName = stringArray2[i];
            List fieldsfilter = Arrays.stream(fields).filter(e -> fieldName.equals(e.getName())).collect(Collectors.toList());
            if (!StringUtils.isEmpty(fieldsfilter) && fieldsfilter.size() > 0 && ((Field)fieldsfilter.get(0)).isAnnotationPresent(ModelProperty.class) && !StringUtils.isEmpty((Object)(modelProperty = ((Field)fieldsfilter.get(0)).getAnnotation(ModelProperty.class)).note())) {
                fileMemo = modelProperty.note();
            }
            String oldValue = this.getValue(wraper, fieldName, "none");
            String contentValue = String.format("%1$s:%2$s", fileMemo, TypeUtils.castToString(oldValue));
            contentList.add(contentValue);
        }
        oplogModel.setBusinessKey(Joiner.on((String)",").useForNull("none").join(keyList));
        oplogModel.setNContent(null);
        oplogModel.setOContent(Joiner.on((String)",").useForNull("none").join(contentList));
        this.onRecoder(oplogModel);
    }

    @Override
    public <T> void logger(ServiceSession session, T oModel, T nModel, OperationFlag flag) {
        OpLog opLog;
        System.out.println("--->3");
        Class<?> opClass = null;
        opClass = flag.equals((Object)OperationFlag.Delete) ? oModel.getClass() : nModel.getClass();
        System.out.println("--->4");
        if (opClass.isAnnotationPresent(OpLog.class) && (opLog = opClass.getAnnotation(OpLog.class)).required()) {
            BeanWrapperImpl oWraper = null;
            BeanWrapperImpl nWraper = null;
            if (flag.equals((Object)OperationFlag.Delete)) {
                oWraper = new BeanWrapperImpl(oModel);
            } else if (flag.equals((Object)OperationFlag.Insert)) {
                nWraper = new BeanWrapperImpl(nModel);
            } else {
                oWraper = new BeanWrapperImpl(oModel);
                nWraper = new BeanWrapperImpl(nModel);
            }
            System.out.println("--->5");
            if (OperationFlag.Insert.equals((Object)flag)) {
                this.onInsert(session, (BeanWrapper)nWraper, opLog);
            } else if (OperationFlag.Update.equals((Object)flag)) {
                this.onUpdate(session, (BeanWrapper)oWraper, (BeanWrapper)nWraper, opLog);
            } else if (OperationFlag.Delete.equals((Object)flag)) {
                this.onDelete(session, (BeanWrapper)oWraper, opLog);
            }
            System.out.println("--->6");
        }
    }

    @Override
    public <T> void logger(ServiceSession session, JSONObject oModel, JSONObject nModel, Class<T> classT, OperationFlag flag) {
        System.out.println("--->1");
        Object oModelT = null;
        if (oModel != null) {
            oModelT = JSON.toJavaObject((JSON)oModel, classT);
        }
        Object nModelT = null;
        if (nModel != null) {
            nModelT = JSON.toJavaObject((JSON)nModel, classT);
        }
        System.out.println("--->2");
        this.logger(session, oModelT, nModelT, flag);
    }
}

