/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import com.alibaba.druid.util.StringUtils;
import com.google.common.base.Joiner;
import com.shiji.core.util.ParserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class StatementParserHandler {
    private static final Logger log = LoggerFactory.getLogger(StatementParserHandler.class);
    private static final boolean[] separatorIndex = new boolean[128];
    private static final char[] separatorArray = new char[]{',', ';', '\"', '>', '<', '/', '?', '\'', '{', '}', '[', ']', '(', ')', '!', '@', '#', '%', '^', '&', '*', '+', '-', '_', '=', '\\', '`', '~'};

    private static boolean isSeparator(char c) {
        for (char ch : separatorArray) {
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    private static boolean isParameterSeparator(char c) {
        return c < '\u0080' && separatorIndex[c] || Character.isWhitespace(c) || StatementParserHandler.isSeparator(c);
    }

    private Set<String> parseStatement(String statement) {
        Assert.notNull((Object)statement, (String)"statement must not be null");
        HashSet<String> response = new HashSet<String>();
        char[] charArray = statement.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (c == ':') {
                int j;
                if (c == ':' && j < charArray.length && charArray[j] == ':') {
                    i += 2;
                    continue;
                }
                String parameter = null;
                for (j = i + 1; j < charArray.length && !StatementParserHandler.isParameterSeparator(charArray[j]); ++j) {
                }
                if (j - i > 1) {
                    parameter = statement.substring(i + 1, j);
                    response.add(parameter);
                }
                i = j - 1;
            }
            ++i;
        }
        return response;
    }

    public String getIdentify(String source, Map<String, Object> paramsMap) {
        Set<String> paramsSet = this.parseStatement(source);
        for (String name : paramsSet) {
            if (paramsMap.containsKey(name)) {
                Object value = paramsMap.get(name);
                if (value == null) {
                    return "";
                }
                if (!StringUtils.isEmpty((String)value.toString())) continue;
                return "";
            }
            return "";
        }
        return source;
    }

    public String getTargetSQL(String statement, Map<String, Object> paramsMap) {
        ArrayList identifyList = new ArrayList();
        BiFunction<String, Map<String, String>, String> biFunction = (keyCode, nameMap) -> {
            Iterator iterator = nameMap.keySet().iterator();
            if (iterator.hasNext()) {
                String identify = (String)iterator.next();
                identifyList.add(identify);
                identify = this.getIdentify((String)keyCode, paramsMap);
                return identify;
            }
            return "";
        };
        HashMap<String, String> parserMap = new HashMap<String, String>();
        paramsMap.keySet().forEach(action -> parserMap.put((String)action, (String)action));
        String response = ParserUtils.parseHolder("${", "}", statement, biFunction, parserMap, new Object[0]);
        log.info("source:{} target:{} identify:{}", new Object[]{statement, response, Joiner.on((String)",").join(identifyList)});
        return response;
    }
}

