/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.runner;

import com.bstek.ureport.provider.report.file.FileReportProvider;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.shiji.core.annotation.RepositoryRestComponent;
import com.shiji.core.annotation.RestComponent;
import com.shiji.core.component.MapTable;
import com.shiji.core.controller.DataRestController;
import com.shiji.core.enums.HttpMethod;
import com.shiji.core.util.SpringInvoker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class DynamicDeployRunner
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DynamicDeployRunner.class);
    @Autowired
    ApplicationContext context;
    @Autowired
    SpringInvoker invoker;

    private String getSimpleName(String fullname, String defauleName) {
        if (StringUtils.isEmpty((Object)fullname)) {
            return defauleName;
        }
        ArrayList<String> dataList = new ArrayList<String>();
        Iterator iterator = Splitter.on((String)".").split((CharSequence)fullname).iterator();
        while (iterator.hasNext()) {
            String simpleName = (String)iterator.next();
            if (iterator.hasNext()) {
                dataList.add(simpleName.substring(0, 1));
                continue;
            }
            dataList.add(simpleName);
        }
        return Joiner.on((String)".").join(dataList);
    }

    private void exportRequestMapping(String classPath, String methodPath, HttpMethod method, String beanName, String methodName, String note) {
        RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)this.context.getBean(RequestMappingHandlerMapping.class);
        Class<DataRestController> entry = DataRestController.class;
        Method getMethod = ReflectionUtils.findMethod(entry, (String)"onGet", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class});
        Method postMethod = ReflectionUtils.findMethod(entry, (String)"onPost", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class});
        DataRestController controller = (DataRestController)this.context.getBean(DataRestController.class);
        String exportPattern = String.format("%1$s/%2$s", classPath, methodPath);
        PatternsRequestCondition patterns = new PatternsRequestCondition(new String[]{exportPattern});
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.POST});
        RequestMappingInfo mappingInfo = new RequestMappingInfo(exportPattern, patterns, methods, null, null, null, null, null);
        controller.put(exportPattern, beanName, methodName, note);
        if (HttpMethod.GET.equals((Object)method)) {
            handlerMapping.registerMapping(mappingInfo, (Object)controller, getMethod);
        } else {
            handlerMapping.registerMapping(mappingInfo, (Object)controller, postMethod);
        }
    }

    public void run(String ... args) throws Exception {
        RepositoryRestComponent annotation;
        Object beanObj;
        String[] beans;
        System.out.println(">>>>>>>>>>>>>>>\u670d\u52a1\u542f\u52a8\u6267\u884c\uff0c\u6267\u884c\u52a0\u8f7d\u6570\u636e\u7b49\u64cd\u4f5c<<<<<<<<<<<<<");
        MapTable<String, Object> tableMap = new MapTable<String, Object>("beanName");
        ArrayList<String> bufferList = new ArrayList<String>();
        for (String beanName : beans = this.context.getBeanNamesForAnnotation(RepositoryRestComponent.class)) {
            beanObj = this.context.getBean(beanName);
            if (!beanObj.getClass().isAnnotationPresent(RepositoryRestComponent.class)) continue;
            annotation = (RepositoryRestComponent)AnnotationUtils.findAnnotation(beanObj.getClass(), RepositoryRestComponent.class);
            if (annotation.exported()) {
                bufferList.add(String.format("\u6ce8\u518cBean:\u3010%1$s\u3011\u6620\u5c04\u8def\u5f84\u4e3a:\u3010%2$s\u3011", beanName, annotation.path()));
                tableMap.put(annotation.path(), beanName);
                continue;
            }
            bufferList.add(String.format("\u6ce8\u518cBean:\u3010%1$s\u3011\u6620\u5c04\u8def\u5f84\u4e3a:\u3010%2$s\u3011\u672a\u6307\u5b9a\u5bfc\u51fa", beanName, annotation.path()));
        }
        Set keySet = tableMap.keySet();
        for (String classPath : keySet) {
            Method[] methods;
            String beanName;
            beanName = (String)tableMap.get(classPath, "beanName");
            bufferList.add("pathKey:" + classPath + " beanName:" + beanName);
            bufferList.add("dataRow:" + classPath);
            beanObj = this.context.getBean(beanName);
            beanObj = DynamicDeployRunner.getTarget(beanObj);
            annotation = (RepositoryRestComponent)AnnotationUtils.findAnnotation(beanObj.getClass(), RepositoryRestComponent.class);
            bufferList.add(String.format("\u7c7b\u6807\u6ce8:%1$s exported=%2$b allMethod=%3$b", beanName, annotation.exported(), annotation.allMethod()));
            bufferList.add("================================================================");
            for (Method method : methods = beanObj.getClass().getDeclaredMethods()) {
                String note;
                String methodPath;
                RestComponent restResource;
                String methodName = method.getName();
                if (annotation.allMethod()) {
                    if (method.isAnnotationPresent(RestComponent.class)) {
                        restResource = method.getAnnotation(RestComponent.class);
                        if (!restResource.exported()) {
                            bufferList.add(String.format("\u5bfc\u51fa\u8def\u5f84:%1$s \u4e0d\u5bfc\u65b9\u6cd5:%2$s.%3$s class(exported=%4$b allMethod=%5$b) method(exported=%6$b)", classPath, beanName, methodName, annotation.exported(), annotation.allMethod(), restResource.exported()));
                            continue;
                        }
                        methodPath = methodName;
                        if (!StringUtils.isEmpty((Object)restResource.path())) {
                            methodPath = restResource.path();
                        }
                        bufferList.add(String.format("\u5bfc\u51fa\u8def\u5f84:%1$s/%2$s \u5bfc\u51fa\u65b9\u6cd5:%3$s.%4$s class(exported=%5$b allMethod=%6$b) method(exported=%7$b)", classPath, methodPath, beanName, methodName, annotation.exported(), annotation.allMethod(), restResource.exported()));
                        note = String.format("\u670d\u52a1:%1$s \u65b9\u6cd5:%2$s", StringUtils.isEmpty((Object)annotation.note()) ? beanName : annotation.note(), StringUtils.isEmpty((Object)restResource.note()) ? methodName : restResource.note());
                        this.exportRequestMapping(classPath, methodPath, restResource.method(), beanName, methodName, note);
                        continue;
                    }
                    bufferList.add(String.format("\u5bfc\u51fa\u8def\u5f84:%1$s/%2$s \u65b9\u6cd5:%3$s.%4$s class(exported=%5$b allMethod=%6$b) method(none)", classPath, methodName, beanName, methodName, annotation.exported(), annotation.allMethod()));
                    String note2 = String.format("\u670d\u52a1:%1$s \u65b9\u6cd5:%2$s", StringUtils.isEmpty((Object)annotation.note()) ? beanName : annotation.note(), methodName);
                    this.exportRequestMapping(classPath, methodName, HttpMethod.POST, beanName, methodName, note2);
                    continue;
                }
                if (method.isAnnotationPresent(RestComponent.class)) {
                    restResource = method.getAnnotation(RestComponent.class);
                    if (!restResource.exported()) {
                        bufferList.add(String.format("\u5bfc\u51fa\u8def\u5f84:%1$s/%2$s \u4e0d\u5bfc\u65b9\u6cd5:%3$s.%4$s class(exported=%5$b allMethod=%6$b) method(exported=%7$b)", classPath, methodName, beanName, methodName, annotation.exported(), annotation.allMethod(), restResource.exported()));
                        continue;
                    }
                    methodPath = methodName;
                    if (!StringUtils.isEmpty((Object)restResource.path())) {
                        methodPath = restResource.path();
                    }
                    bufferList.add(String.format("\u5bfc\u51fa\u8def\u5f84:%1$s/%2$s \u65b9\u6cd5:%3$s.%4$s class(exported=%5$b allMethod=%6$b) method(exported=%7$b)", classPath, methodPath, beanName, methodName, annotation.exported(), annotation.allMethod(), restResource.exported()));
                    note = String.format("\u670d\u52a1:%1$s \u65b9\u6cd5:%2$s", StringUtils.isEmpty((Object)annotation.note()) ? beanName : annotation.note(), StringUtils.isEmpty((Object)restResource.note()) ? methodName : restResource.note());
                    this.exportRequestMapping(classPath, methodPath, restResource.method(), beanName, methodName, note);
                    continue;
                }
                bufferList.add(String.format("\u5bfc\u51fa\u8def\u5f84:%1$s/%2$s \u4e0d\u5bfc\u65b9\u6cd5:%3$s.%4$s class(exported=%5$b allMethod=%6$b) method(none)", classPath, methodName, beanName, methodName, annotation.exported(), annotation.allMethod()));
            }
        }
        for (String bufferLine : bufferList) {
            System.out.println(bufferLine);
        }
        try {
            FileReportProvider fileReportProvider = (FileReportProvider)this.context.getBean(FileReportProvider.class);
            Field fieldFileStoreDir = fileReportProvider.getClass().getDeclaredField("fileStoreDir");
            fieldFileStoreDir.setAccessible(true);
            System.out.println(String.format("uReport\u6587\u4ef6\u8f93\u51fa\u8def\u5f84:%1$s", fieldFileStoreDir.get(fileReportProvider)));
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            log.info("not found:{}", (Object)"FileReportProvider");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6ureport\u8def\u5f84\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        System.out.println(">>>>>>>>>>>>>>>\u670d\u52a1\u542f\u52a8\u6267\u884c\uff0c\u6267\u884c\u52a0\u8f7d\u6570\u636e\u7b49\u5b8c\u6210<<<<<<<<<<<<<");
    }

    public static Object getTarget(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return DynamicDeployRunner.getJdkDynamicProxyTargetObject(proxy);
        }
        return DynamicDeployRunner.getCglibProxyTargetObject(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }
}

