/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.component;

import com.alibaba.fastjson.util.TypeUtils;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.mapping.MappingType;
import com.bstek.ureport.definition.value.DatasetValue;
import com.bstek.ureport.definition.value.ExpressionValue;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import com.shiji.core.ureport.component.ReportComponentWriter;
import java.util.List;
import java.util.ListIterator;
import javax.xml.transform.sax.TransformerHandler;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReportCellWriter
extends ReportComponentWriter {
    protected void onWriteCells(TransformerHandler handler, List<CellDefinition> cells) throws SAXException {
        ListIterator<CellDefinition> li = cells.listIterator();
        while (li.hasNext()) {
            CellDefinition cell = li.next();
            AttributesImpl cellAtts = new AttributesImpl();
            cellAtts.addAttribute("", "", "expand", "", cell.getExpand().name());
            cellAtts.addAttribute("", "", "name", "", cell.getName());
            cellAtts.addAttribute("", "", "row", "", TypeUtils.castToString((Object)cell.getRowNumber()));
            cellAtts.addAttribute("", "", "col", "", TypeUtils.castToString((Object)cell.getColumnNumber()));
            if (!StringUtils.isEmpty((Object)cell.getLeftParentCellName())) {
                cellAtts.addAttribute("", "", "left-cell", "", TypeUtils.castToString((Object)cell.getLeftParentCellName()));
            }
            if (!StringUtils.isEmpty((Object)cell.getTopParentCellName())) {
                cellAtts.addAttribute("", "", "top-cell", "", TypeUtils.castToString((Object)cell.getTopParentCellName()));
            }
            if (!StringUtils.isEmpty((Object)cell.getColSpan())) {
                cellAtts.addAttribute("", "", "col-span", "", TypeUtils.castToString((Object)cell.getColSpan()));
            }
            if (!StringUtils.isEmpty((Object)cell.getRowSpan())) {
                cellAtts.addAttribute("", "", "row-span", "", TypeUtils.castToString((Object)cell.getRowSpan()));
            }
            handler.startElement("", "", "cell", cellAtts);
            CellStyle cellStyle = cell.getCellStyle();
            this.onWriteCellStyle(handler, cellStyle);
            Value value = cell.getValue();
            this.onWriteCellValue(handler, value);
            handler.endElement("", "", "cell");
        }
    }

    protected void onWriteCellValue(TransformerHandler handler, Value value) throws SAXException {
        AttributesImpl valueAtts = new AttributesImpl();
        if (value instanceof SimpleValue) {
            handler.startElement("", "", "simple-value", valueAtts);
            handler.startCDATA();
            SimpleValue simpleValue = (SimpleValue)value;
            handler.characters(simpleValue.getValue().toCharArray(), 0, simpleValue.getValue().length());
            handler.endCDATA();
            handler.endElement("", "", "simple-value");
        } else if (value instanceof DatasetValue) {
            DatasetValue dsValue = (DatasetValue)value;
            valueAtts.addAttribute("", "", "dataset-name", "", TypeUtils.castToString((Object)dsValue.getDatasetName()));
            valueAtts.addAttribute("", "", "aggregate", "", TypeUtils.castToString((Object)dsValue.getAggregate().name()));
            valueAtts.addAttribute("", "", "property", "", TypeUtils.castToString((Object)dsValue.getProperty()));
            valueAtts.addAttribute("", "", "order", "", TypeUtils.castToString((Object)dsValue.getOrder().name()));
            valueAtts.addAttribute("", "", "mapping-type", "", TypeUtils.castToString((Object)dsValue.getMappingType().name()));
            if (MappingType.dataset.equals((Object)dsValue.getMappingType())) {
                valueAtts.addAttribute("", "", "mapping-dataset", "", TypeUtils.castToString((Object)dsValue.getMappingDataset()));
                valueAtts.addAttribute("", "", "mapping-key-property", "", TypeUtils.castToString((Object)dsValue.getMappingKeyProperty()));
                valueAtts.addAttribute("", "", "mapping-value-property", "", TypeUtils.castToString((Object)dsValue.getMappingValueProperty()));
            }
            handler.startElement("", "", "dataset-value", valueAtts);
            handler.endElement("", "", "dataset-value");
        } else if (value instanceof ExpressionValue) {
            handler.startElement("", "", "expression-value", valueAtts);
            handler.startCDATA();
            ExpressionValue expressionValue = (ExpressionValue)value;
            handler.characters(expressionValue.getValue().toCharArray(), 0, expressionValue.getValue().length());
            handler.endCDATA();
            handler.endElement("", "", "expression-value");
        }
    }

    protected void onWriteCellStyle(TransformerHandler handler, CellStyle cellStyle) throws SAXException {
        AttributesImpl cellStyleAtts = new AttributesImpl();
        cellStyleAtts.addAttribute("", "", "font-size", "", TypeUtils.castToString((Object)cellStyle.getFontSize()));
        cellStyleAtts.addAttribute("", "", "bgcolor", "", cellStyle.getBgcolor());
        cellStyleAtts.addAttribute("", "", "align", "", cellStyle.getAlign().name());
        cellStyleAtts.addAttribute("", "", "valign", "", cellStyle.getValign().name());
        cellStyleAtts.addAttribute("", "", "bold", "", StringUtils.isEmpty((Object)cellStyle.getBold()) ? "false" : Boolean.toString(cellStyle.getBold()));
        cellStyleAtts.addAttribute("", "", "italic", "", StringUtils.isEmpty((Object)cellStyle.getItalic()) ? "false" : Boolean.toString(cellStyle.getItalic()));
        if (!StringUtils.isEmpty((Object)cellStyle.getFormat())) {
            cellStyleAtts.addAttribute("", "", "format", "", cellStyle.getFormat());
        }
        handler.startElement("", "", "cell-style", cellStyleAtts);
        Border borderLeft = cellStyle.getLeftBorder();
        Border borderRight = cellStyle.getRightBorder();
        Border borderTop = cellStyle.getTopBorder();
        Border borderBottom = cellStyle.getBottomBorder();
        this.onWriteCellStyleBoder(handler, "left-border", borderLeft);
        this.onWriteCellStyleBoder(handler, "right-border", borderRight);
        this.onWriteCellStyleBoder(handler, "top-border", borderTop);
        this.onWriteCellStyleBoder(handler, "bottom-border", borderBottom);
        handler.endElement("", "", "cell-style");
    }

    protected void onWriteCellStyleBoder(TransformerHandler handler, String borderName, Border border) throws SAXException {
        AttributesImpl boderStyleAtts = new AttributesImpl();
        boderStyleAtts.addAttribute("", "", "width", "", TypeUtils.castToString((Object)border.getWidth()));
        boderStyleAtts.addAttribute("", "", "style", "", border.getStyle().name());
        boderStyleAtts.addAttribute("", "", "color", "", border.getColor());
        handler.startElement("", "", borderName, boderStyleAtts);
        handler.endElement("", "", borderName);
    }
}

