/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.datasource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Splitter;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import com.shiji.core.annotation.RepositoryRestComponent;
import com.shiji.core.annotation.RestComponent;
import com.shiji.core.service.BaseCompomentHandler;
import com.shiji.core.service.InvokerHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class BeanBuildinDataSource {
    private static final Logger log = LoggerFactory.getLogger(BeanBuildinDataSource.class);
    @Autowired
    InvokerHandler invoker;

    private String getCollectionName(Object beanObj, Method method) {
        Annotation annotation;
        String response = "";
        if (method != null && method.isAnnotationPresent(RestComponent.class)) {
            annotation = method.getAnnotation(RestComponent.class);
            response = annotation.rel();
        }
        if (StringUtils.isEmpty((CharSequence)response) && beanObj != null && beanObj.getClass().isAnnotationPresent(RepositoryRestComponent.class)) {
            annotation = (RepositoryRestComponent)AnnotationUtils.findAnnotation(beanObj.getClass(), RepositoryRestComponent.class);
            response = annotation.collectionResourceRel();
        }
        if (StringUtils.isEmpty((CharSequence)response) && beanObj instanceof BaseCompomentHandler) {
            BaseCompomentHandler base = (BaseCompomentHandler)beanObj;
            response = base.getCollectionName();
        }
        return response;
    }

    private List<Map<String, Object>> getResponse(Object result, String collectionName) {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        if (result instanceof ServiceResponse) {
            ServiceResponse sr = (ServiceResponse)result;
            Object value = sr.getData();
            return this.getResponse(value, collectionName);
        }
        if (result instanceof List) {
            List dataList = (List)result;
            for (int i = 0; i < dataList.size(); ++i) {
                Object dataRow = dataList.get(i);
                JSONObject jsonRow = (JSONObject)JSON.toJSON(dataRow);
                response.add((Map<String, Object>)jsonRow);
            }
        } else if (result instanceof JSONArray) {
            JSONArray dataList = (JSONArray)result;
            for (int i = 0; i < dataList.size(); ++i) {
                Object dataRow = dataList.get(i);
                JSONObject jsonRow = (JSONObject)JSON.toJSON((Object)dataRow);
                response.add((Map<String, Object>)jsonRow);
            }
        } else if (result instanceof JSONObject) {
            JSONObject dataObject = (JSONObject)result;
            if (!StringUtils.isEmpty((CharSequence)collectionName) && dataObject.containsKey((Object)collectionName)) {
                Object value = dataObject.get((Object)collectionName);
                return this.getResponse(value, collectionName);
            }
        } else if (result instanceof Map) {
            Map dataMap = (Map)result;
            if (!StringUtils.isEmpty((CharSequence)collectionName) && dataMap.containsKey(collectionName)) {
                Object value = dataMap.get(collectionName);
                return this.getResponse(value, collectionName);
            }
        } else {
            JSONObject jsonRow = (JSONObject)JSON.toJSON((Object)result);
            response.add((Map<String, Object>)jsonRow);
        }
        return response;
    }

    public Map<String, Object> parameterCombine(Map<String, Object> paramsMap) {
        log.info("parameterCombine paramsMap:{}", (Object)JSON.toJSONString(paramsMap));
        HashMap masterMap = new HashMap();
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        for (String keyName : paramsMap.keySet()) {
            List pathList = Splitter.on((String)".").omitEmptyStrings().splitToList((CharSequence)keyName);
            Optional masterOptional = pathList.stream().findFirst();
            if (masterOptional.isPresent() && pathList.size() > 1) {
                Map<String, Object> slaveMap;
                String maskerKey = (String)masterOptional.get();
                String slaveKey = keyName.substring(maskerKey.length() + 1);
                if (!masterMap.containsKey(maskerKey)) {
                    slaveMap = new HashMap();
                    masterMap.put(maskerKey, slaveMap);
                }
                slaveMap = (Map)masterMap.get(maskerKey);
                slaveMap.put(slaveKey, paramsMap.get(keyName));
                continue;
            }
            responseMap.put(keyName, paramsMap.get(keyName));
        }
        if (masterMap.size() > 0) {
            responseMap.putAll(masterMap);
        }
        log.info("parameterCombine paramsMap:{} paramsOut:{}", (Object)JSON.toJSONString(paramsMap), (Object)JSON.toJSONString(responseMap));
        return responseMap;
    }

    public List<Map<String, Object>> loadReportData(String dsName, String datasetName, Map<String, Object> parameters) {
        ArrayList<Map<String, Object>> response = new ArrayList();
        log.info("loadReportData ---> dsName:{} datasetName:{} parameters:{}", new Object[]{dsName, datasetName, JSON.toJSONStringWithDateFormat(parameters, (String)JSON.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0])});
        String component = "";
        if (!parameters.containsKey("method")) {
            log.warn("\u672a\u627e\u5230\u8bf7\u6c42\u65b9\u6cd5\u540d\u79f0\u53c2\u6570,\u4f7f\u7528\u7f3a\u7701\u53c2\u6570:{}", (Object)dsName);
            component = dsName;
        } else {
            component = TypeUtils.castToString((Object)parameters.get("method"));
            if (StringUtils.isEmpty((CharSequence)component)) {
                log.warn("\u8bf7\u6c42\u65b9\u6cd5\u540d\u79f0\u53c2\u6570\u4e3a\u7a7a,\u4f7f\u7528\u7f3a\u7701\u53c2\u6570:{}", (Object)dsName);
                component = dsName;
            }
        }
        ServiceSession session = null;
        if (parameters.containsKey("session")) {
            String sessionStr = TypeUtils.castToString((Object)parameters.get("session"));
            session = (ServiceSession)JSON.parseObject((String)sessionStr, ServiceSession.class);
            parameters.remove("session");
        }
        if (session == null && parameters.containsKey("token")) {
            session = new ServiceSession();
            session.setEnt_id(0L);
            session.setUser_id(0L);
            parameters.remove("token");
        }
        if (session == null && parameters.containsKey("entId")) {
            long endId = TypeUtils.castToLong((Object)parameters.get("entId"));
            session = new ServiceSession();
            session.setEnt_id(endId);
            session.setUser_id(0L);
            parameters.remove("entId");
        }
        parameters.remove("method");
        if (session == null) {
            session = new ServiceSession();
            session.setEnt_id(0L);
            session.setUser_id(0L);
            parameters.remove("entId");
        }
        SpringContext.putSession(session);
        parameters = this.parameterCombine(parameters);
        SpringContext.putPageno(0);
        SpringContext.putPageSize(999999);
        JSONObject paramsObject = (JSONObject)JSON.toJSON(parameters);
        log.info("loadReportData ---> session:{} parameters:{}", (Object)JSON.toJSONString((Object)session), (Object)JSON.toJSONStringWithDateFormat(parameters, (String)JSON.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0]));
        AtomicReference<Object> componentRef = new AtomicReference<Object>();
        AtomicReference<Method> methodRef = new AtomicReference<Method>();
        Object result = this.invoker.invoke(component, paramsObject, componentRef, methodRef);
        Object beanObj = componentRef.get();
        Method method = methodRef.get();
        String collectionName = this.getCollectionName(beanObj, method);
        response = this.getResponse(result, collectionName);
        return response;
    }

    public List<T> buildReport(String dsName, String datasetName, Map<String, Object> parameters) {
        ArrayList<T> list = new ArrayList<T>();
        log.info("buildReport ---> dsName:{} datasetName:{} parameters:{}", new Object[]{dsName, datasetName, JSON.toJSONStringWithDateFormat(parameters, (String)JSON.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0])});
        return list;
    }
}

