/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.searchform;

import com.alibaba.fastjson.JSON;
import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.searchform.InputComponent;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.RenderContext;
import com.bstek.ureport.definition.searchform.VueThreadLocal;
import com.bstek.ureport.definition.searchform.VueTreeDataParser;
import com.bstek.ureport.exception.DatasetUndefinitionException;
import com.google.common.base.Joiner;
import com.product.util.MapAs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VueTreeSelectComponent
extends InputComponent {
    private boolean useDataset;
    private String dataset;
    private String labelField;
    private String codeField;
    private String parentField;
    private List<Option> options;

    String inputHtml(RenderContext context) {
        String name = this.getBindParameter();
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add("<treeselect v-model=\"" + name + ".value\" :multiple=\"true\" :options=\"" + name + ".options\" :value-consists-of=\"valueConsistsOf\" :style=\"{width:'100%'}\" @input=\"handleTreeSelectChange\">");
        dataList.add("</treeselect>");
        if (this.useDataset && StringUtils.isNotBlank((CharSequence)this.dataset)) {
            System.out.println("\u6784\u5efadataset\u6570\u636e");
            Dataset ds = context.getDataset(this.dataset);
            if (ds == null) {
                throw new DatasetUndefinitionException(this.dataset);
            }
            ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
            for (Object obj : ds.getData()) {
                Object label = Utils.getProperty(obj, (String)this.labelField);
                Object code = Utils.getProperty(obj, (String)this.codeField);
                Object parent = Utils.getProperty(obj, (String)this.parentField);
                Map<String, Object> currentMap = MapAs.of(this.labelField, label, this.codeField, code, this.parentField, parent);
                listMap.add(currentMap);
            }
            Object response = VueTreeDataParser.buildTreeData(listMap, this.codeField, this.labelField, this.parentField);
            System.out.println("--->" + JSON.toJSONString((Object)response));
            System.out.println(String.format("\u589e\u52a0\u53d8\u91cf:%1$s", name));
            VueThreadLocal.addVueVariable(name + ".value");
            VueThreadLocal.addVueVariable(name + ".options", response);
        } else {
            System.out.println("\u65e0dataset\u6570\u636e");
        }
        return Joiner.on((String)"\n").join(dataList);
    }

    public String initJs(RenderContext context) {
        String name = this.getBindParameter();
        StringBuilder sb = new StringBuilder();
        sb.append("formElements.push(");
        sb.append("   function(){");
        sb.append("       if(''==='" + name + "'){");
        sb.append("          alert('\u6587\u672c\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!');");
        sb.append("          throw '\u6587\u672c\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!'");
        sb.append("        }");
        sb.append("        var response = data." + name + ".value.join(',');");
        sb.append("        return {\"" + name + "\":response}");
        sb.append("   }");
        sb.append(");");
        return sb.toString();
    }

    public boolean isUseDataset() {
        return this.useDataset;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public String getCodeField() {
        return this.codeField;
    }

    public String getParentField() {
        return this.parentField;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setUseDataset(boolean useDataset) {
        this.useDataset = useDataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public void setCodeField(String codeField) {
        this.codeField = codeField;
    }

    public void setParentField(String parentField) {
        this.parentField = parentField;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VueTreeSelectComponent)) {
            return false;
        }
        VueTreeSelectComponent other = (VueTreeSelectComponent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUseDataset() != other.isUseDataset()) {
            return false;
        }
        String this$dataset = this.getDataset();
        String other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        String this$labelField = this.getLabelField();
        String other$labelField = other.getLabelField();
        if (this$labelField == null ? other$labelField != null : !this$labelField.equals(other$labelField)) {
            return false;
        }
        String this$codeField = this.getCodeField();
        String other$codeField = other.getCodeField();
        if (this$codeField == null ? other$codeField != null : !this$codeField.equals(other$codeField)) {
            return false;
        }
        String this$parentField = this.getParentField();
        String other$parentField = other.getParentField();
        if (this$parentField == null ? other$parentField != null : !this$parentField.equals(other$parentField)) {
            return false;
        }
        List<Option> this$options = this.getOptions();
        List<Option> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VueTreeSelectComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseDataset() ? 79 : 97);
        String $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        String $labelField = this.getLabelField();
        result = result * 59 + ($labelField == null ? 43 : $labelField.hashCode());
        String $codeField = this.getCodeField();
        result = result * 59 + ($codeField == null ? 43 : $codeField.hashCode());
        String $parentField = this.getParentField();
        result = result * 59 + ($parentField == null ? 43 : $parentField.hashCode());
        List<Option> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "VueTreeSelectComponent(useDataset=" + this.isUseDataset() + ", dataset=" + this.getDataset() + ", labelField=" + this.getLabelField() + ", codeField=" + this.getCodeField() + ", parentField=" + this.getParentField() + ", options=" + this.getOptions() + ")";
    }
}

