/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.product.util.GenericArrayTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ActualTypeUtils {
    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ActualTypeUtils.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length == 1) {
                return ActualTypeUtils.getRawClass(upperBounds[0]);
            }
            throw new JSONException("TODO");
        }
        throw new JSONException("TODO");
    }

    private static Type getWildcardTypeUpperBounds(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            return upperBounds.length > 0 ? upperBounds[0] : Object.class;
        }
        return type;
    }

    public static Type getCollectionItemType(Type fieldType) {
        if (fieldType instanceof ParameterizedType) {
            return ActualTypeUtils.getCollectionItemType((ParameterizedType)fieldType);
        }
        if (fieldType instanceof Class) {
            return ActualTypeUtils.getCollectionItemType((Class)fieldType);
        }
        return Object.class;
    }

    private static Type getCollectionItemType(Class<?> clazz) {
        return clazz.getName().startsWith("java.") ? Object.class : ActualTypeUtils.getCollectionItemType(ActualTypeUtils.getCollectionSuperType(clazz));
    }

    private static Type getCollectionItemType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (rawType == Collection.class) {
            return ActualTypeUtils.getWildcardTypeUpperBounds(actualTypeArguments[0]);
        }
        Class rawClass = (Class)rawType;
        Map<TypeVariable, Type> actualTypeMap = ActualTypeUtils.createActualTypeMap(rawClass.getTypeParameters(), actualTypeArguments);
        Type superType = ActualTypeUtils.getCollectionSuperType(rawClass);
        if (superType instanceof ParameterizedType) {
            Class<?> superClass = ActualTypeUtils.getRawClass(superType);
            Type[] superClassTypeParameters = ((ParameterizedType)superType).getActualTypeArguments();
            return superClassTypeParameters.length > 0 ? ActualTypeUtils.getCollectionItemType(ActualTypeUtils.makeParameterizedType(superClass, superClassTypeParameters, actualTypeMap)) : ActualTypeUtils.getCollectionItemType(superClass);
        }
        return ActualTypeUtils.getCollectionItemType((Class)superType);
    }

    private static Type getCollectionSuperType(Class<?> clazz) {
        Type assignable = null;
        for (Type type : clazz.getGenericInterfaces()) {
            Class<?> rawClass = ActualTypeUtils.getRawClass(type);
            if (rawClass == Collection.class) {
                return type;
            }
            if (!Collection.class.isAssignableFrom(rawClass)) continue;
            assignable = type;
        }
        return assignable == null ? clazz.getGenericSuperclass() : assignable;
    }

    private static Map<TypeVariable, Type> createActualTypeMap(TypeVariable[] typeParameters, Type[] actualTypeArguments) {
        int length = typeParameters.length;
        HashMap<TypeVariable, Type> actualTypeMap = new HashMap<TypeVariable, Type>(length);
        for (int i = 0; i < length; ++i) {
            actualTypeMap.put(typeParameters[i], actualTypeArguments[i]);
        }
        return actualTypeMap;
    }

    private static ParameterizedType makeParameterizedType(Class<?> rawClass, Type[] typeParameters, Map<TypeVariable, Type> actualTypeMap) {
        int length = typeParameters.length;
        Type[] actualTypeArguments = new Type[length];
        for (int i = 0; i < length; ++i) {
            actualTypeArguments[i] = ActualTypeUtils.getActualType(typeParameters[i], actualTypeMap);
        }
        return new ParameterizedTypeImpl(actualTypeArguments, null, rawClass);
    }

    private static Type getActualType(Type typeParameter, Map<TypeVariable, Type> actualTypeMap) {
        if (typeParameter instanceof TypeVariable) {
            return actualTypeMap.get(typeParameter);
        }
        if (typeParameter instanceof ParameterizedType) {
            return ActualTypeUtils.makeParameterizedType(ActualTypeUtils.getRawClass(typeParameter), ((ParameterizedType)typeParameter).getActualTypeArguments(), actualTypeMap);
        }
        if (typeParameter instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(ActualTypeUtils.getActualType(((GenericArrayType)typeParameter).getGenericComponentType(), actualTypeMap));
        }
        return typeParameter;
    }
}

