/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.component;

import com.alibaba.fastjson.JSON;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.searchform.Component;
import com.bstek.ureport.definition.searchform.LabelPosition;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.SearchForm;
import com.bstek.ureport.provider.report.file.FileReportProvider;
import com.product.util.MapAs;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import com.shiji.core.ureport.component.AbstractReportService;
import com.shiji.core.ureport.service.ReportService;
import com.shiji.core.util.ParserUtils;
import com.shiji.core.util.SnowFlakeID;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.util.StringUtils;

@org.springframework.stereotype.Component
public class IDasReportServiceImpl
extends AbstractReportService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(IDasReportServiceImpl.class);
    private JdbcTemplate jdbcTemplate;
    private SnowFlakeID flakeID;

    public IDasReportServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.flakeID = new SnowFlakeID(2L, 3L);
    }

    @Override
    public String getBusinessType() {
        return "iDas";
    }

    public NamedParameterJdbcTemplate getJdbcNameTemplate() {
        return new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
    }

    @Override
    protected List<Map<String, Object>> onBeforeGenerateSearchForm(List<Map<String, Object>> paramsList) {
        return paramsList;
    }

    protected List<Map<String, Object>> onConvertField(List<Map<String, Object>> dataList, String dsName) {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> itemMap : dataList) {
            Map<String, Object> dataMap = MapAs.of("colName", itemMap.get("colName"), "colText", itemMap.get("colText"), "dsName", dsName, "colDataset", itemMap.get("colDataset"), "colKeyField", itemMap.get("colKeyField"), "colValueField", itemMap.get("colValueField"));
            dataMap.put("colAlign", itemMap.get("colAlign"));
            dataMap.put("colFormat", itemMap.get("colFormat"));
            response.add(dataMap);
        }
        return response;
    }

    protected List<Option> getOptions(Long entId, String fieldName, String colDataset, String labelField, String valueField) {
        ArrayList<Option> response = new ArrayList<Option>();
        if (StringUtils.isEmpty((Object)colDataset) || StringUtils.isEmpty((Object)labelField) || StringUtils.isEmpty((Object)valueField)) {
            log.info("\u8bf7\u6c42{}\u5b57\u5178\u4fe1\u606f\u7a7a\uff0c\u4e0d\u4e88\u5904\u7406", (Object)fieldName);
            return response;
        }
        String reportCode = colDataset;
        if (reportCode.startsWith("RDS_")) {
            reportCode = reportCode.substring(4);
        }
        Map<String, Object> reportMap = this.getReport(entId, reportCode);
        log.info("\u8bf7\u6c42\u5b57\u5178:{}\u4fe1\u606f:{}", (Object)colDataset, (Object)JSON.toJSONString(reportMap));
        assert (reportMap != null) : "\u672a\u627e\u5230\u62a5\u8868\u5b57\u5178\u5b9a\u4e49";
        assert (reportMap.containsKey("querySQL")) : "\u672a\u627e\u5230\u62a5\u8868\u5b57\u5178\u67e5\u8be2\u8bed\u53e5\u5b9a\u4e49";
        String querySQL = TypeUtils.castToString(reportMap.get("querySQL"));
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet(querySQL);
        SqlRowSetMetaData metaData = sqlRowSet.getMetaData();
        while (sqlRowSet.next()) {
            String keyCode;
            String keyValue = keyCode = sqlRowSet.getString(1);
            if (metaData.getColumnCount() > 1) {
                keyValue = sqlRowSet.getString(2);
            }
            Option option = new Option();
            option.setLabel(keyValue);
            option.setValue(keyCode);
            response.add(option);
        }
        return response;
    }

    @Override
    protected Component onGenerateSearchFormItem(Long entId, Map<String, Object> paramItem) {
        Object response = null;
        log.info("params item:{}", (Object)JSON.toJSONString(paramItem));
        String bindParameter = TypeUtils.castToString(paramItem.get("name"));
        String label = TypeUtils.castToString(paramItem.get("desc"));
        String format = paramItem.containsKey("colFormat") ? TypeUtils.castToString(paramItem.get("colFormat")) : "yyyy-mm-dd";
        String colDataset = paramItem.containsKey("colDataset") ? TypeUtils.castToString(paramItem.get("colDataset")) : "";
        String labelField = paramItem.containsKey("labelField") ? TypeUtils.castToString(paramItem.get("labelField")) : "";
        String valueField = paramItem.containsKey("valueField") ? TypeUtils.castToString(paramItem.get("valueField")) : "";
        List<Option> options = this.getOptions(entId, bindParameter, colDataset, labelField, valueField);
        format = StringUtils.isEmpty((Object)format) ? "yyyy-mm-dd" : format;
        labelField = StringUtils.isEmpty((Object)labelField) ? "" : labelField;
        String string = valueField = StringUtils.isEmpty((Object)valueField) ? "" : valueField;
        if (StringUtils.isEmpty((Object)colDataset)) {
            colDataset = "";
        } else if (!colDataset.startsWith("RDS_")) {
            colDataset = String.format("RDS_%1$s", colDataset);
        }
        if (paramItem.containsKey("colType")) {
            int colType = TypeUtils.castToInt(paramItem.get("colType"));
            switch (colType) {
                case 1: {
                    response = this.createDateInput(bindParameter, label, format, LabelPosition.left);
                    break;
                }
                case 2: {
                    response = this.createRadioInput(bindParameter, label, options, LabelPosition.left);
                    break;
                }
                case 3: {
                    response = this.createCheckboxInput(bindParameter, label, options, LabelPosition.left);
                    break;
                }
                case 4: {
                    response = this.createSelectInput(bindParameter, label, colDataset, labelField, valueField, LabelPosition.left);
                    break;
                }
                case 5: {
                    response = this.createVueISelectInput(bindParameter, label, colDataset, labelField, valueField, options, LabelPosition.left);
                    break;
                }
                case 6: {
                    response = this.createVueTreeSelectInput(bindParameter, label, colDataset, labelField, valueField, options, LabelPosition.left);
                    break;
                }
                default: {
                    response = this.createTextInput(bindParameter, label, LabelPosition.left);
                    break;
                }
            }
        } else {
            response = this.createTextInput(bindParameter, label, LabelPosition.left);
        }
        return response;
    }

    public void generate(String reportName, OutputStream outStream, List<Map<String, Object>> paramsList, List<Map<String, Object>> responseList, Long entId, List<String> codes) {
        ReportDefinition report = new ReportDefinition();
        SearchForm searchForm = this.generateSearchForm(entId, paramsList);
        report.setSearchForm(searchForm);
        ArrayList<DatasetDefinition> datasets = new ArrayList<DatasetDefinition>();
        ArrayList<DatasourceDefinition> datasources = new ArrayList<DatasourceDefinition>();
        DatasourceDefinition dataSource = this.getSpringBeanDataSource("uReport", "idasReport", datasets);
        datasources.add(dataSource);
        this.setDataSource(report, datasources);
        boolean first = true;
        for (String reportCode : codes) {
            List<Object> fieldList;
            List<Map<String, Object>> columnList;
            ArrayList<Field> fields = new ArrayList<Field>();
            String dsName = String.format("RDS_%1$s", reportCode);
            DatasetDefinition dataset = this.getBeanDatasetDefinition(dsName, "query", fields);
            datasets.add(dataset);
            if (first) {
                first = false;
                CellStyle style = this.getDefaultCellStyle();
                columnList = this.onConvertField(responseList, dsName);
                fieldList = this.getDefaultGrid(report, style, columnList, null);
                fields.addAll(fieldList);
                continue;
            }
            Map<String, Object> reportMap = this.getReport(entId, reportCode);
            assert (reportMap != null) : "\u672a\u627e\u5230\u62a5\u8868\u5b9a\u4e49";
            assert (reportMap.containsKey("querySQL")) : "\u672a\u627e\u5230\u62a5\u8868\u67e5\u8be2\u8bed\u53e5\u5b9a\u4e49";
            columnList = this.getResponseList(TypeUtils.castToString(reportMap.get("querySQL")));
            fieldList = columnList.stream().map(fieldMap -> new Field(TypeUtils.castToString(fieldMap.get("colName")))).collect(Collectors.toList());
            fields.addAll(fieldList);
        }
        Paper paper = this.getDefaultPaper();
        this.setPaper(report, paper);
        report.setReportFullName(reportName);
        this.writerXML(report, outStream);
    }

    public List<Map<String, Object>> getParamsList(Long entId, Long reportId) {
        String querySQL = "SELECT colName,colText,colType,colFormat,colAlign,colDataset,colLabelField,colValueField FROM reportconds WHERE reportId=? AND entId=? ORDER BY colIndex,dataId";
        log.debug("getParamsList:{} params(entId={},reportId={})", new Object[]{querySQL, entId, reportId});
        List dataList = this.jdbcTemplate.queryForList(querySQL, new Object[]{reportId, entId});
        List<Map<String, Object>> responseList = dataList.stream().map(rowMap -> MapAs.of("name", rowMap.get("colName"), "desc", rowMap.get("colText"), "colType", rowMap.get("colType"), "colFormat", rowMap.get("colFormat"), "colAlign", rowMap.get("colAlign"), "colDataset", rowMap.get("colDataset"), "labelField", rowMap.get("colLabelField"), "valueField", rowMap.get("colValueField"))).collect(Collectors.toList());
        return responseList;
    }

    public List<Map<String, Object>> getResponseList(String querySQL) {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        querySQL = ParserUtils.parseNameHolder("${", "}", querySQL, new HashMap<String, String>());
        log.debug("getResponseList:{}", (Object)querySQL);
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(querySQL);
        SqlRowSetMetaData metaData = rowSet.getMetaData();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            String colName = metaData.getColumnName(i + 1);
            response.add(MapAs.of("colName", colName, "colText", colName));
        }
        return response;
    }

    public List<Map<String, Object>> getColumnList(Long entId, Long reportId, List<Map<String, Object>> columnList) {
        String querySQL = "SELECT colName,colText,colAlign,colFormat,colDataset,colKeyField,colValueField FROM reportcolumns WHERE reportId=? AND entId=? ORDER BY colIndex,dataId";
        log.debug("getParamsList:{} params(entId={},reportId={})", new Object[]{querySQL, entId, reportId});
        List dataList = this.jdbcTemplate.queryForList(querySQL, new Object[]{reportId, entId});
        this.initColumnConfig(entId, reportId, dataList, columnList);
        return this.jdbcTemplate.queryForList(querySQL, new Object[]{reportId, entId});
    }

    public void initColumnConfig(Long entId, Long reportId, List<Map<String, Object>> defineList, List<Map<String, Object>> columnList) {
        Map<String, List<Map>> defineMap = defineList.stream().collect(Collectors.groupingBy(x -> TypeUtils.castToString(x.get("colName"))));
        Map<String, List<Map>> currentMap = columnList.stream().collect(Collectors.groupingBy(x -> TypeUtils.castToString(x.get("colName"))));
        List filterList = currentMap.entrySet().stream().filter(dataFilter -> !defineMap.containsKey(dataFilter.getKey())).collect(Collectors.toList());
        String insertSQL = "INSERT INTO Reportcolumns(dataId,entId,reportId,colName,colText,colType,colFormat,colAlign,colDddw,lang,creator,createDate,modifier,updateDate) VALUES(:dataId,:entId,:reportId,:colName,:colText,:colType,:colFormat,:colAlign,:colDddw,:lang,:creator,:createDate,:modifier,:updateDate)";
        NamedParameterJdbcTemplate jdbcNameTemplate = this.getJdbcNameTemplate();
        for (Map.Entry itemEntry : filterList) {
            for (Map itemMap : (List)itemEntry.getValue()) {
                Map<String, String> paramMap = MapAs.of("dataId", this.flakeID.nextId(), "entId", 0L, "reportId", reportId, "colName", itemMap.get("colName"), "colText", itemMap.get("colText"), "colType", 1, "colFormat", "", "colAlign", "left", "colDddw", "");
                paramMap.putAll(MapAs.of("lang", "CN", "creator", "init", "createDate", new Date(), "modifier", "init", "updateDate", new Date()));
                jdbcNameTemplate.update(insertSQL, paramMap);
            }
        }
    }

    public Map<String, Object> getReport(Long entId, String reportCode) {
        String querySQL = "SELECT * FROM reportdefine WHERE reportCode=? AND entId=?";
        List dataList = this.jdbcTemplate.queryForList(querySQL, new Object[]{reportCode, entId});
        Optional optional = dataList.stream().findFirst();
        if (optional.isPresent()) {
            return (Map)optional.get();
        }
        return null;
    }

    @Override
    public String generate(Long entId, String reportCode, String fileName, List<String> codeList, String storeType) {
        return this.generate(entId, reportCode, fileName, codeList);
    }

    @Override
    public String generate(Long entId, String reportCode, String fileName, List<String> codeList) {
        Map<String, Object> reportMap = this.getReport(entId, reportCode);
        assert (reportMap != null) : "\u672a\u627e\u5230\u62a5\u8868\u5b9a\u4e49";
        assert (reportMap.containsKey("querySQL")) : "\u672a\u627e\u5230\u62a5\u8868\u67e5\u8be2\u8bed\u53e5\u5b9a\u4e49";
        List<Map<String, Object>> paramsList = this.getParamsList(0L, TypeUtils.castToLong(reportMap.get("dataId")));
        List<Map<String, Object>> responseList = this.getResponseList(TypeUtils.castToString(reportMap.get("querySQL")));
        responseList = this.getColumnList(entId, TypeUtils.castToLong(reportMap.get("dataId")), responseList);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayList<String> reportList = new ArrayList<String>();
        reportList.add(reportCode);
        paramsList.forEach(action -> {
            if (!StringUtils.isEmpty(action.get("colDataset")) && !reportList.contains(action.get("colDataset").toString())) {
                reportList.add(action.get("colDataset").toString());
            }
        });
        responseList.forEach(action -> {
            if (!StringUtils.isEmpty(action.get("colDataset")) && !reportList.contains(action.get("colDataset").toString())) {
                reportList.add(action.get("colDataset").toString());
            }
        });
        this.generate("uReport", baos, paramsList, responseList, entId, reportList);
        byte[] btBuffer = baos.toByteArray();
        String content = "";
        try {
            content = new String(btBuffer, "utf-8");
            log.info(content);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        FileReportProvider fileReportProvider = SpringContext.getBean(FileReportProvider.class, new Object[0]);
        fileReportProvider.saveReport(fileName, content);
        return null;
    }

    @Override
    public String generate(Long entId, String reportCode) {
        return null;
    }
}

