/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.util.TypeUtils;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.searchform.SearchForm;
import com.product.util.MapAs;
import com.shiji.core.ureport.component.AbstractReportService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportServiceImpl
extends AbstractReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);

    private List<Map<String, Object>> parameterCombine(List<Map<String, Object>> paramsList) {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> paramsMap : paramsList) {
            String itemName = TypeUtils.castToString((Object)paramsMap.get("name"));
            Object value = paramsMap.get("value");
            if (value == null) continue;
            if (value instanceof List) {
                List dataList = (List)value;
                for (Map itemMap : dataList) {
                    String childName = TypeUtils.castToString(itemMap.get("name"));
                    itemMap.put("name", String.format("%1$s.%2$s", itemName, childName));
                }
                response.addAll(dataList);
                continue;
            }
            response.add(paramsMap);
        }
        return response;
    }

    @Override
    protected List<Map<String, Object>> onBeforeGenerateSearchForm(List<Map<String, Object>> paramsList) {
        return this.parameterCombine(paramsList);
    }

    protected List<Map<String, Object>> onConvertField(List<Map<String, Object>> dataList, String dsName) {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> itemMap : dataList) {
            Map<String, String> dataMap = MapAs.of("colName", itemMap.get("name"), "colText", itemMap.get("desc"), "dsName", dsName);
            response.add(dataMap);
        }
        return response;
    }

    public void generate(String reportName, OutputStream outStream, Long entId, String datasouceName, List<Map<String, Object>> paramsList, List<Map<String, Object>> responseList) {
        this.generate(reportName, outStream, entId, "beanBuildinDataSource", "loadReportData", datasouceName, "loadReportData", paramsList, responseList);
    }

    public void generate(String reportName, String fileName, Long entId, String datasouceName, List<Map<String, Object>> paramsList, List<Map<String, Object>> responseList) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileOutputStream osw = new FileOutputStream(f);
        this.generate(reportName, osw, entId, "beanBuildinDataSource", "loadReportData", datasouceName, "loadReportData", paramsList, responseList);
        osw.close();
    }

    public void generate(String reportName, OutputStream outStream, Long entId, String beanName, String methodName, String datasouceName, String datasetName, List<Map<String, Object>> paramsList, List<Map<String, Object>> responseList) {
        log.debug("generate: reportName:{} beanName:{} methodName:{} datasouceName:{} datasetName:{} params:{} output:{}", new Object[]{reportName, beanName, methodName, datasouceName, datasetName, JSON.toJSONString(paramsList), JSON.toJSONString(responseList)});
        ReportDefinition report = new ReportDefinition();
        SearchForm searchForm = this.generateSearchForm(entId, paramsList);
        report.setSearchForm(searchForm);
        ArrayList<Field> fields = new ArrayList<Field>();
        DatasetDefinition dataset = this.getBeanDatasetDefinition(datasetName, methodName, fields);
        List<DatasetDefinition> datasets = Arrays.asList(dataset);
        ArrayList<DatasourceDefinition> datasources = new ArrayList<DatasourceDefinition>();
        DatasourceDefinition dataSource = this.getSpringBeanDataSource(datasouceName, beanName, datasets);
        datasources.add(dataSource);
        this.setDataSource(report, datasources);
        CellStyle style = this.getDefaultCellStyle();
        List<Map<String, Object>> columnList = this.onConvertField(responseList, "loadReportData");
        List<Field> fieldList = this.getDefaultGrid(report, style, columnList, null);
        fields.addAll(fieldList);
        Paper paper = this.getDefaultPaper();
        this.setPaper(report, paper);
        report.setReportFullName(reportName);
        this.writerXML(report, outStream);
    }
}

