/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.product.model.ServiceSession;
import com.shiji.core.deserializer.BeanDeserializer;
import com.shiji.core.deserializer.DeserializerConfig;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class BaseInvoker {
    private static final Logger log = LoggerFactory.getLogger(BaseInvoker.class);

    public Object toJavaObject(JSONObject jsonObject, Class<?> clazz) {
        BeanDeserializer beanDeserializer = DeserializerConfig.getGlobalInstance().get(clazz);
        if (beanDeserializer != null) {
            return beanDeserializer.deserializer(jsonObject);
        }
        return JSON.parseObject((String)jsonObject.toString(), clazz);
    }

    public Object toJavaObjectList(JSONArray jsonArray, Class<?> clazz) {
        return JSON.parseArray((String)jsonArray.toString(), clazz);
    }

    private Method getMethod(Class<?> classzz, String name, Class<?> ... parameterTypes) {
        Method classmethod;
        block2: {
            classmethod = null;
            try {
                classmethod = classzz.getMethod(name, parameterTypes);
            }
            catch (Exception ex) {
                if (!classzz.isInterface()) break block2;
                log.error("classzz. interface");
            }
        }
        return classmethod;
    }

    public Method getSuperFirstMethod(Class<?> clazz, String methodName) {
        block5: {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
            List<Class[]> paramsList = Arrays.asList({ServiceSession.class, JSONObject.class}, {ServiceSession.class, String.class}, {ServiceSession.class, String.class, List.class}, {String.class}, {ServiceSession.class, String.class, MultipartFile.class}, {ServiceSession.class, String.class, OutputStream.class});
            for (Class[] itemClass : paramsList) {
                Method response = this.getMethod(clazz, methodName, itemClass);
                if (response == null) continue;
                return response;
            }
            try {
                Method[] methodAll;
                for (Method method : methodAll = clazz.getMethods()) {
                    if (!method.getName().equalsIgnoreCase(methodName)) continue;
                    return method;
                }
            }
            catch (Exception ex) {
                if (!clazz.isInterface()) break block5;
                log.error("classzz. interface");
            }
        }
        return null;
    }

    public Method getFirstMethod(Class<?> clazz, String methodName) {
        return this.getSuperFirstMethod(clazz, methodName);
    }

    public Method getMethod(Object target, String methodName) {
        Method response = this.getFirstMethod(target.getClass(), methodName);
        return response;
    }

    public Object invoke(Object target, String methodName, JSONObject paramsObject) throws Exception {
        Method method = this.getMethod(target, methodName);
        if (method == null) {
            throw new Exception(String.format("\u672a\u627e\u5230\u7c7b\u3010%1$s\u3011\u5bf9\u5e94\u7684\u65b9\u6cd5\u3010%2$s\u3011\u5b9a\u4e49", target.getClass().getSimpleName(), methodName));
        }
        ArrayList<Object> paramsList = new ArrayList<Object>();
        Type[] genericTypes = method.getGenericParameterTypes();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter paramItem = parameters[i];
            String name = paramItem.getName();
            Type genericType = genericTypes[i];
            Class actualTypeClazz = Object.class;
            try {
                ParameterizedType parameterizedType;
                Type[] typeList;
                if (genericType instanceof ParameterizedType && (typeList = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()) != null && typeList.length > 0) {
                    actualTypeClazz = Class.forName(typeList[0].getTypeName());
                }
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            Object value = paramsObject.get((Object)name);
            Object targetValue = null;
            if (value == null) {
                targetValue = null;
            } else if (value.getClass().getName().equalsIgnoreCase(paramItem.getType().getName())) {
                targetValue = value;
            } else if (value instanceof JSONObject) {
                targetValue = this.toJavaObject((JSONObject)value, paramItem.getType());
            } else if (value instanceof JSONArray) {
                targetValue = this.toJavaObjectList((JSONArray)value, actualTypeClazz);
            } else if (paramItem.getType().equals(String.class)) {
                log.error("params is String");
                targetValue = paramsObject.getString(name);
            } else if (paramItem.getType().equals(Integer.class)) {
                log.error("params is Integer");
                targetValue = paramsObject.getIntValue(name);
            } else if (paramItem.getType().equals(Long.class)) {
                log.error("params is Long");
                targetValue = paramsObject.getLong(name);
            } else if (paramItem.getType().equals(Date.class)) {
                log.error("params is Date");
                targetValue = paramsObject.getDate(name);
            } else if (paramItem.getType().equals(JSONObject.class)) {
                log.error("params is JSONObject");
                targetValue = paramsObject.getJSONObject(name);
            } else if (paramItem.getType().equals(JSONArray.class)) {
                log.error("params is JSONArray");
                targetValue = paramsObject.getJSONArray(name);
            } else if (paramItem.getType().equals(List.class)) {
                log.error("params is List");
                targetValue = paramsObject.getObject(name, List.class);
            } else if (paramItem.getType().equals(Map.class)) {
                log.error("params is Map");
                targetValue = paramsObject.getObject(name, Map.class);
            } else {
                log.error("params is {}", (Object)paramItem.getType().getName());
                targetValue = TypeUtils.cast((Object)value, paramItem.getType(), null);
            }
            paramsList.add(targetValue);
        }
        log.error("paramsList:{}", (Object)JSON.toJSONString(paramsList));
        return ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])paramsList.toArray());
    }
}

