<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8" />
    <title>API在线调用</title>
    <!-- -->
    <link href="/static/css/style.css" rel="stylesheet">
    <!-- 控制视区 -->
    <link href="/static/css/app.css" rel="stylesheet">
    <!-- 表格折叠 -->
    <link href="/static/css/table-coalesce.css" rel="stylesheet">
    <!-- TabPage 控件CSS -->
    <link href="/static/css/tabpage.css" rel="stylesheet">
    <script src="/static/js/jquery-2.1.4.js" type="text/javascript"></script>
    <!-- 表格折叠 -->
    <script src="/static/js/table-coalesce.js" type="text/javascript"></script>
    <style>
        #card li {
            height: auto;
            line-height: unset;
        }
    </style>

    <script type="text/javascript">
        $(function () {
            // 界面加载给table这个class下的所有input增加监听事件
            $(".table input").each(function () {
                $(this).bind("input propertychange", function () {
                    getParam();
                });
            });

            // 按钮监听事件
            $(".submit").click(function () {
                var methodURL = $('#requestURL').val();
                console.log("requestURL:", methodURL);

                var queryParam = $('.input').val();
                console.log("queryParam:", queryParam);

                $.ajax({
                    url: methodURL,
                    type: 'post',
                    dataType: 'json',
                    data: queryParam,
                    contentType: 'application/json',
                    success: function (data) {
                        console.log("response:", JSON.stringify(data));
                        $('.output').val(JSON.stringify(data));
                        setTableList(data);
                    },
                });
            });

               // tabPage
            $('#option li').click(function () {
                $(this).addClass('active').siblings().removeClass('active');
                var a = $(this).index();
                $('#card li:eq(' + a + ')').addClass('active').siblings().removeClass('active');
            });

            $('.test').click(function () {
                setTableList();
            })
        });

        let cloneTr = null;

        // tabPage
        function setTableList(data) {

            // 模拟数据
            // let data = {
            //     "data": {
            //         "total_results": 1, "user": [
            //             { "departmentid": "utf-8", "departmentcode": "1234567890000000", "departmentname": "0", "entid": 0, "entname": "产品中心0", "ivparameter": "1234567890000000" },
            //             { "departmentid": "utf-9", "departmentcode": "2222", "departmentname": "0222", "entid": 0, "entname": "产品中心0", "ivparameter": "1234567890000000" }
            //         ]
            //     }, "returncode": "0"
            // }

            let key = $("#datalist").attr("key");
            if (!cloneTr) {
                cloneTr = $("#datalist tbody tr").eq(0).clone();
            }
            $("#datalist tbody").empty();
            // 数据遍历
            for (let i = 0, len = data.data[key].length; i < len; i++) {
                const cell = data.data[key][i];
                let bc = cloneTr.clone();
                bc.children().each(function () {
                    let name = $(this).attr('name');
                    $(this).html(cell[name]);
                });
                bc.appendTo("#datalist");
            }
        };

        // 获取请求参数方法
        function getParam() {
            let param = {};
            $(".table input").each(function () {
                let trClass = $(this).parent().parent().attr('class').split('_');
                let keyID = trClass[1];
                if (!param[keyID]) {
                    param[keyID] = {};
                }
                let key = $(this).attr('name');
                let value = $(this).val();
                    // 如果没有值，则不生成
                if (value.trim() !== '') {
                    param[keyID][key] = value;
                }
            });
            $('.input').val(JSON.stringify(param));
        }
        function oldGetParam() {
            let param = {};
            $(".table input").each(function () {
                let key = $(this).attr('name');
                let value = $(this).val();
                param[key] = value
            });
            $('.input').val(JSON.stringify(param));
        }
    </script>
</head>

<body>
    <div class="card">
        <div class="card-block">
            <div>
                <p><span class="sql">API在线调用 enterpriseKeyExposerImpl.onQuery</span> API说明:商品基本资料查询API</p>
                <table style="border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;">
                    <tr>
                        <td style="width:80px;border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;">
                            <span style="width: 60px; height:24px;color: red;float:left; text-align:right;"
                                class="sql">请求地址:</span></td>
                        <td style="width:100%;border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;">
                            <input style="width: 100%;height:24px;display: inline-block" type="text" id="requestURL"
                                value="http://172.17.13.81:8081/enterprisekey/query?method=enterpriseKeyExposerImpl.onQuery" />
                        </td>
                    </tr>
                </table>

                <!-- list循环 -->
                <table class="table">
                    <tbody>
                        <tr>
                            <th style="width:200px">参数序号</th>
                            <th>参数名称</th>
                            <th>参数类型</th>
                            <th>参数需求</th>
                            <th>参数描述</th>
                            <th>参数数值</th>
                        </tr>
                        <tr class="parent" id="model">
                            <td>model</td>
                            <td colspan="5">com.normal.enterprise.model.EnterpriseKeyModel</td>
                        </tr>
                        <tr class="child_model">
                            <td>0</td>
                            <td>entid</td>
                            <td>class java.lang.Long</td>
                            <td></td>
                            <td>零售商ID</td>
                            <td><input type="text" name="entid" value="0" /></td>
                        </tr>
                        <tr class="child_model">
                            <td>1</td>
                            <td>entcode</td>
                            <td>class java.lang.String</td>
                            <td></td>
                            <td>零售商编码</td>
                            <td><input type="text" name="entcode" value="0" /></td>
                        </tr>
                        <tr class="child_model">
                            <td>2</td>
                            <td>entname</td>
                            <td>class java.lang.String</td>
                            <td></td>
                            <td>零售商名称</td>
                            <td><input type="text" name="entname" value="产品中心" /></td>
                        </tr>
                        <tr class="child_model">
                            <td>3</td>
                            <td>encryptkey</td>
                            <td>class java.lang.String</td>
                            <td></td>
                            <td>秘钥偏移量</td>
                            <td><input type="text" name="encryptkey" value="1234567890000000" /></td>
                        </tr>
                        <tr class="child_model">
                            <td>4</td>
                            <td>ivparameter</td>
                            <td>class java.lang.String</td>
                            <td></td>
                            <td>秘钥</td>
                            <td><input type="text" name="ivparameter" value="1234567890000000" /></td>
                        </tr>
                        <tr class="child_model">
                            <td>5</td>
                            <td>encodingformat</td>
                            <td>class java.lang.String</td>
                            <td></td>
                            <td>字符编码方式</td>
                            <td><input type="text" name="encodingformat" value="utf-8" /></td>
                        </tr>
                    </tbody>
                </table>
                <div>
                    <textarea class="input" rows="3" cols="20"
                        style="width:100%;height:300px;padding:0px;">{"test":"aaa"}</textarea>
                </div>
                <button class="submit" type="button">在线调用</button><button class="save"
                    type="button">保存参数</button><button class="test" type="button">临时测试</button>


                <ul id="option" style="margin-bottom: 0;margin-top:5px;">
                    <li class="active">API输出JSON结果</li>
                    <li>API输出集合结果</li>
                </ul>
                <ul id="card">
                    <li class="active">
                <textarea class="output" rows="3" cols="20" style="width:100%;height:300px;padding:10px;border:none;">暂无结果</textarea>
                    </li>
                    <li class="">

                        <!-- list循环 -->
                        <table id="datalist" key="user" class="table">
                            <thead>
                                <tr>
                                    <th name="departmentid">部门id</th>
                                    <th name="departmentcode">部门编码</th>
                                    <th name="departmentname">部门名称</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="each">
                                    <td name="departmentid">java.lang.Long</td>
                                    <td name="departmentcode">java.lang.String</td>
                                    <td name="departmentname">java.lang.String</td>
                                </tr>
                            </tbody>
                        </table>

                    </li>
                </ul>


            </div>
        </div>
    </div>
</body>

</html>