/*
 * Decompiled with CFR 0.152.
 */
package com.product.language;

import com.product.util.SpringContext;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.StringUtils;

public class MessageSourceHelper {
    private static final Logger loggerMsg = LoggerFactory.getLogger((String)"messageHelperLogger");
    private ResourceBundleMessageSource messageSource;

    public static MessageSourceHelper getDefault() {
        return SpringContext.getBean("messageSourceHelper", MessageSourceHelper.class);
    }

    public static String getMessage(String code, String locale, Object ... args) {
        return MessageSourceHelper.getDefault().getMessage(code, code, StringUtils.isEmpty((Object)locale) ? null : new Locale(locale), args);
    }

    public static String getMessageWithDefault(String code, String defaultMessage, String locale, Object ... args) {
        return MessageSourceHelper.getDefault().getMessage(code, defaultMessage, StringUtils.isEmpty((Object)locale) ? null : new Locale(locale), args);
    }

    private String messageJoin(String joinAnd, Object ... args) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i < 1) {
                buffer.append(args[i]);
                continue;
            }
            buffer.append(String.format(" %1$s %2$s", joinAnd, args[i]));
        }
        return buffer.toString();
    }

    private Method getMethod(Class<?> classzz, String methodName, Class<?> ... parameterTypes) throws Exception {
        try {
            Method method = classzz.getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException nsme) {
            try {
                Method method = classzz.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException nsme2) {
                Class<?> supClasszz = classzz.getSuperclass();
                if (supClasszz != null) {
                    System.out.println(supClasszz.getClass().getName());
                    return this.getMethod(supClasszz, methodName, parameterTypes);
                }
                throw new Exception("not found method:" + methodName);
            }
        }
    }

    private String getDebugMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        try {
            Method messageInternal = this.getMethod(this.messageSource.getClass(), "getMessageInternal", String.class, Object[].class, Locale.class);
            Object resultMsg = messageInternal.invoke((Object)this.messageSource, code, args, locale);
            if (resultMsg != null) {
                loggerMsg.error("getMessageInternal:{}", resultMsg);
                return resultMsg.toString();
            }
            if (defaultMessage == null) {
                Method defaultMessageMethod = this.getMethod(this.messageSource.getClass(), "getDefaultMessage", String.class);
                Object fallback = defaultMessageMethod.invoke((Object)this.messageSource, code);
                if (fallback != null) {
                    loggerMsg.error("getDefaultMessage:{}", fallback);
                    return fallback.toString();
                }
            }
            Method renderDefaultMessageMethod = this.getMethod(this.messageSource.getClass(), "renderDefaultMessage", String.class, Object[].class, Locale.class);
            Object defaultMsg = renderDefaultMessageMethod.invoke((Object)this.messageSource, defaultMessage, args, locale);
            loggerMsg.error("renderDefaultMessageMethod.invoke:{}", defaultMsg);
            return defaultMsg.toString();
        }
        catch (Exception e) {
            loggerMsg.error("Exception.invoke:{}", (Object)e.getMessage(), (Object)e);
            return this.messageSource.getMessage(code, args, defaultMessage, locale);
        }
    }

    public String getMessage(String code, String defaultMessage, Locale locale, Object ... args) {
        String message = MessageFormat.format("code={0} defaultMsg:{1} args:{2}", code, defaultMessage, this.messageJoin(" ", args));
        loggerMsg.error("MessageSourceHelper->{}", (Object)message);
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = String.valueOf(args[i]);
        }
        Object msg = "";
        if (loggerMsg.isDebugEnabled()) {
            msg = this.getDebugMessage(code, args, defaultMessage, locale);
        } else {
            if (code.equalsIgnoreCase("10000") || code.equalsIgnoreCase("50000")) {
                if (args != null && args.length > 0 && !StringUtils.isEmpty((Object)defaultMessage)) {
                    defaultMessage = MessageFormat.format(defaultMessage, args);
                }
                msg = (String)msg + defaultMessage;
            }
            if (StringUtils.isEmpty((Object)msg)) {
                msg = this.messageSource.getMessage(code, args, defaultMessage, locale);
            }
            loggerMsg.error("set.invoke:{}", msg);
        }
        return msg != null ? ((String)msg).trim() : msg;
    }

    public void setMessageSource(ResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

