/*
 * Decompiled with CFR 0.152.
 */
package com.product.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.product.exception.ServiceRuntimeException;
import com.product.model.BeanConstant;
import com.product.model.ServiceSession;
import com.product.query.TemplateQuery;
import com.product.service.AnnotationService;
import com.product.service.OperationFlag;
import com.product.service.QueryConvertHandler;
import com.product.util.MapAs;
import com.product.util.TypeUtils;
import com.shiji.core.component.BaseComponent;
import com.shiji.core.component.CustomQueryConvert;
import com.shiji.core.storage.DataQueryHandler;
import com.shiji.core.util.I18nUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class StorageQuery
implements TemplateQuery {
    private static final Logger log = LoggerFactory.getLogger(StorageQuery.class);
    private DataQueryHandler storageQuery;
    private QueryConvertHandler convert;
    private Map<String, Integer> identifyMap;
    private List<AnnotationService> plugins;

    private void init() {
        this.identifyMap = MapAs.of("fields", 1, "order_direction", 1, "order_field", 1, "page_no", 1, "page_size", 1);
        this.convert = new CustomQueryConvert();
    }

    public static StorageQuery with(DataQueryHandler storageQuery) {
        StorageQuery templateQuery = StorageQuery.with(storageQuery, null);
        return templateQuery;
    }

    public static StorageQuery with(DataQueryHandler storageQuery, List<AnnotationService> plugins) {
        StorageQuery templateQuery = new StorageQuery(storageQuery, plugins);
        return templateQuery;
    }

    private StorageQuery(DataQueryHandler storageQuery, List<AnnotationService> plugins) {
        this.storageQuery = storageQuery;
        this.plugins = plugins;
        this.init();
    }

    private <T> String[] checkFields(String[] paramFields, Set<String> returnSet, Class<T> classzz) {
        ArrayList<Field> modelFields = new ArrayList<Field>();
        modelFields.addAll(Arrays.asList(classzz.getDeclaredFields()));
        Class<T> clazz = classzz;
        while (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            Field[] tmp = clazz.getSuperclass().getDeclaredFields();
            modelFields.addAll(Arrays.asList(tmp));
            clazz = clazz.getSuperclass();
        }
        return BaseComponent.checkFields(paramFields, returnSet, modelFields.toArray(new Field[0]));
    }

    private <T> void initPage(Query query, JSONObject paramsObject) {
        Integer pageno = BeanConstant.QueryPage.DEFAULT_PAGENO;
        Integer pageSize = BeanConstant.QueryPage.DEFAULT_PAGESIZE;
        if (paramsObject.containsKey((Object)"page_no")) {
            pageno = paramsObject.getInteger("page_no") - 1;
        }
        if (paramsObject.containsKey((Object)"page_size")) {
            pageSize = paramsObject.getInteger("page_size");
        }
        if (pageno < 0) {
            pageno = 0;
        }
        query.with((Pageable)PageRequest.of((int)pageno, (int)pageSize));
    }

    private <T> void initSort(Query query, JSONObject paramsObject) {
        Sort order = null;
        if (paramsObject.containsKey((Object)"order_field") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_field"))) {
            if (paramsObject.containsKey((Object)"order_direction") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_direction"))) {
                String[] dirs = paramsObject.getString("order_direction").split(",");
                String[] flds = paramsObject.getString("order_field").split(",");
                ArrayList<Sort.Order> lst = new ArrayList<Sort.Order>();
                for (int i = 0; i < flds.length; ++i) {
                    if (i < dirs.length) {
                        lst.add(new Sort.Order(Sort.Direction.fromString((String)dirs[i]), flds[i].trim()));
                        continue;
                    }
                    lst.add(Sort.Order.by((String)flds[i].trim()));
                }
                order = Sort.by(lst);
            } else {
                order = Sort.by((String[])paramsObject.getString("order_field").split(","));
            }
        }
        if (order != null) {
            query.with(order);
        }
    }

    private <T> void initPageSort(ServiceSession session, Query query, JSONObject paramsObject, Class<T> classzz, Boolean isPage) {
        org.springframework.data.mongodb.core.query.Field flds = query.fields();
        if (paramsObject.containsKey((Object)"fields") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"fields"))) {
            String[] paramFields = paramsObject.getString("fields").split(",");
            HashSet<String> set = new HashSet<String>();
            paramFields = this.checkFields(paramFields, set, classzz);
            if (set.size() > 0) {
                throw new ServiceRuntimeException("10006", I18nUtil.getMessage("10014", new Object[]{"fields", set.toArray()}, session.getLocale()));
            }
            for (int i = 0; i < paramFields.length; ++i) {
                if (StringUtils.isEmpty((Object)paramFields[i].trim())) continue;
                flds.include(paramFields[i].trim());
            }
        } else {
            flds.include("*");
        }
        if (isPage.booleanValue()) {
            this.initPage(query, paramsObject);
        }
        this.initSort(query, paramsObject);
    }

    @Override
    public <T> List<T> query(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return this.query(session, paramsObject, collectionName, classzz, true);
    }

    @Override
    public <T> List<T> query(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz, Boolean isPage) {
        paramsObject = (JSONObject)TypeUtils.filter((JSON)paramsObject, new ValueFilter(this){

            public Object process(Object object, String name, Object value) {
                if (value != null && value instanceof String && value.toString().isEmpty()) {
                    return null;
                }
                return value;
            }
        });
        List<Criteria> criteriaList = this.convert.onConvert(paramsObject, this.identifyMap, classzz);
        Query query = new Query();
        this.initPageSort(session, query, paramsObject, classzz, isPage);
        query = this.convert.baseCreateQuery(query, criteriaList);
        log.debug("before:{} after:{}", (Object)JSON.toJSONString((Object)paramsObject), (Object)query.toString());
        List<T> dataList = this.query(session, query, collectionName, classzz);
        if (!paramsObject.containsKey((Object)"searchPluginFlag")) {
            for (AnnotationService plugin : this.plugins) {
                try {
                    plugin.onAction(session, dataList, OperationFlag.afterQuery, classzz);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dataList;
    }

    @Override
    public <T> T queryFirst(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        paramsObject.put("page_no", (Object)1);
        paramsObject.put("page_size", (Object)1);
        List<T> dataList = this.query(session, paramsObject, collectionName, classzz);
        Optional responseOptional = dataList.stream().findFirst();
        if (responseOptional.isPresent()) {
            return (T)responseOptional.get();
        }
        return null;
    }

    @Override
    public <T> List<T> query(ServiceSession session, Query query, String collectionName, Class<T> classzz) {
        List<T> dataList = this.storageQuery.select(query, classzz, collectionName, 1);
        for (AnnotationService plugin : this.plugins) {
            try {
                plugin.onAction(session, dataList, OperationFlag.afterQuery, classzz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataList;
    }

    @Override
    public <T> T queryFirst(ServiceSession session, Query query, String collectionName, Class<T> classzz) {
        List<T> dataList = this.query(session, query, collectionName, classzz);
        Optional responseOptional = dataList.stream().findFirst();
        if (responseOptional.isPresent()) {
            return (T)responseOptional.get();
        }
        return null;
    }
}

