/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.bstek.ureport.definition.ReportDefinition;
import com.product.exception.ServiceRuntimeException;
import com.product.model.AbstractEntityBean;
import com.product.model.BaseQueryModel;
import com.product.model.BeanConstant;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.service.OperationFlag;
import com.product.util.MapAs;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import com.shiji.core.annotation.CreateTime;
import com.shiji.core.annotation.Creator;
import com.shiji.core.annotation.Editor;
import com.shiji.core.annotation.ModifyTime;
import com.shiji.core.component.BaseComponent;
import com.shiji.core.service.BaseCompomentHandler;
import com.shiji.core.service.OpLogService;
import com.shiji.core.util.I18nUtil;
import com.shiji.core.util.UReportUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.util.StringUtils;

public abstract class BaseExposer<T extends BaseQueryModel, S extends BaseCompomentHandler>
extends BaseComponent<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseExposer.class);
    @Autowired
    private OpLogService opLogService;
    private boolean isForceKeyDelete = true;

    protected abstract String getcollectionName();

    public boolean isForceKeyDelete() {
        return this.isForceKeyDelete;
    }

    public void setForceKeyDelete(boolean isForceKeyDelete) {
        this.isForceKeyDelete = isForceKeyDelete;
    }

    protected Map<String, Object> getPageConfig(T model) {
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        if (model != null && model instanceof BaseQueryModel) {
            String fields = ((BaseQueryModel)model).getFields();
            String orderDirection = ((BaseQueryModel)model).getOrder_direction();
            String orderField = ((BaseQueryModel)model).getOrder_field();
            Integer pageno = ((BaseQueryModel)model).getPage_no();
            Integer pageSize = ((BaseQueryModel)model).getPage_size();
            if (!StringUtils.isEmpty((Object)fields)) {
                pageMap.put("fields", fields);
            }
            if (!StringUtils.isEmpty((Object)orderDirection)) {
                pageMap.put("order_direction", orderDirection);
            }
            if (!StringUtils.isEmpty((Object)orderField)) {
                pageMap.put("order_field", orderField);
            }
            if (pageno != null && pageno > 0) {
                pageMap.put("page_no", pageno);
            } else {
                pageMap.put("page_no", BeanConstant.QueryPage.DEFAULT_PAGENO);
            }
            if (pageSize != null && pageSize > 0) {
                pageMap.put("page_size", pageSize);
            } else {
                pageMap.put("page_size", BeanConstant.QueryPage.DEFAULT_PAGESIZE);
            }
        }
        return pageMap;
    }

    protected Map<String, Object> getViewConfig(T model) {
        Map<String, Object> pageMap = this.getPageConfig(model);
        pageMap.put("page_no", 0);
        pageMap.put("page_size", 1);
        return pageMap;
    }

    public JSONObject getQueryParam(T model) {
        Map<String, Object> pageMap = this.getPageConfig(model);
        String paramsStr = "{}";
        if (model != null) {
            JSONObject paramsObj = (JSONObject)TypeUtils.toJSON(model, true, new SerializerFeature[0]);
            paramsStr = paramsObj.toString();
        }
        JSONObject paramsObject = JSONObject.parseObject((String)paramsStr);
        paramsObject.putAll(pageMap);
        return paramsObject;
    }

    public JSONObject getViewParam(T model) {
        Map<String, Object> pageMap = this.getViewConfig(model);
        String paramsStr = "{}";
        if (model != null) {
            JSONObject paramsObj = (JSONObject)TypeUtils.toJSON(model, true, new SerializerFeature[0]);
            paramsStr = paramsObj.toString();
        }
        JSONObject paramsObject = JSONObject.parseObject((String)paramsStr);
        paramsObject.putAll(pageMap);
        return paramsObject;
    }

    public JSONObject getNormalParam(T model) {
        String paramsStr = "{}";
        if (model != null) {
            JSONObject paramsObj = (JSONObject)TypeUtils.toJSON(model, false, new SerializerFeature[0]);
            paramsStr = paramsObj.toString();
        }
        JSONObject paramsObject = JSONObject.parseObject((String)paramsStr);
        return paramsObject;
    }

    public JSONObject getNormalParam(List<T> model) {
        List<T> dataList = model;
        JSONObject paramsObject = new JSONObject();
        if (model == null) {
            paramsObject.put(this.getcollectionName(), new ArrayList());
        } else {
            JSONArray paramsList = (JSONArray)TypeUtils.toJSON(dataList, false, new SerializerFeature[0]);
            paramsObject.put(this.getcollectionName(), (Object)paramsList);
        }
        return paramsObject;
    }

    private String getModelFlag(T Model) {
        try {
            Object flag = AbstractEntityBean.getFieldValue(Model.getClass(), Model, "_flag");
            return (String)flag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "#";
        }
    }

    protected void logModel(ServiceSession session, T oModel, T nModel, OperationFlag flag) {
        this.opLogService.logger(session, oModel, nModel, flag);
    }

    protected void initModel(ServiceSession session, T model, OperationFlag flag) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = model.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : fieldList) {
            Object value = null;
            boolean assignFlag = false;
            if (field.isAnnotationPresent(Creator.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.All)) {
                    value = session.getUser_code();
                    assignFlag = true;
                } else if (flag.equals((Object)OperationFlag.None) && "I".equalsIgnoreCase(this.getModelFlag(model))) {
                    value = session.getUser_code();
                    assignFlag = true;
                }
            } else if (field.isAnnotationPresent(CreateTime.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.All)) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                } else if (flag.equals((Object)OperationFlag.None) && "I".equalsIgnoreCase(this.getModelFlag(model))) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                }
            } else if (field.isAnnotationPresent(Editor.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.Update) || flag.equals((Object)OperationFlag.All)) {
                    value = session.getUser_code();
                    assignFlag = true;
                } else if (flag.equals((Object)OperationFlag.None) && ("U".equalsIgnoreCase(this.getModelFlag(model)) || "I".equalsIgnoreCase(this.getModelFlag(model)))) {
                    value = session.getUser_code();
                    assignFlag = true;
                }
            } else if (field.isAnnotationPresent(ModifyTime.class)) {
                if (flag.equals((Object)OperationFlag.Insert) || flag.equals((Object)OperationFlag.Update) || flag.equals((Object)OperationFlag.All)) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                } else if (flag.equals((Object)OperationFlag.None) && ("U".equalsIgnoreCase(this.getModelFlag(model)) || "I".equalsIgnoreCase(this.getModelFlag(model)))) {
                    if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                        value = System.currentTimeMillis();
                        assignFlag = true;
                    } else {
                        value = new Date();
                        assignFlag = true;
                    }
                }
            }
            if (!assignFlag) continue;
            field.setAccessible(true);
            try {
                field.set(model, value);
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u64cd\u4f5c\u4eba\u5458\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public ServiceResponse insert(S invoker, List<T> model) {
        List<T> dataList = model;
        ServiceSession session = SpringContext.getSession();
        for (BaseQueryModel rowModel : dataList) {
            this.initModel(session, rowModel, OperationFlag.Insert);
        }
        JSONObject paramsObject = new JSONObject();
        if (model == null) {
            paramsObject.put(this.getcollectionName(), new ArrayList());
        } else {
            JSONArray paramsList = (JSONArray)TypeUtils.toJSON(dataList, false, new SerializerFeature[0]);
            paramsObject.put(this.getcollectionName(), (Object)paramsList);
        }
        log.info("insert:{}", (Object)paramsObject.toString());
        return invoker.onInsert(session, paramsObject);
    }

    public ServiceResponse insert(S invoker, T model) {
        ServiceSession session = SpringContext.getSession();
        this.initModel(session, model, OperationFlag.Insert);
        JSONObject paramsObject = this.getNormalParam(model);
        log.info("insert:{}", (Object)paramsObject.toString());
        return invoker.onInsert(session, paramsObject);
    }

    protected ServiceResponse withReturn(ServiceResponse response, S invoker, Integer pageno, Integer pageSize) {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = new JSONObject();
        if (pageno == null) {
            pageno = BeanConstant.QueryPage.DEFAULT_PAGENO;
        }
        if (pageSize == null) {
            pageSize = BeanConstant.QueryPage.DEFAULT_PAGESIZE;
        }
        paramsObject.put("page_no", (Object)pageno);
        paramsObject.put("page_size", (Object)pageSize);
        if ("0".equals(response.getReturncode())) {
            Object data = response.getData();
            if (data instanceof List) {
                List dataList = (List)data;
                paramsObject.put(invoker.getKeyfieldName(), MapAs.of("$in", dataList));
            } else if (data instanceof Map) {
                Map dataMap = (Map)data;
                if (dataMap.containsKey(invoker.getKeyfieldName())) {
                    paramsObject.put(invoker.getKeyfieldName(), dataMap.get(invoker.getKeyfieldName()));
                }
            } else {
                return ServiceResponse.buildFailure(session, "50008", "\u672a\u80fd\u8bc6\u522b\u66f4\u65b0\u8fd4\u56de\u7ed3\u679c");
            }
            return invoker.onQuery(session, paramsObject);
        }
        return response;
    }

    public ServiceResponse insertWithReturn(S invoker, T model) {
        ServiceResponse response = this.insert(invoker, model);
        return this.withReturn(response, invoker, ((BaseQueryModel)model).getPage_no(), ((BaseQueryModel)model).getPage_size());
    }

    public ServiceResponse delete(S invoker, T model) {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = this.getNormalParam(model);
        if (this.isForceKeyDelete() && (StringUtils.isEmpty((Object)(paramsObject = (JSONObject)TypeUtils.filter((JSON)paramsObject, new ValueFilter(){
            final /* synthetic */ BaseCompomentHandler val$invoker;
            {
                this.val$invoker = baseCompomentHandler;
            }

            public Object process(Object object, String name, Object value) {
                if (!name.equalsIgnoreCase(this.val$invoker.getCollectionName()) && !name.equalsIgnoreCase(this.val$invoker.getKeyfieldName())) {
                    return null;
                }
                if (value != null && value instanceof String && value.toString().isEmpty()) {
                    return null;
                }
                return value;
            }
        }))) || paramsObject.size() == 0)) {
            throw new ServiceRuntimeException(I18nUtil.getMessage("10024"));
        }
        log.info("delete:{}", (Object)paramsObject.toString());
        return invoker.onDelete(session, paramsObject);
    }

    public ServiceResponse query(S invoker, T model) {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = this.getQueryParam(model);
        log.info("query:{}", (Object)paramsObject.toString());
        return invoker.onQuery(session, paramsObject);
    }

    public ServiceResponse save(S invoker, T model) throws Exception {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = new JSONObject();
        if (model != null) {
            paramsObject = TypeUtils.toJSONObj(model, false, new SerializerFeature[0]);
        }
        log.info("save:{}", (Object)paramsObject.toString());
        return invoker.onSave(session, paramsObject);
    }

    public ServiceResponse save(S invoker, List<T> model) throws Exception {
        List<T> dataList = model;
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = new JSONObject();
        if (model == null) {
            paramsObject.put(this.getcollectionName(), new ArrayList());
        } else {
            JSONArray paramsList = (JSONArray)TypeUtils.toJSON(dataList, false, new SerializerFeature[0]);
            paramsObject.put(this.getcollectionName(), (Object)paramsList);
        }
        log.info("save:{}", (Object)paramsObject.toString());
        return invoker.onSave(session, paramsObject);
    }

    public ServiceResponse saveWithReturn(S invoker, List<T> model) throws Exception {
        ServiceResponse response = this.save(invoker, model);
        return this.withReturn(response, invoker, 0, 9999);
    }

    public ServiceResponse update(S invoker, T model) {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = this.getNormalParam(model);
        log.info("update:{}", (Object)paramsObject.toString());
        return invoker.onUpdate(session, paramsObject);
    }

    public ServiceResponse updateWithReturn(S invoker, T model) {
        ServiceResponse response = this.update(invoker, model);
        return this.withReturn(response, invoker, ((BaseQueryModel)model).getPage_no(), ((BaseQueryModel)model).getPage_size());
    }

    public ServiceResponse view(S invoker, T model) {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = this.getViewParam(model);
        log.info("view:{}", (Object)paramsObject.toString());
        ServiceResponse response = invoker.view(session, paramsObject);
        return response;
    }

    public T dataQueryFirst(S invoker, T model) {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = this.getViewParam(model);
        log.info("view:{}", (Object)paramsObject.toString());
        BaseQueryModel response = (BaseQueryModel)invoker.dataQueryFirst(session, paramsObject, this.getBeanClass());
        return (T)response;
    }

    public List<T> dataQuery(S invoker, T model) {
        ServiceSession session = SpringContext.getSession();
        JSONObject paramsObject = this.getViewParam(model);
        log.info("view:{}", (Object)paramsObject.toString());
        List response = invoker.dataQuery(session, paramsObject, this.getBeanClass());
        return response;
    }

    public Map<String, List<Map<String, Object>>> getDetailReports(T bean, String ... datasetNames) throws Exception {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        for (String datasetName : datasetNames) {
            List<Map<String, Object>> list = this.getDetailReport(bean, datasetName);
            map.put(datasetName, list);
        }
        return map;
    }

    public List<Map<String, Object>> getDetailReport(T bean, String datasetName) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!StringUtils.isEmpty(bean)) {
            if (datasetName.equalsIgnoreCase(this.getcollectionName())) {
                JSONObject map = TypeUtils.toJSONObj(bean, false, new SerializerFeature[0]);
                list.add((Map<String, Object>)map);
            } else {
                Class modelClass = this.getBeanClass();
                try {
                    Object items;
                    Field filed = AbstractEntityBean.fetchDeclaredField(modelClass, datasetName);
                    if (!StringUtils.isEmpty((Object)filed) && !StringUtils.isEmpty((Object)(items = AbstractEntityBean.getFieldValue(modelClass, bean, datasetName)))) {
                        if (items instanceof List) {
                            List itemList = (List)items;
                            for (int i = 0; i < itemList.size(); ++i) {
                                JSONObject map = TypeUtils.toJSONObj(itemList.get(i), false, new SerializerFeature[0]);
                                list.add((Map<String, Object>)map);
                            }
                        } else if (items instanceof Map) {
                            Map map = (Map)items;
                            list.add(map);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public List<Map<String, Object>> getDetailReport(S invoker, String datasetName, JSONObject parameters) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        BaseQueryModel bean = (BaseQueryModel)invoker.viewWithBean(parameters);
        if (!StringUtils.isEmpty((Object)bean)) {
            if (datasetName.equalsIgnoreCase(this.getcollectionName())) {
                JSONObject map = TypeUtils.toJSONObj(bean, false, new SerializerFeature[0]);
                list.add((Map<String, Object>)map);
            } else {
                Class modelClass = this.getBeanClass();
                try {
                    Object items;
                    Field filed = AbstractEntityBean.fetchDeclaredField(modelClass, datasetName);
                    if (!StringUtils.isEmpty((Object)filed) && !StringUtils.isEmpty((Object)(items = AbstractEntityBean.getFieldValue(modelClass, bean, datasetName)))) {
                        if (items instanceof List) {
                            List itemList = (List)items;
                            for (int i = 0; i < itemList.size(); ++i) {
                                JSONObject map = TypeUtils.toJSONObj(itemList.get(i), false, new SerializerFeature[0]);
                                list.add((Map<String, Object>)map);
                            }
                        } else if (items instanceof Map) {
                            Map map = (Map)items;
                            list.add(map);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public ServiceResponse generatePrintTemplate(JSONObject jsonParams) throws Exception {
        String proxy = StringUtils.isEmpty((Object)jsonParams.get((Object)"proxy")) ? "ampOpenapiService" : jsonParams.getString("proxy");
        String fileType = StringUtils.isEmpty((Object)jsonParams.get((Object)"fileType")) ? "mysql" : jsonParams.getString("fileType");
        String datasourceName = StringUtils.isEmpty((Object)jsonParams.get((Object)"datasourceName")) ? "datasourceName" : jsonParams.getString("datasourceName");
        String reportName = jsonParams.get((Object)"reportName").toString();
        String[] beans = ((AnnotationConfigServletWebServerApplicationContext)SpringContext.getContext()).getBeanNamesForType(this.getClass());
        ReportDefinition report = UReportUtils.generateDefaultReport(reportName, proxy, datasourceName, beans[0], this.getcollectionName(), this.getBeanClass());
        UReportUtils.savePrintTemplate(report, fileType);
        return ServiceResponse.buildSuccess("Success");
    }
}

