/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class MapTable<K, V> {
    private Map<K, List<V>> tableMap = new LinkedHashMap<K, List<V>>();
    private List<String> columnList = new ArrayList<String>();

    public MapTable(String ... columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            this.columnList.add(columnName);
        }
    }

    public void put(K key, V ... value) {
        List<V> dataList = Arrays.asList(value);
        this.tableMap.put(key, dataList);
    }

    public <T> T get(K key, String columnName) {
        if (StringUtils.isEmpty((Object)columnName)) {
            return null;
        }
        columnName = columnName.toLowerCase();
        for (int i = 0; i < this.columnList.size(); ++i) {
            String currentName = this.columnList.get(i);
            if (!columnName.equalsIgnoreCase(currentName)) continue;
            return this.get(key, i);
        }
        return null;
    }

    public <T> T get(K key, int index) {
        List<V> dataList = this.get(key);
        if (index >= 0 && index < dataList.size()) {
            return (T)dataList.get(index);
        }
        return null;
    }

    public List<V> get(K key) {
        List<V> dataList = this.tableMap.get(key);
        return dataList;
    }

    public int size() {
        return this.tableMap.size();
    }

    public Set<K> keySet() {
        return this.tableMap.keySet();
    }

    public boolean containsKey(K key) {
        return this.tableMap.containsKey(key);
    }
}

