/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.product.util.MapAs;
import com.shiji.core.annotation.KeepTransient;
import com.shiji.core.annotation.ModelProperty;
import com.shiji.core.annotation.RepositoryRestComponent;
import com.shiji.core.annotation.RestComponent;
import com.shiji.core.util.ReflectUtils;
import com.shiji.core.util.SpringInvoker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ArgumentParser {
    private static final Logger log = LoggerFactory.getLogger(ArgumentParser.class);
    @Autowired
    private SpringInvoker invoker;
    protected final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    private Map<String, Map<String, Object>> beanParse(Class<?> typeClass, String desc, String must) {
        LinkedHashMap<String, Map<String, Object>> linkedMap = new LinkedHashMap<String, Map<String, Object>>();
        try {
            Object data = typeClass.newInstance();
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(data);
            List<Field> fields = ReflectUtils.getAllFieldsFilterTransient(data.getClass());
            int i = 0;
            for (Field field : fields) {
                Map<String, Object> itemMap = MapAs.of("id", i++, "name", field.getName(), "type", field.getType(), "desc", desc, "must", must, "value", null);
                linkedMap.put(field.getName(), itemMap);
                if (!field.isAnnotationPresent(ModelProperty.class)) continue;
                ModelProperty modelProperty = field.getAnnotation(ModelProperty.class);
                if (!StringUtils.isEmpty((Object)modelProperty.value())) {
                    try {
                        beanWrapper.setPropertyValue(field.getName(), TypeUtils.cast((Object)modelProperty.value(), field.getType(), null));
                    }
                    catch (Exception e) {
                        log.error("\u7f3a\u7701\u503c\u9519\u8bef:{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                if (!StringUtils.isEmpty((Object)modelProperty.note())) {
                    itemMap.put("desc", modelProperty.note());
                }
                if (!modelProperty.required()) continue;
                itemMap.put("must", (modelProperty.required() ? "*\u5fc5\u987b" : ""));
            }
            JSONObject jsonValue = (JSONObject)JSON.toJSON(data);
            for (String keyName : jsonValue.keySet()) {
                Map itemMap = (Map)linkedMap.get(keyName);
                if (itemMap == null) continue;
                Object itemValue = jsonValue.get((Object)keyName);
                if (itemValue != null && itemValue instanceof Date) {
                    itemValue = this.formatter.format(itemValue);
                }
                itemMap.put("value", TypeUtils.castToString((Object)itemValue));
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return linkedMap;
    }

    private Map<String, Object> parameterParser(Parameter item, Type genericType) {
        ArrayList<Map<String, Object>> response;
        String name = item.getName();
        String type = item.getType().getName();
        String desc = "";
        String value = null;
        String must = "";
        Class actualTypeClazz = Object.class;
        try {
            ParameterizedType parameterizedType;
            Type[] typeList;
            if (genericType instanceof ParameterizedType && (typeList = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()) != null && typeList.length > 0) {
                actualTypeClazz = Class.forName(typeList[0].getTypeName());
            }
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Map<String, Object> paramsMap = MapAs.of("id", 1, "name", name, "type", type, "desc", desc, "must", must, "value", value);
        boolean isModelProperty = item.isAnnotationPresent(ModelProperty.class);
        if (isModelProperty) {
            ModelProperty modelProperty = item.getAnnotation(ModelProperty.class);
            desc = modelProperty.note();
            must = modelProperty.required() ? "*\u5fc5\u987b" : "";
            value = modelProperty.value();
            paramsMap.put("desc", desc);
            paramsMap.put("must", must);
            paramsMap.put("value", value);
        }
        if (item.getType().equals(String.class)) {
            response = value == null ? "" : value;
        } else if (item.getType().equals(Integer.class)) {
            response = value == null ? 1 : TypeUtils.castToInt(value);
        } else if (item.getType().equals(Long.class)) {
            response = value == null ? 1L : TypeUtils.castToLong((Object)value);
        } else if (item.getType().equals(Date.class)) {
            response = value == null ? TypeUtils.castToDate((Object)value) : new Date();
        } else if (item.getType().equals(JSONObject.class)) {
            response = value == null ? JSON.parseObject((String)value) : new JSONObject();
        } else if (item.getType().equals(JSONArray.class)) {
            response = value == null ? JSON.parseArray((String)value) : new JSONArray();
        } else if (item.getType().equals(List.class)) {
            paramsMap.put("name", String.format("%1$s[]", name));
            linkedMap = this.beanParse(actualTypeClazz, desc, must);
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
            dataList.addAll(linkedMap.values());
            response = dataList;
        } else if (item.getType().equals(Map.class)) {
            response = new HashMap();
        } else if (value == null) {
            linkedMap = this.beanParse(item.getType(), desc, must);
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
            dataList.addAll(linkedMap.values());
            response = dataList;
        } else {
            response = JSON.parseObject((String)value, item.getType());
        }
        paramsMap.put("value", response);
        return paramsMap;
    }

    public List<Map<String, Object>> parameterParser(Method method, JSONObject modelObject) throws Exception {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        Parameter[] parameters = method.getParameters();
        Type[] genericTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter item = parameters[i];
            Type genericType = genericTypes[i];
            Map<String, Object> paramsMap = this.parameterParser(item, genericType);
            response.add(paramsMap);
        }
        return response;
    }

    public List<Map<String, Object>> responseParser(RestComponent restComponent) throws Exception {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        Class<?>[] classzz = restComponent.responseModels();
        if (classzz.length > 0) {
            for (int i = 0; i < classzz.length; ++i) {
                Class<?> responseClass = classzz[i];
                List<Field> fields = ReflectUtils.getAllFieldsFilterTransient(responseClass);
                for (Field field : fields) {
                    HashMap<String, String> fieldMap = new HashMap<String, String>();
                    fieldMap.put("name", field.getName());
                    fieldMap.put("type", field.getType().getName());
                    fieldMap.put("desc", field.getName());
                    if (field.isAnnotationPresent(KeepTransient.class)) continue;
                    if (field.isAnnotationPresent(ModelProperty.class)) {
                        ModelProperty modelProperty = field.getAnnotation(ModelProperty.class);
                        fieldMap.put("desc", modelProperty.note());
                    }
                    response.add(fieldMap);
                }
            }
        }
        return response;
    }

    private String getPathKey(Object beanObj, Method method) {
        String response = String.format("%1$s/%2$s", beanObj.getClass().getSimpleName().toLowerCase(), method.getName());
        if (beanObj.getClass().isAnnotationPresent(RepositoryRestComponent.class)) {
            RestComponent restComponent;
            RepositoryRestComponent annotation = (RepositoryRestComponent)AnnotationUtils.findAnnotation(beanObj.getClass(), RepositoryRestComponent.class);
            String path = annotation.path();
            response = String.format("%1$s/%2$s", path, method.getName());
            boolean isRestComponent = method.isAnnotationPresent(RestComponent.class);
            if (isRestComponent && !StringUtils.isEmpty((Object)(restComponent = method.getAnnotation(RestComponent.class)).path())) {
                response = String.format("%1$s/%2$s", path, restComponent.path());
            }
        }
        return response;
    }

    public String methodParser(Object target, String methodName, List<Map<String, Object>> paramsList, List<Map<String, Object>> responseList, AtomicReference<RestComponent> dataRef) throws Exception {
        Method method = this.invoker.getMethod(target, methodName);
        AtomicReference<RestComponent> annotationRef = new AtomicReference<RestComponent>();
        JSONObject modelObject = new JSONObject();
        boolean isRestComponent = method.isAnnotationPresent(RestComponent.class);
        if (isRestComponent) {
            String modelValue;
            RestComponent restComponent = method.getAnnotation(RestComponent.class);
            annotationRef.set(restComponent);
            if (dataRef != null) {
                dataRef.set(restComponent);
            }
            if (!StringUtils.isEmpty((Object)(modelValue = restComponent.paramsSample()))) {
                modelObject = JSON.parseObject((String)modelValue);
            }
            responseList.addAll(this.responseParser(restComponent));
        }
        paramsList.addAll(this.parameterParser(method, modelObject));
        log.info("{}.{} \u8f93\u5165\u53c2\u6570\u4e3a:{} \u8f93\u51fa\u7ed3\u679c\u4e3a:{}", new Object[]{target.getClass().getSimpleName(), methodName, JSON.toJSONString(paramsList), JSON.toJSONString(responseList)});
        return this.getPathKey(target, method);
    }
}

