/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.shiji.core.service.ServiceQuery;
import com.shiji.core.util.ParserUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExtensionLoader
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private ApplicationContext context;
    private static final ConcurrentMap<String, List<Map<String, Object>>> EXTENSION_NAMELOADERS = new ConcurrentHashMap<String, List<Map<String, Object>>>();
    private static final ConcurrentMap<Class<?>, List<Map<String, Object>>> EXTENSION_CLASSLOADERS = new ConcurrentHashMap();
    private static final String SERVICES_CONFIG = "META-INF/spi/servicekeeper.factories";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Map<String, Object>> onExtensionLoader(String serviceName) {
        List<Map<String, Object>> loader = (List<Map<String, Object>>)EXTENSION_NAMELOADERS.get(serviceName);
        if (loader != null) return loader;
        Class<ExtensionLoader> clazz = ExtensionLoader.class;
        synchronized (ExtensionLoader.class) {
            loader = (List)EXTENSION_NAMELOADERS.get(serviceName);
            if (loader == null) {
                loader = this.loadExtensionClass(serviceName);
            }
            EXTENSION_NAMELOADERS.putIfAbsent(serviceName, loader);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Map<String, Object>> onExtensionLoader(Class<?> type) {
        List<Map<String, Object>> loader = (List<Map<String, Object>>)EXTENSION_CLASSLOADERS.get(type);
        if (loader != null) return loader;
        Class<ExtensionLoader> clazz = ExtensionLoader.class;
        synchronized (ExtensionLoader.class) {
            loader = (List)EXTENSION_CLASSLOADERS.get(type);
            if (loader == null) {
                loader = this.loadExtensionClass(type);
            }
            EXTENSION_CLASSLOADERS.putIfAbsent(type, loader);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loader;
        }
    }

    public ServiceQuery with(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type (" + String.valueOf(type) + ") is not an interface!");
        }
        final List<Map<String, Object>> loader = this.onExtensionLoader(type);
        ServiceQuery response = new ServiceQuery(){

            protected boolean equals(Map<String, Object> firstMap, Map<String, Object> lastMap, boolean isLoose) {
                HashMap<String, Object> compareMap = new HashMap<String, Object>();
                for (String string : firstMap.keySet()) {
                    if ("beanObject".equals(string)) continue;
                    compareMap.put(string, firstMap.get(string));
                }
                if (compareMap == lastMap) {
                    return true;
                }
                if (compareMap.isEmpty()) {
                    return false;
                }
                try {
                    for (Map.Entry entry : compareMap.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if ("beanObject".equals(key) || !(value == null ? !isLoose && (lastMap.get(key) != null || !lastMap.containsKey(key)) : !"*".equals(value) && !value.equals(lastMap.get(key)))) continue;
                        return false;
                    }
                }
                catch (ClassCastException unused) {
                    return false;
                }
                catch (NullPointerException unused) {
                    return false;
                }
                return true;
            }

            @Override
            public List<Map<String, Object>> query(Map<String, Object> paramsMap, boolean isLoose) {
                List<Map<String, Object>> dataList = loader.stream().filter(predicate -> this.equals((Map<String, Object>)predicate, paramsMap, isLoose)).collect(Collectors.toList());
                if (StringUtils.isEmpty(dataList) || dataList.size() == 0) {
                    dataList = new ArrayList();
                    Map<String, Object> map = this.queryDefault();
                    dataList.add(map);
                }
                return dataList;
            }

            public Map<String, Object> queryDefault() {
                return (Map)loader.stream().filter(e -> e.keySet().size() == 1 && e.containsKey("beanObject")).collect(Collectors.toList()).get(0);
            }

            @Override
            public <T> T queryFirst(Map<String, Object> paramsMap, boolean isLoose) {
                Optional optional = this.query(paramsMap, isLoose).stream().findFirst();
                if (optional.isPresent()) {
                    return (T)((Map)optional.get()).get("beanObject");
                }
                return null;
            }
        };
        return response;
    }

    public ServiceQuery with(String serviceName) {
        final List<Map<String, Object>> loader = this.onExtensionLoader(serviceName);
        ServiceQuery response = new ServiceQuery(){

            protected boolean equals(Map<String, Object> firstMap, Map<String, Object> lastMap, boolean isLoose) {
                if (firstMap == lastMap) {
                    return true;
                }
                if (firstMap.size() != lastMap.size() && !isLoose) {
                    return false;
                }
                try {
                    for (Map.Entry<String, Object> entry : firstMap.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if ("beanObject".equals(key) || !(value == null ? !isLoose && (lastMap.get(key) != null || !lastMap.containsKey(key)) : !"*".equals(value) && !value.equals(lastMap.get(key)))) continue;
                        return false;
                    }
                }
                catch (ClassCastException unused) {
                    return false;
                }
                catch (NullPointerException unused) {
                    return false;
                }
                return true;
            }

            @Override
            public List<Map<String, Object>> query(Map<String, Object> paramsMap, boolean isLoose) {
                List<Map<String, Object>> dataList = loader.stream().filter(predicate -> this.equals((Map<String, Object>)predicate, paramsMap, isLoose)).collect(Collectors.toList());
                return dataList;
            }

            @Override
            public <T> T queryFirst(Map<String, Object> paramsMap, boolean isLoose) {
                Optional optional = this.query(paramsMap, isLoose).stream().findFirst();
                if (optional.isPresent()) {
                    return (T)((Map)optional.get()).get("beanObject");
                }
                return null;
            }
        };
        return response;
    }

    private List<Map<String, Object>> loadExtensionClass(Object loader) {
        List<Map<String, Object>> extensionClasses = Collections.synchronizedList(new ArrayList());
        this.loadDirectory(extensionClasses, SERVICES_CONFIG, loader);
        return extensionClasses;
    }

    private void loadDirectory(List<Map<String, Object>> extensionClasses, String configFileName, Object loader) {
        try {
            ClassLoader classLoader = ExtensionLoader.findClassLoader();
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(configFileName) : ClassLoader.getSystemResources(configFileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL resourcesURL = urls.nextElement();
                    logger.info(JSON.toJSONString((Object)resourcesURL));
                    this.loadResources(extensionClasses, classLoader, resourcesURL, loader);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Exception occurred when loading extension class (description file: " + configFileName + ").", t);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadResources(List<Map<String, Object>> extensionClasses, ClassLoader classLoader, URL resourceURL, Object loader) {
        try {
            reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), StandardCharsets.UTF_8));
            ** try [egrp 1[TRYBLOCK] [1 : 23->387)] { 
lbl4:
            // 2 sources

            while (true) {
                ** GOTO lbl-1000
                break;
            }
lbl6:
            // 1 sources

            finally {
                reader.close();
            }
        }
        catch (Throwable t) {
            ExtensionLoader.logger.error("Exception occurred when loading extension class (class file: " + String.valueOf(resourceURL) + ") in " + String.valueOf(resourceURL), t);
        }
        return;
lbl-1000:
        // 3 sources

        {
            while ((line = reader.readLine()) != null) {
                ci = line.indexOf(35);
                if (ci >= 0) {
                    line = line.substring(0, ci);
                }
                if ((line = line.trim()).length() <= 0) continue;
                try {
                    config = JSON.parseObject((String)line);
                    iterator = config.entrySet().iterator();
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        if (!iterator.hasNext()) ** continue;
                        entry = (Map.Entry)iterator.next();
                        currentName = (String)entry.getKey();
                        if (loader instanceof String) {
                            serviceName = (String)loader;
                            if (!serviceName.equalsIgnoreCase(currentName)) ** continue;
                            dataList = (JSONArray)JSON.toJSON(entry.getValue());
                            i = 0;
                            while (true) {
                                if (i >= dataList.size()) ** continue;
                                itemConfig = dataList.getJSONObject(i);
                                if (itemConfig.containsKey((Object)"className")) {
                                    className = itemConfig.getString("className");
                                    this.loadClass(extensionClasses, resourceURL, Class.forName(className, true, classLoader), serviceName, itemConfig);
                                }
                                ++i;
                            }
                        }
                        type = (Class)loader;
                        dataList = (JSONArray)JSON.toJSON(entry.getValue());
                        i = 0;
                        while (true) {
                            if (i < dataList.size()) ** break;
                            ** continue;
                            itemConfig = dataList.getJSONObject(i);
                            if (itemConfig.containsKey((Object)"className") && !StringUtils.isEmpty((Object)(interfaceName = itemConfig.getString("interfaceName"))) && type.getName().equalsIgnoreCase(interfaceName)) {
                                className = itemConfig.getString("className");
                                this.loadClass(extensionClasses, resourceURL, Class.forName(className, true, classLoader), loader, itemConfig);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    var9_13 = new IllegalStateException("Failed to load extension class (class line: " + line + ") in " + String.valueOf(resourceURL) + ", cause: " + t.getMessage(), t);
                }
            }
            return;
        }
    }

    private static ClassLoader findClassLoader() {
        return DefaultListableBeanFactory.class.getClassLoader();
    }

    private void loadClass(List<Map<String, Object>> extensionClasses, URL resourceURL, Class<?> clazz, Object loader, JSONObject config) throws NoSuchMethodException {
        if (loader instanceof String && StringUtils.isEmpty((Object)((String)loader))) {
            throw new IllegalStateException("No such extension name for the class " + (String)loader + " in the config " + String.valueOf(resourceURL));
        }
        this.saveInExtensionClass(extensionClasses, clazz, loader, config);
    }

    private void saveInExtensionClass(List<Map<String, Object>> extensionClasses, Class<?> clazz, Object loader, JSONObject config) {
        Object bean = null;
        try {
            bean = this.context.getBean(clazz);
        }
        catch (Exception e) {
            logger.info("not found bean {} define", (Object)clazz.getName());
        }
        if (bean == null) {
            bean = this.parseClassToSpringBean(loader, clazz);
        }
        ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
        if (config.containsKey((Object)"identifyKey1") && config.containsKey((Object)"identifyValue1") && !StringUtils.isEmpty((Object)config.getString("identifyValue1"))) {
            dataMap.put(config.getString("identifyKey1"), config.getString("identifyValue1"));
        }
        if (config.containsKey((Object)"identifyKey2") && config.containsKey((Object)"identifyValue2") && !StringUtils.isEmpty((Object)config.getString("identifyValue2"))) {
            dataMap.put(config.getString("identifyKey2"), config.getString("identifyValue2"));
        }
        if (config.containsKey((Object)"identifyKey3") && config.containsKey((Object)"identifyValue3") && !StringUtils.isEmpty((Object)config.getString("identifyValue3"))) {
            dataMap.put(config.getString("identifyKey3"), config.getString("identifyValue3"));
        }
        if (config.containsKey((Object)"identifyKey4") && config.containsKey((Object)"identifyValue4") && !StringUtils.isEmpty((Object)config.getString("identifyValue4"))) {
            dataMap.put(config.getString("identifyKey4"), config.getString("identifyValue4"));
        }
        if (config.containsKey((Object)"identifyKey5") && config.containsKey((Object)"identifyValue5") && !StringUtils.isEmpty((Object)config.getString("identifyValue5"))) {
            dataMap.put(config.getString("identifyKey5"), config.getString("identifyValue5"));
        }
        dataMap.put("beanObject", bean);
        extensionClasses.add(dataMap);
    }

    private String getFullSimpleName(Class<?> obj) {
        String nameString = obj.getName();
        Iterator iterator = Splitter.on((String)".").split((CharSequence)nameString).iterator();
        ArrayList<String> dataList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (iterator.hasNext()) {
                dataList.add(name.substring(0, 1).toLowerCase());
                continue;
            }
            dataList.add(ParserUtils.lowerCaseFirst(name));
        }
        return Joiner.on((String)".").join(dataList);
    }

    private Object parseClassToSpringBean(Object loader, Class<?> obj) {
        logger.info("extension class SimpleName:{} TypeName:{} CanonicalName:{} name:{}", new Object[]{obj.getSimpleName(), obj.getTypeName(), obj.getCanonicalName(), obj.getName()});
        String beanName = null;
        beanName = loader instanceof String ? ParserUtils.lowerCaseFirst((String)loader) : this.getFullSimpleName(obj);
        boolean isUnique = true;
        if (this.context.containsBean(beanName) && this.context.containsBean(beanName = this.getFullSimpleName(obj))) {
            isUnique = false;
            for (int i = 0; i < 100; ++i) {
                String newName = String.format("%1$s%2$d", beanName, i);
                if (this.context.containsBean(newName)) continue;
                beanName = newName;
                isUnique = true;
            }
        }
        if (!isUnique) {
            throw new IllegalStateException("Duplicate extension name for the class " + beanName + " in the config " + obj.getName());
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(obj);
        GenericBeanDefinition definition = (GenericBeanDefinition)builder.getRawBeanDefinition();
        definition.setAutowireMode(1);
        this.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)definition);
        return this.context.getBean(beanName);
    }

    public BeanDefinitionRegistry getRegistry() {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.context;
        return (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

