/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.BorderStyle;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.HtmlReportAlign;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.PaperType;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.dataset.BeanDatasetDefinition;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.SpringBeanDatasourceDefinition;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import com.product.model.AbstractEntityBean;
import com.product.model.BaseQueryModel;
import com.product.util.SpringContext;
import com.shiji.core.ureport.component.ReportWirter;
import com.shiji.core.util.I18nUtil;
import com.shiji.core.util.ReflectUtils;
import com.shiji.core.util.SnowFlakeID;
import jakarta.xml.ws.Response;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class UReportUtils {
    private static final Logger log = LoggerFactory.getLogger(UReportUtils.class);

    public List<DatasetDefinition> generateDatasets(Map<String, Class<?>> beans) {
        ArrayList<DatasetDefinition> datasets = new ArrayList<DatasetDefinition>();
        for (String name : beans.keySet()) {
            BeanDatasetDefinition dataset = new BeanDatasetDefinition();
            dataset.setName(name);
            dataset.setMethod("queryreport");
            List<com.bstek.ureport.definition.dataset.Field> fields = UReportUtils.generateFiels(beans.get(name));
            dataset.setFields(fields);
            dataset.setClazz("");
            datasets.add((DatasetDefinition)dataset);
        }
        return datasets;
    }

    public static List<DatasetDefinition> generateDatasets(String tablename, Class<?> clazz) {
        Map<String, Class<?>> beans = UReportUtils.getAllClass(tablename, clazz);
        ArrayList<DatasetDefinition> datasets = new ArrayList<DatasetDefinition>();
        for (String name : beans.keySet()) {
            BeanDatasetDefinition dataset = new BeanDatasetDefinition();
            dataset.setName(name);
            dataset.setMethod("queryreport");
            List<com.bstek.ureport.definition.dataset.Field> fields = UReportUtils.generateFiels(beans.get(name));
            dataset.setFields(fields);
            dataset.setClazz(beans.get(name).getTypeName());
            datasets.add((DatasetDefinition)dataset);
        }
        return datasets;
    }

    public static List<DatasourceDefinition> generateDatasourceDefinitions(String proxy, String datasourceName, String beanId, String tableName, Class<?> clazz) {
        ArrayList<DatasourceDefinition> datasources = new ArrayList<DatasourceDefinition>();
        List<DatasetDefinition> datasets = UReportUtils.generateDatasets(tableName, clazz);
        SpringBeanDatasourceDefinition dataSource = new SpringBeanDatasourceDefinition();
        SnowFlakeID flakeID = new SnowFlakeID(2L, 3L);
        dataSource.setId(String.valueOf(flakeID.nextId()));
        dataSource.setName(datasourceName);
        dataSource.setBeanId(beanId);
        dataSource.setDatasets(datasets);
        dataSource.setProxy(proxy);
        datasources.add((DatasourceDefinition)dataSource);
        return datasources;
    }

    public static List<CellDefinition> generateDefaultCells(CellStyle cellStyle) {
        ArrayList<CellDefinition> cells = new ArrayList<CellDefinition>();
        CellDefinition cell1 = new CellDefinition();
        cell1.setName("A1");
        cell1.setRowNumber(1);
        cell1.setColumnNumber(1);
        cell1.setValue((Value)new SimpleValue(""));
        cell1.setCellStyle(cellStyle);
        cells.add(cell1);
        CellDefinition cell2 = new CellDefinition();
        cell2.setName("B1");
        cell2.setRowNumber(1);
        cell2.setColumnNumber(2);
        cell2.setValue((Value)new SimpleValue(""));
        cell2.setCellStyle(cellStyle);
        cells.add(cell2);
        CellDefinition cell3 = new CellDefinition();
        cell3.setName("C1");
        cell3.setRowNumber(1);
        cell3.setColumnNumber(3);
        cell3.setValue((Value)new SimpleValue(""));
        cell3.setCellStyle(cellStyle);
        cells.add(cell3);
        CellDefinition cell4 = new CellDefinition();
        cell4.setName("D1");
        cell4.setRowNumber(1);
        cell4.setColumnNumber(4);
        cell4.setValue((Value)new SimpleValue(""));
        cell4.setCellStyle(cellStyle);
        cells.add(cell4);
        CellDefinition cell5 = new CellDefinition();
        cell5.setName("A2");
        cell5.setRowNumber(2);
        cell5.setColumnNumber(1);
        cell5.setValue((Value)new SimpleValue(""));
        cell5.setCellStyle(cellStyle);
        cells.add(cell5);
        CellDefinition cell6 = new CellDefinition();
        cell6.setName("B2");
        cell6.setRowNumber(2);
        cell6.setColumnNumber(2);
        cell6.setValue((Value)new SimpleValue(""));
        cell6.setCellStyle(cellStyle);
        cells.add(cell6);
        CellDefinition cell7 = new CellDefinition();
        cell7.setName("C2");
        cell7.setRowNumber(2);
        cell7.setColumnNumber(3);
        cell7.setValue((Value)new SimpleValue(""));
        cell7.setCellStyle(cellStyle);
        cells.add(cell7);
        CellDefinition cell8 = new CellDefinition();
        cell8.setName("D2");
        cell8.setRowNumber(2);
        cell8.setColumnNumber(4);
        cell8.setValue((Value)new SimpleValue(""));
        cell8.setCellStyle(cellStyle);
        cells.add(cell8);
        CellDefinition cell9 = new CellDefinition();
        cell9.setName("A3");
        cell9.setRowNumber(3);
        cell9.setColumnNumber(1);
        cell9.setValue((Value)new SimpleValue(""));
        cell9.setCellStyle(cellStyle);
        cells.add(cell9);
        CellDefinition cell10 = new CellDefinition();
        cell10.setName("B3");
        cell10.setRowNumber(3);
        cell10.setColumnNumber(2);
        cell10.setValue((Value)new SimpleValue(""));
        cell10.setCellStyle(cellStyle);
        cells.add(cell10);
        CellDefinition cell11 = new CellDefinition();
        cell11.setName("C3");
        cell11.setRowNumber(3);
        cell11.setColumnNumber(3);
        cell11.setValue((Value)new SimpleValue(""));
        cell11.setCellStyle(cellStyle);
        cells.add(cell11);
        CellDefinition cell12 = new CellDefinition();
        cell12.setName("D3");
        cell12.setRowNumber(3);
        cell12.setColumnNumber(4);
        cell12.setValue((Value)new SimpleValue(""));
        cell12.setCellStyle(cellStyle);
        cells.add(cell12);
        return cells;
    }

    public static CellStyle generateCellStyle() {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFontSize(10);
        cellStyle.setBgcolor("255,255,255");
        cellStyle.setAlign(Alignment.center);
        cellStyle.setValign(Alignment.middle);
        Border border = new Border();
        border.setWidth(1);
        border.setStyle(BorderStyle.solid);
        border.setColor("0,0,0");
        cellStyle.setLeftBorder(border);
        cellStyle.setRightBorder(border);
        cellStyle.setTopBorder(border);
        cellStyle.setBottomBorder(border);
        return cellStyle;
    }

    public static List<RowDefinition> generateDefaultRows() {
        ArrayList<RowDefinition> rows = new ArrayList<RowDefinition>();
        RowDefinition row1 = new RowDefinition();
        row1.setRowNumber(1);
        row1.setHeight(18);
        rows.add(row1);
        RowDefinition row2 = new RowDefinition();
        row2.setRowNumber(2);
        row2.setHeight(18);
        rows.add(row2);
        RowDefinition row3 = new RowDefinition();
        row3.setRowNumber(3);
        row3.setHeight(18);
        rows.add(row3);
        return rows;
    }

    public static List<ColumnDefinition> generateDefaultColumns() {
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        ColumnDefinition column1 = new ColumnDefinition();
        column1.setColumnNumber(1);
        column1.setWidth(80);
        columns.add(column1);
        ColumnDefinition column2 = new ColumnDefinition();
        column2.setColumnNumber(2);
        column2.setWidth(80);
        columns.add(column2);
        ColumnDefinition column3 = new ColumnDefinition();
        column3.setColumnNumber(3);
        column3.setWidth(80);
        columns.add(column3);
        ColumnDefinition column4 = new ColumnDefinition();
        column4.setColumnNumber(4);
        column4.setWidth(80);
        columns.add(column4);
        return columns;
    }

    public static Paper generateDefaultPaper() {
        Paper paper = new Paper();
        paper.setPaperType(PaperType.A3);
        paper.setLeftMargin(90);
        paper.setRightMargin(90);
        paper.setTopMargin(72);
        paper.setBottomMargin(72);
        paper.setPagingMode(PagingMode.fitpage);
        paper.setWidth(842);
        paper.setHeight(1191);
        paper.setOrientation(Orientation.landscape);
        paper.setHtmlReportAlign(HtmlReportAlign.left);
        paper.setBgImage("");
        paper.setHtmlIntervalRefreshValue(0);
        paper.setColumnEnabled(false);
        return paper;
    }

    public static String getDatasetName(String name) {
        int i = name.length();
        while (--i >= 0) {
            char chr = name.charAt(i);
            if (chr < '0' || chr > '9') continue;
            name = name.substring(0, i);
            break;
        }
        return name;
    }

    public static Map<String, Class<?>> getAllClass(String tablename, Class<?> clazz) {
        HashMap map = new HashMap();
        map.put(tablename, clazz);
        try {
            Map<String, Class<?>> slaveClazzs = UReportUtils.getSlaveClazzs(clazz);
            if (!StringUtils.isEmpty(slaveClazzs)) {
                map.putAll(slaveClazzs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static List<com.bstek.ureport.definition.dataset.Field> generateFiels(Class<?> clazz) {
        ArrayList<com.bstek.ureport.definition.dataset.Field> fields = new ArrayList<com.bstek.ureport.definition.dataset.Field>();
        StringBuffer sb = new StringBuffer();
        List<Field> beanFields = ReflectUtils.getAllFieldsFilterTransient(clazz);
        for (Field field : beanFields) {
            fields.add(new com.bstek.ureport.definition.dataset.Field(field.getName()));
        }
        return fields;
    }

    protected static Map<String, Class<?>> getSlaveClazzs(Class<?> masterClazz) throws Exception {
        HashMap map = new HashMap();
        List<Field> fields = ReflectUtils.getAllFields(masterClazz);
        for (Field field : fields) {
            String[] slavekey;
            Field fld;
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType) && !BaseQueryModel.class.isAssignableFrom((Class)type)) continue;
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                type = parameterizedType.getActualTypeArguments()[0];
            }
            if ((fld = UReportUtils.getMasterSlaveField((Class)type)) == null || StringUtils.isEmpty((Object)(slavekey = (String[])fld.get(null)))) continue;
            String datasetName = UReportUtils.getDatasetName(field.getName());
            map.put(datasetName, (Class)type);
        }
        return map;
    }

    protected static Field getMasterSlaveField(Class<?> cl) {
        return AbstractEntityBean.fetchDeclaredField(cl, "MASTER_SLAVE_KEY");
    }

    public static ReportDefinition generateDefaultReport(String reportName, String proxy, String datasourceName, String beanName, String tableName, Class<?> clazz) {
        ReportDefinition report = new ReportDefinition();
        List<DatasourceDefinition> datasources = UReportUtils.generateDatasourceDefinitions(proxy, datasourceName, beanName, tableName, clazz);
        report.setDatasources(datasources);
        CellStyle cellStyle = UReportUtils.generateCellStyle();
        List<CellDefinition> cells = UReportUtils.generateDefaultCells(cellStyle);
        List<RowDefinition> rows = UReportUtils.generateDefaultRows();
        List<ColumnDefinition> columns = UReportUtils.generateDefaultColumns();
        Paper paper = UReportUtils.generateDefaultPaper();
        report.setCells(cells);
        report.setRows(rows);
        report.setColumns(columns);
        report.setPaper(paper);
        report.setReportFullName(reportName);
        return report;
    }

    public static String getReportContent(ReportDefinition report) {
        ReportWirter wirter = new ReportWirter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wirter.writerXML(report, baos);
        byte[] btBuffer = baos.toByteArray();
        String content = "";
        try {
            content = new String(btBuffer, "utf-8");
            log.info(content);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return content;
    }

    public static void savePrintTemplate(ReportDefinition report, String fileType) {
        String content = UReportUtils.getReportContent(report);
        String file = String.format("%1$s:%2$s.ureport.xml", fileType, report.getReportFullName());
        String saveUreportUrl = "http://amp-ureport/ureport/designer/saveReportFile";
        RestTemplate restTemplate = (RestTemplate)SpringContext.getContext().getBean(RestTemplate.class);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.valueOf((String)"application/x-www-form-urlencoded"));
        LinkedMultiValueMap requestMap = new LinkedMultiValueMap();
        requestMap.add((Object)"content", (Object)content);
        requestMap.add((Object)"file", (Object)file);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)saveUreportUrl);
        URI uri = uriComponentsBuilder.build().encode(StandardCharsets.UTF_8).toUri();
        RequestEntity requestEntity = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).headers(httpHeaders)).body((Object)requestMap);
        try {
            ResponseEntity responseEntity = restTemplate.exchange(requestEntity, Response.class);
            if (!responseEntity.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new RuntimeException(I18nUtil.getMessage("93001", new Object[]{file, responseEntity.getBody()}));
            }
        }
        catch (RestClientException e) {
            log.error("[RestTemplateTest-test] http request error", (Throwable)e);
            throw new RuntimeException(I18nUtil.getMessage("93001", new Object[]{file, e.getMessage()}));
        }
    }
}

