<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"/>
    <title>API在线调用</title>
    #if($prefixurl)
    <!-- -->
    <link href="${prefixurl}/static/css/style.css" rel="stylesheet">
    <!-- 控制视区 -->
    <link href="${prefixurl}/static/css/app.css" rel="stylesheet">

    <!-- 表格折叠 -->
    <link href="${prefixurl}/static/css/table-coalesce.css" rel="stylesheet">
    <!-- TabPage 控件CSS -->
    <link href="${prefixurl}/static/css/tabpage.css" rel="stylesheet">

    <script src="${prefixurl}/static/js/jquery-2.1.4.js" type="text/javascript"></script>
    <!-- 表格折叠 -->
    <script src="${prefixurl}/static/js/table-coalesce.js" type="text/javascript"></script>
    #else
    <!-- -->
    <link href="/static/css/style.css" rel="stylesheet">
    <!-- 控制视区 -->
    <link href="/static/css/app.css" rel="stylesheet">

    <!-- 表格折叠 -->
    <link href="/static/css/table-coalesce.css" rel="stylesheet">
    <!-- TabPage 控件CSS -->
    <link href="/static/css/tabpage.css" rel="stylesheet">

    <script src="/static/js/jquery-2.1.4.js" type="text/javascript"></script>
    <!-- 表格折叠 -->
    <script src="/static/js/table-coalesce.js" type="text/javascript"></script>
    #end
    <style>
        #card li {
            height: auto;
            line-height: unset;
        }
    </style>

    <script type="text/javascript">
        $(function () {
            // 界面加载给table这个class下的所有input增加监听事件
                $(".table input").each(function () {
                    $(this).bind("input propertychange", function () {
                        getParam();
                    });
                });
                
                // 在线调用按钮监听事件
                $(".submit").click(function () {
                    var methodURL = $('#requestURL').val();
                    console.log("requestURL:", methodURL);
                    
                    var queryParam = $('.input').val();
                    console.log("queryParam:", queryParam);
                    
                    $.ajax({
                        url: methodURL,
                        type: 'post',
                        dataType: 'json',
                        data: queryParam,
                        contentType: 'application/json',
                        success: function (data) {
                            console.log("response:", JSON.stringify(data));
                            $('.output').val(JSON.stringify(data));
                            setTableList(data);
                        },
                    });
               }); 
               
                // 生成报表按钮监听事件
                $(".generate").click(function () {
                	    window.open('${reportURL!'about:blank'}');
               }); 

               // tabPage
                $('#option li').click(function () {
                    $(this).addClass('active').siblings().removeClass('active');
                    var a = $(this).index();
                    $('#card li:eq(' + a + ')').addClass('active').siblings().removeClass('active');
                });
    
                $('.test').click(function () {
                    setTableList();
                })
            });
            
        let cloneTr = null;

        // tabPage
        function setTableList(data) {

            // 模拟数据
            // let data = {
            //     "data": {
            //         "total_results": 1, "user": [
            //             { "departmentid": "utf-8", "departmentcode": "1234567890000000", "departmentname": "0", "entid": 0, "entname": "产品中心0", "ivparameter": "1234567890000000" },
            //             { "departmentid": "utf-9", "departmentcode": "2222", "departmentname": "0222", "entid": 0, "entname": "产品中心0", "ivparameter": "1234567890000000" }
            //         ]
            //     }, "returncode": "0"
            // }

            let key = $("#datalist").attr("key");
            if (!cloneTr) {
                cloneTr = $("#datalist tbody tr").eq(0).clone();
            }
            $("#datalist tbody").empty();
            // 数据遍历
            for (let i = 0, len = data.data[key].length; i < len; i++) {
                const cell = data.data[key][i];
                let bc = cloneTr.clone();
                bc.children().each(function () {
                    let name = $(this).attr('name');
                    $(this).html(cell[name]);
                });
                bc.appendTo("#datalist");
            }
        };            

        // 获取请求参数方法
        function getParam() {
            let param = {};
            $(".table input").each(function () {
                let trClass = $(this).parent().parent().attr('class').split('_');
                let keyID = trClass[1];
                // 分支处理
                let isArray = keyID.indexOf("[]");
                if (isArray > 0) {
                    let aKeyID = keyID.substring(0, isArray);
                    if (!param[aKeyID]) {
                        param[aKeyID] = [{}];
                    }

                    // 如果没有值，则不生成
                    let key = $(this).attr('name');
                    let value = $(this).val();
                    if (value.trim() !== '') {
                        param[aKeyID][0][key] = value;
                    }
                } else {
                    if (keyID != 'all') {
                        if (!param[keyID]) {
                            param[keyID] = {};
                        }
                    }
                    let key = $(this).attr('name');
                    let value = $(this).val();
                    // 如果没有值，则不生成
                    if (value.trim() !== '') {
                        if (keyID == 'all') {
                            param[key] = value;
                        } else {
                            param[keyID][key] = value;
                        }
                    }
                }
            });
            $('.input').val(JSON.stringify(param));
        }
        
        // 获取请求参数方法
        function getParam202100527Before() {
            let param = {};
            $(".table input").each(function () {
                let trClass = $(this).parent().parent().attr('class').split('_');
                let keyID = trClass[1];
                if (keyID !='all') {
	                if (!param[keyID]) {
	                    param[keyID] = {};
	                }
	            }
                let key = $(this).attr('name');
                let value = $(this).val();
                // 如果没有值，则不生成
                if (value.trim() !== '') {
                   if (keyID =='all') {
                   	 param[key] = value;
                   } else {
                   	 param[keyID][key] = value;
                   }
                }
            });
            $('.input').val(JSON.stringify(param));
        }
        // 老的获取请求参数方法
        function oldGetParam() {
            let param = {};
            $(".table input").each(function () {
                let key = $(this).attr('name');
                let value = $(this).val();
                param[key] = value
            });
            $('.input').val(JSON.stringify(param));
        }
        </script>
    </head>
    <body>
   <div class="card">
      <div class="card-block">
        <div>
            <p><span class="sql">API在线调用 ${componentName}.${methodName}</span>  API说明:${methodDesc}</p>
            <table style="border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;">
                <tr>
                   <td  style="width:80px;border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;"><span style="width: 60px; height:24px;color: red;float:left; text-align:right;" class="sql">请求地址:</span></td>
                   <td  style="width:100%;border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;"><input style="width: 100%;height:24px;display: inline-block" type="text" id="requestURL" value="${methodURL!''}" /></td>
                </tr>
            </table>
            
        <!-- list循环 -->
        <#if paramsList?exists>
        <table class="table">
            <tbody>
                <tr>
                    <th style="width:200px">参数序号</th>
                    <th>参数名称</th>
                    <th>参数类型</th>
                    <th>参数需求</th>
                    <th>参数描述</th>
                    <th>参数数值</th>
                </tr>
                <#list paramsList as model>
                <tr class="parent" id="${model.itemname!''}">
                    <td>${model.itemname!''}</td>
                    <td colspan="5">${model.itemdesc!''}</td>
                </tr>
                <#list model.itemList as item>
                <tr class="child_${model.itemname!''}">
                   <td>${item.id!''}</td>
                   <td>${item.name!''}</td>
                   <td>${item.type!''}</td>
                   <td>${item.must!''}</td>
                   <td>${item.desc!''}</td>
                   <td><input type="text" name="${item.name!''}" value="${item.value!''}" /></td>
                </tr>
                </#list>
                </#list>
            </tbody>
        </table>
        <div>
        <textarea class="input"  rows="3" cols="20" style="width:100%;height:300px;padding:0px;">${simple}</textarea>
        </div>
        <button class="submit" type="button">在线调用</button>
        <button class="save" type="button">保存参数</button>
        <button class="generate" type="button"  <#if isReport == false>style="display:none"</#if>>生成报表</button>
        <button class="test" type="button">临时测试</button>
        </#if>
        
        <ul id="option" style="margin-bottom: 0;margin-top:5px;">
            <li class="active">API输出JSON结果</li>
            <li>API输出集合结果</li>
        </ul>
        <ul id="card">
            <li class="active">
                <textarea class="output" rows="3" cols="20" style="width:100%;height:300px;padding:10px;border:none;">暂无结果</textarea>
            </li>
            <li class="">
                <!-- list循环 -->
                <#if resultList?exists>
                <table id="datalist" key="${collectionName!'xxx'}" class="table">
                    <thead>
                        <tr>
                            <#list resultList as model>
                            <th name="${model.name!''}">${model.desc!''}</th>
                            </#list>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="each">
                            <#list resultList as model>
                            <td name="${model.name!''}">${model.type!''}</td>
                            </#list>
                        </tr>
                    </tbody>
                </table>
                </#if>
            </li>
        </ul>
        </div>
      </div>
   </div>
   <script type="text/javascript">
      // 重构参数
      getParam()
   </script>
    </body>
</html>