/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.searchform;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.searchform.Component;
import com.bstek.ureport.definition.searchform.InputComponent;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.RenderContext;
import com.bstek.ureport.definition.searchform.VueThreadLocal;
import com.bstek.ureport.exception.DatasetUndefinitionException;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class VueISelectComponent
extends InputComponent {
    private boolean useDataset;
    private String dataset;
    private String labelField;
    private String valueField;
    private List<Option> options;

    String inputHtml(RenderContext context) {
        String name = this.getBindParameter();
        ArrayList<Object> dataList = new ArrayList<Object>();
        dataList.add("<i-select v-model=\"" + name + "\" id='" + context.buildComponentId((Component)this) + "' name='" + this.getBindParameter() + "' multiple style=\"width: 100%\" @on-change=\"handleListSelectChange\">");
        if (this.useDataset && StringUtils.isNotBlank((CharSequence)this.dataset)) {
            System.out.println("\u6784\u5efadataset\u6570\u636e");
            Dataset ds = context.getDataset(this.dataset);
            if (ds == null) {
                throw new DatasetUndefinitionException(this.dataset);
            }
            for (Object obj : ds.getData()) {
                Object label = Utils.getProperty(obj, (String)this.labelField);
                Object value = Utils.getProperty(obj, (String)this.valueField);
                dataList.add("<i-option value='" + value + "' >" + label + "</i-option>");
            }
        } else {
            System.out.println("\u6784\u5efaoptions\u6570\u636e");
            for (Option option : this.options) {
                String value = option.getValue();
                dataList.add("<i-option value='" + value + "' >" + option.getLabel() + "</i-option>");
            }
        }
        dataList.add("</i-select>");
        System.out.println(String.format("\u589e\u52a0\u53d8\u91cf:%1$s", name));
        VueThreadLocal.addVueVariable(name);
        return Joiner.on((String)"\n").join(dataList);
    }

    public String initJs(RenderContext context) {
        String name = this.getBindParameter();
        StringBuilder sb = new StringBuilder();
        sb.append("formElements.push(");
        sb.append("   function(){");
        sb.append("       if(''==='" + name + "'){");
        sb.append("          alert('\u6587\u672c\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!');");
        sb.append("          throw '\u6587\u672c\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!'");
        sb.append("        }");
        sb.append("        var response = data." + name + ".join(',');");
        sb.append("        return {\"" + name + "\":response}");
        sb.append("   }");
        sb.append(");");
        return sb.toString();
    }

    public boolean isUseDataset() {
        return this.useDataset;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setUseDataset(boolean useDataset) {
        this.useDataset = useDataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VueISelectComponent)) {
            return false;
        }
        VueISelectComponent other = (VueISelectComponent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUseDataset() != other.isUseDataset()) {
            return false;
        }
        String this$dataset = this.getDataset();
        String other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        String this$labelField = this.getLabelField();
        String other$labelField = other.getLabelField();
        if (this$labelField == null ? other$labelField != null : !this$labelField.equals(other$labelField)) {
            return false;
        }
        String this$valueField = this.getValueField();
        String other$valueField = other.getValueField();
        if (this$valueField == null ? other$valueField != null : !this$valueField.equals(other$valueField)) {
            return false;
        }
        List<Option> this$options = this.getOptions();
        List<Option> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VueISelectComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseDataset() ? 79 : 97);
        String $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        String $labelField = this.getLabelField();
        result = result * 59 + ($labelField == null ? 43 : $labelField.hashCode());
        String $valueField = this.getValueField();
        result = result * 59 + ($valueField == null ? 43 : $valueField.hashCode());
        List<Option> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "VueISelectComponent(useDataset=" + this.isUseDataset() + ", dataset=" + this.getDataset() + ", labelField=" + this.getLabelField() + ", valueField=" + this.getValueField() + ", options=" + this.getOptions() + ")";
    }
}

