/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.searchform;

import com.bstek.ureport.definition.searchform.LabelPosition;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.VueTreeSelectComponent;
import com.bstek.ureport.parser.impl.searchform.FormParser;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

@Component(value="ureport.restVueTreeSelectParser")
public class VueTreeSelectParser
implements FormParser<VueTreeSelectComponent> {
    public VueTreeSelectComponent parse(Element element) {
        VueTreeSelectComponent treeSelect = new VueTreeSelectComponent();
        treeSelect.setBindParameter(element.attributeValue("bind-parameter"));
        treeSelect.setLabel(element.attributeValue("label"));
        treeSelect.setType(element.attributeValue("type"));
        treeSelect.setLabelPosition(LabelPosition.valueOf((String)element.attributeValue("label-position")));
        String useDataset = element.attributeValue("use-dataset");
        if (StringUtils.isNotBlank((CharSequence)useDataset)) {
            treeSelect.setUseDataset(Boolean.valueOf(useDataset));
            treeSelect.setDataset(element.attributeValue("dataset"));
            treeSelect.setLabelField(element.attributeValue("label-field"));
            String valueField = element.attributeValue("value-field");
            if (!StringUtils.isEmpty((CharSequence)valueField)) {
                List dataList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)valueField);
                if (dataList.size() > 1) {
                    treeSelect.setCodeField((String)dataList.get(0));
                    treeSelect.setParentField((String)dataList.get(1));
                } else if (dataList.size() > 0) {
                    treeSelect.setCodeField((String)dataList.get(0));
                    treeSelect.setParentField((String)dataList.get(0));
                } else {
                    treeSelect.setCodeField(valueField);
                    treeSelect.setParentField(valueField);
                }
            } else {
                treeSelect.setCodeField(valueField);
                treeSelect.setParentField(valueField);
            }
        }
        ArrayList<Option> options = new ArrayList<Option>();
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("option")) continue;
            Option option = new Option();
            options.add(option);
            option.setLabel(ele.attributeValue("label"));
            option.setValue(ele.attributeValue("value"));
        }
        treeSelect.setOptions(options);
        return treeSelect;
    }

    public boolean support(String name) {
        return name.equals("tree-select");
    }
}

