/*
 * Decompiled with CFR 0.152.
 */
package com.product.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(DynamicRoutingDataSource.class);

    public String getJdbcUrl() {
        DataSource dataSource = this.determineTargetDataSource();
        if (dataSource instanceof HikariDataSource) {
            HikariDataSource ds = (HikariDataSource)dataSource;
            return ds.getJdbcUrl();
        }
        if (dataSource instanceof DruidDataSource) {
            DruidDataSource ds = (DruidDataSource)dataSource;
            return ds.getUrl();
        }
        return "";
    }

    protected Object determineCurrentLookupKey() {
        String dataSourceName = DynamicDataSourceContextHolder.getRouterKey();
        log.info("\u5f53\u524d\u6570\u636e\u6e90\u662f\uff1a{}", (Object)dataSourceName);
        return DynamicDataSourceContextHolder.getRouterKey();
    }

    public Connection getConnection() throws SQLException {
        String dataSourceName = DynamicDataSourceContextHolder.getRouterKey();
        log.info("\u5f53\u524d\u6570\u636e\u6e90\u662f\uff1a{} getConnection() jdbcURL:{}", (Object)dataSourceName, (Object)this.getJdbcUrl());
        return super.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        String dataSourceName = DynamicDataSourceContextHolder.getRouterKey();
        log.info("\u5f53\u524d\u6570\u636e\u6e90\u662f\uff1a{} getConnection({},{})  jdbcURL:{}", new Object[]{username, password, dataSourceName, this.getJdbcUrl()});
        return super.getConnection(username, password);
    }
}

