/*
 * Decompiled with CFR 0.152.
 */
package com.product.fastjson.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.MapDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class EmptyJSONParser
extends DefaultJSONParser {
    public EmptyJSONParser(String input, ParserConfig config) {
        super(input, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Object fieldName) {
        JSONLexer lexer = this.lexer;
        switch (lexer.token()) {
            case 21: {
                lexer.nextToken();
                HashSet set = new HashSet();
                this.parseArray(set, fieldName);
                return set;
            }
            case 22: {
                lexer.nextToken();
                TreeSet treeSet = new TreeSet();
                this.parseArray(treeSet, fieldName);
                return treeSet;
            }
            case 14: {
                JSONArray array = new JSONArray();
                this.parseArray((Collection)array, fieldName);
                if (lexer.isEnabled(Feature.UseObjectArray)) {
                    return array.toArray();
                }
                return array;
            }
            case 12: {
                JSONObject object = new JSONObject(lexer.isEnabled(Feature.OrderedField));
                return this.parseObjectEx((Map)object, fieldName);
            }
            case 2: {
                Number intValue = lexer.integerValue();
                lexer.nextToken();
                return intValue;
            }
            case 3: {
                Number value = lexer.decimalValue(lexer.isEnabled(Feature.UseBigDecimal));
                lexer.nextToken();
                return value;
            }
            case 4: {
                String stringLiteral = lexer.stringVal();
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                    try (JSONScanner iso8601Lexer = new JSONScanner(stringLiteral);){
                        if (iso8601Lexer.scanISO8601DateIfMatch()) {
                            Date date = iso8601Lexer.getCalendar().getTime();
                            return date;
                        }
                    }
                }
                return stringLiteral;
            }
            case 8: {
                lexer.nextToken();
                return null;
            }
            case 23: {
                lexer.nextToken();
                return null;
            }
            case 6: {
                lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                lexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                lexer.nextToken(18);
                if (lexer.token() != 18) {
                    throw new JSONException("syntax error");
                }
                lexer.nextToken(10);
                this.accept(10);
                long time = lexer.integerValue().longValue();
                this.accept(2);
                this.accept(11);
                return new Date(time);
            }
            case 20: {
                if (lexer.isBlankInput()) {
                    return null;
                }
                throw new JSONException("unterminated json string, " + lexer.info());
            }
            case 26: {
                byte[] bytes = lexer.bytesValue();
                lexer.nextToken();
                return bytes;
            }
            case 18: {
                String identifier = lexer.stringVal();
                if ("NaN".equals(identifier)) {
                    lexer.nextToken();
                    return null;
                }
                throw new JSONException("syntax error, " + lexer.info());
            }
        }
        throw new JSONException("syntax error, " + lexer.info());
    }

    private int incObjectKeyLevel() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field keyLevel = super.getClass().getField("objectKeyLevel");
        keyLevel.setAccessible(true);
        int target = (Integer)keyLevel.get((Object)this);
        keyLevel.set((Object)this, ++target);
        return target;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object parseObjectEx(Map object, Object fieldName) {
        block108: {
            block109: {
                lexer = this.lexer;
                if (lexer.token() == 8) {
                    lexer.nextToken();
                    return null;
                }
                if (lexer.token() == 13) {
                    lexer.nextToken();
                    return object;
                }
                if (lexer.token() == 4 && lexer.stringVal().length() == 0) {
                    lexer.nextToken();
                    return object;
                }
                if (lexer.token() != 12 && lexer.token() != 16) {
                    throw new JSONException("syntax error, expect {, actual " + lexer.tokenName() + ", " + lexer.info());
                }
                context /* !! */  = this.context;
                isJsonObjectMap = object instanceof JSONObject;
                map = isJsonObjectMap != false ? ((JSONObject)object).getInnerMap() : object;
                setContextFlag = false;
lbl18:
                // 2 sources

                while (true) {
                    block111: {
                        block110: {
                            block112: {
                                lexer.skipWhitespace();
                                ch = lexer.getCurrent();
                                if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                                    while (ch == ',') {
                                        lexer.next();
                                        lexer.skipWhitespace();
                                        ch = lexer.getCurrent();
                                    }
                                }
                                isObjectKey = false;
                                if (ch == '\"') {
                                    key = lexer.scanSymbol(this.symbolTable, '\"');
                                    lexer.skipWhitespace();
                                    ch = lexer.getCurrent();
                                    if (ch != ':') {
                                        throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                                    }
                                } else {
                                    if (ch == '}') {
                                        lexer.next();
                                        lexer.resetStringPosition();
                                        lexer.nextToken();
                                        if (!setContextFlag) {
                                            if (this.context != null && fieldName == this.context.fieldName && object == this.context.object) {
                                                context /* !! */  = this.context;
                                            } else {
                                                contextR = this.setContext(object, fieldName);
                                                if (context /* !! */  == null) {
                                                    context /* !! */  = contextR;
                                                }
                                                setContextFlag = true;
                                            }
                                        }
                                        contextR = object;
                                        return contextR;
                                    }
                                    if (ch == '\'') {
                                        if (!lexer.isEnabled(Feature.AllowSingleQuotes)) {
                                            throw new JSONException("syntax error");
                                        }
                                        key = lexer.scanSymbol(this.symbolTable, '\'');
                                        lexer.skipWhitespace();
                                        ch = lexer.getCurrent();
                                        if (ch != ':') {
                                            throw new JSONException("expect ':' at " + lexer.pos());
                                        }
                                    } else {
                                        if (ch == '\u001a') {
                                            throw new JSONException("syntax error");
                                        }
                                        if (ch == ',') {
                                            throw new JSONException("syntax error");
                                        }
                                        if (ch >= '0' && ch <= '9' || ch == '-') {
                                            lexer.resetStringPosition();
                                            lexer.scanNumber();
                                            try {
                                                key = lexer.token() == 2 ? lexer.integerValue() : lexer.decimalValue(true);
                                                if (lexer.isEnabled(Feature.NonStringKeyAsString) || isJsonObjectMap) {
                                                    key = key.toString();
                                                }
                                            }
                                            catch (NumberFormatException e) {
                                                throw new JSONException("parse number key error" + lexer.info());
                                            }
                                            ch = lexer.getCurrent();
                                            if (ch != ':') {
                                                throw new JSONException("parse number key error" + lexer.info());
                                            }
                                        } else if (ch == '{' || ch == '[') {
                                            try {
                                                if (this.incObjectKeyLevel() > 512) {
                                                    throw new JSONException("object key level > 512");
                                                }
                                            }
                                            catch (NoSuchFieldException e) {
                                                throw new JSONException(e.getMessage());
                                            }
                                            catch (SecurityException e) {
                                                throw new JSONException(e.getMessage());
                                            }
                                            catch (IllegalArgumentException e) {
                                                throw new JSONException(e.getMessage());
                                            }
                                            catch (IllegalAccessException e) {
                                                throw new JSONException(e.getMessage());
                                            }
                                            lexer.nextToken();
                                            key = this.parse();
                                            isObjectKey = true;
                                        } else {
                                            if (!lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                                                throw new JSONException("syntax error");
                                            }
                                            key = lexer.scanSymbolUnQuoted(this.symbolTable);
                                            lexer.skipWhitespace();
                                            ch = lexer.getCurrent();
                                            if (ch != ':') {
                                                throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                                            }
                                        }
                                    }
                                }
                                if (!isObjectKey) {
                                    lexer.next();
                                    lexer.skipWhitespace();
                                }
                                ch = lexer.getCurrent();
                                lexer.resetStringPosition();
                                if (key == JSON.DEFAULT_TYPE_KEY && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                                    typeName = lexer.scanSymbol(this.symbolTable, '\"');
                                    if (lexer.isEnabled(Feature.IgnoreAutoType)) continue;
                                    clazz = null;
                                    if (object != null && object.getClass().getName().equals(typeName)) {
                                        clazz = object.getClass();
                                        break block108;
                                    }
                                    allDigits = true;
                                    break block109;
                                }
                                if (key != "$ref" || context /* !! */  == null || object != null && object.size() != 0 || lexer.isEnabled(Feature.DisableSpecialKeyDetect)) break block111;
                                lexer.nextToken(4);
                                if (lexer.token() != 4) throw new JSONException("illegal ref, " + JSONToken.name((int)lexer.token()));
                                ref = lexer.stringVal();
                                lexer.nextToken(13);
                                if (lexer.token() == 16) {
                                    map.put(key, ref);
                                    continue;
                                }
                                refValue = null;
                                if (!"@".equals(ref)) break block112;
                                if (this.context != null) {
                                    thisContext = this.context;
                                    thisObj = thisContext.object;
                                    if (thisObj instanceof Object[] || thisObj instanceof Collection) {
                                        refValue = thisObj;
                                        break block110;
                                    } else if (thisContext.parent != null) {
                                        refValue = thisContext.parent.object;
                                    }
                                }
                                break block110;
                            }
                            if ("..".equals(ref)) {
                                if (context /* !! */ .object != null) {
                                    refValue = context /* !! */ .object;
                                } else {
                                    this.addResolveTask(new DefaultJSONParser.ResolveTask(context /* !! */ , ref));
                                    this.setResolveStatus(1);
                                }
                            } else if ("$".equals(ref)) {
                                rootContext /* !! */  = context /* !! */ ;
                                while (rootContext /* !! */ .parent != null) {
                                    rootContext /* !! */  = rootContext /* !! */ .parent;
                                }
                                if (rootContext /* !! */ .object != null) {
                                    refValue = rootContext /* !! */ .object;
                                } else {
                                    this.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext /* !! */ , ref));
                                    this.setResolveStatus(1);
                                }
                            } else {
                                this.addResolveTask(new DefaultJSONParser.ResolveTask(context /* !! */ , ref));
                                this.setResolveStatus(1);
                            }
                        }
                        if (lexer.token() != 13) {
                            throw new JSONException("syntax error, " + lexer.info());
                        }
                        lexer.nextToken(16);
                        rootContext = refValue;
                        return rootContext;
                    }
                    if (!setContextFlag) {
                        if (this.context != null && fieldName == this.context.fieldName && object == this.context.object) {
                            context /* !! */  = this.context;
                        } else {
                            contextR = this.setContext(object, fieldName);
                            if (context /* !! */  == null) {
                                context /* !! */  = contextR;
                            }
                            setContextFlag = true;
                        }
                    }
                    if (object.getClass() == JSONObject.class && key == null) {
                        key = "null";
                    }
                    if (ch == '\"') {
                        lexer.scanString();
                        strValue = lexer.stringVal();
                        value /* !! */  = strValue;
                        if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                            iso8601Lexer = new JSONScanner(strValue);
                            if (iso8601Lexer.scanISO8601DateIfMatch()) {
                                value /* !! */  = iso8601Lexer.getCalendar().getTime();
                            }
                            iso8601Lexer.close();
                        }
                        if (!StringUtils.isEmpty((CharSequence)value /* !! */ .toString())) {
                            map.put(key, value /* !! */ );
                        }
                    } else if (ch >= '0' && ch <= '9' || ch == '-') {
                        lexer.scanNumber();
                        value /* !! */  = lexer.token() == 2 ? lexer.integerValue() : lexer.decimalValue(lexer.isEnabled(Feature.UseBigDecimal));
                        map.put(key, value /* !! */ );
                    } else {
                        if (ch == '[') {
                            lexer.nextToken();
                            list = new JSONArray();
                            v0 = parentIsArray = fieldName != null && fieldName.getClass() == Integer.class;
                            if (fieldName == null) {
                                this.setContext(context /* !! */ );
                            }
                            this.parseArray((Collection)list, key);
                            value /* !! */  = lexer.isEnabled(Feature.UseObjectArray) != false ? list.toArray() : list;
                            map.put(key, value /* !! */ );
                            if (lexer.token() == 13) {
                                lexer.nextToken();
                                thisObj = object;
                                return thisObj;
                            }
                            if (lexer.token() != 16) throw new JSONException("syntax error");
                            continue;
                        }
                        if (ch == '{') {
                            lexer.nextToken();
                            v1 = parentIsArray = fieldName != null && fieldName.getClass() == Integer.class;
                            if (lexer.isEnabled(Feature.CustomMapDeserializer)) {
                                mapDeserializer = (MapDeserializer)this.config.getDeserializer(Map.class);
                                input /* !! */  = (lexer.getFeatures() & Feature.OrderedField.mask) != 0 ? mapDeserializer.createMap(Map.class, lexer.getFeatures()) : mapDeserializer.createMap(Map.class);
                            } else {
                                input /* !! */  = new JSONObject(lexer.isEnabled(Feature.OrderedField));
                            }
                            ctxLocal = null;
                            if (!parentIsArray) {
                                ctxLocal = this.setContext(context /* !! */ , input /* !! */ , key);
                            }
                            obj = null;
                            objParsed = false;
                            if (this.fieldTypeResolver != null && (fieldType = this.fieldTypeResolver.resolve((Object)object, resolveFieldName = key != null ? key.toString() : null)) != null) {
                                fieldDeser = this.config.getDeserializer(fieldType);
                                obj = fieldDeser.deserialze((DefaultJSONParser)this, fieldType, key);
                                objParsed = true;
                            }
                            if (!objParsed) {
                                obj = this.parseObject((Map)input /* !! */ , key);
                            }
                            if (ctxLocal != null && input /* !! */  != obj) {
                                ctxLocal.object = object;
                            }
                            if (key != null) {
                                this.checkMapResolve(object, key.toString());
                            }
                            map.put(key, obj);
                            if (parentIsArray) {
                                this.setContext(obj, key);
                            }
                            if (lexer.token() == 13) {
                                lexer.nextToken();
                                this.setContext(context /* !! */ );
                                var17_44 = object;
                                return var17_44;
                            }
                            if (lexer.token() != 16) throw new JSONException("syntax error, " + lexer.tokenName());
                            if (parentIsArray) {
                                this.popContext();
                                continue;
                            }
                            this.setContext(context /* !! */ );
                            continue;
                        }
                        lexer.nextToken();
                        value /* !! */  = this.parse();
                        map.put(key, value /* !! */ );
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            var12_17 = object;
                            return var12_17;
                        }
                        if (lexer.token() != 16) throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                        continue;
                    }
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch == ',') {
                        lexer.next();
                        continue;
                    }
                    if (ch != '}') throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                    lexer.next();
                    lexer.resetStringPosition();
                    lexer.nextToken();
                    this.setContext(value /* !! */ , key);
                    var12_17 = object;
                    return var12_17;
                }
                finally {
                    this.setContext(context /* !! */ );
                }
            }
            for (i = 0; i < typeName.length(); ++i) {
                c = typeName.charAt(i);
                if (c >= '0' && c <= '9') continue;
                allDigits = false;
                break;
            }
            if (!allDigits) {
                clazz = this.config.checkAutoType(typeName, null, lexer.getFeatures());
            }
        }
        if (clazz == null) {
            map.put(JSON.DEFAULT_TYPE_KEY, typeName);
            ** continue;
        }
        lexer.nextToken(16);
        if (lexer.token() == 13) {
            lexer.nextToken(16);
            try {
                instance /* !! */  = null;
                deserializer = this.config.getDeserializer((Type)clazz);
                if (deserializer instanceof JavaBeanDeserializer) {
                    instance /* !! */  = TypeUtils.cast((Object)object, (Class)clazz, (ParserConfig)this.config);
                }
                if (instance /* !! */  == null) {
                    instance /* !! */  = clazz == Cloneable.class ? new HashMap<K, V>() : ("java.util.Collections$EmptyMap".equals(typeName) != false ? Collections.emptyMap() : ("java.util.Collections$UnmodifiableMap".equals(typeName) != false ? Collections.unmodifiableMap(new HashMap<K, V>()) : clazz.newInstance()));
                }
                c = instance /* !! */ ;
                return c;
            }
            catch (Exception e) {
                throw new JSONException("create instance error", (Throwable)e);
            }
        }
        this.setResolveStatus(2);
        if (this.context != null && fieldName != null && !(fieldName instanceof Integer) && !(this.context.fieldName instanceof Integer)) {
            this.popContext();
        }
        if (object.size() > 0) {
            newObj = TypeUtils.cast((Object)object, (Class)clazz, (ParserConfig)this.config);
            this.setResolveStatus(0);
            this.parseObject(newObj);
            deserializer = newObj;
            return deserializer;
        }
        deserializer = this.config.getDeserializer((Type)clazz);
        deserClass = deserializer.getClass();
        if (JavaBeanDeserializer.class.isAssignableFrom(deserClass) && deserClass != JavaBeanDeserializer.class && deserClass != ThrowableDeserializer.class) {
            this.setResolveStatus(0);
        } else if (deserializer instanceof MapDeserializer) {
            this.setResolveStatus(0);
        }
        var16_43 = obj = deserializer.deserialze((DefaultJSONParser)this, (Type)clazz, fieldName);
        return var16_43;
    }
}

