/*
 * Decompiled with CFR 0.152.
 */
package com.product.fastjson.serializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.product.fastjson.serializer.Jdk8DateSerializer;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

public class Jdk8DateDeserializer
extends Jdk8DateSerializer
implements ObjectDeserializer {
    public static final Jdk8DateDeserializer instance = new Jdk8DateDeserializer();

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        String format = null;
        if (lexer.token() == 4) {
            String text = lexer.stringVal();
            lexer.nextToken();
            DateTimeFormatter formatter = null;
            if (format != null) {
                formatter = "yyyy-MM-dd HH:mm:ss".equals(format) ? defaultFormatter : DateTimeFormatter.ofPattern(format);
            }
            if ("".equals(text)) {
                return null;
            }
            if (type == LocalDateTime.class) {
                LocalDateTime localDateTime;
                if (text.length() == 10 || text.length() == 8) {
                    LocalDate localDate = this.parseLocalDate(text, format, formatter);
                    localDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
                } else {
                    localDateTime = this.parseDateTime(text, defaultFormatter);
                }
                return (T)localDateTime;
            }
            if (type == LocalDate.class) {
                LocalDate localDate;
                if (text.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(text);
                    localDate = LocalDate.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth());
                } else {
                    localDate = this.parseLocalDate(text, format, formatter);
                }
                return (T)localDate;
            }
            if (type == LocalTime.class) {
                LocalTime localTime;
                if (text.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(text);
                    localTime = LocalTime.of(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano());
                } else {
                    boolean digit = true;
                    for (int i = 0; i < text.length(); ++i) {
                        char ch = text.charAt(i);
                        if (ch >= '0' && ch <= '9') continue;
                        digit = false;
                        break;
                    }
                    if (digit && text.length() > 8 && text.length() < 19) {
                        long epochMillis = Long.parseLong(text);
                        localTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault()).toLocalTime();
                    } else {
                        localTime = LocalTime.parse(text);
                    }
                }
                return (T)localTime;
            }
            if (type == ZonedDateTime.class) {
                JSONScanner s;
                boolean match;
                if (formatter == defaultFormatter) {
                    formatter = ISO_FIXED_FORMAT;
                }
                if (formatter == null && text.length() <= 19 && (match = (s = new JSONScanner(text)).scanISO8601DateIfMatch(false))) {
                    Date date = s.getCalendar().getTime();
                    return (T)ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                }
                ZonedDateTime zonedDateTime = this.parseZonedDateTime(text, formatter);
                return (T)zonedDateTime;
            }
            if (type == OffsetDateTime.class) {
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(text);
                return (T)offsetDateTime;
            }
            if (type == OffsetTime.class) {
                OffsetTime offsetTime = OffsetTime.parse(text);
                return (T)offsetTime;
            }
            if (type == ZoneId.class) {
                ZoneId offsetTime = ZoneId.of(text);
                return (T)offsetTime;
            }
            if (type == Period.class) {
                Period period = Period.parse(text);
                return (T)period;
            }
            if (type == Duration.class) {
                Duration duration = Duration.parse(text);
                return (T)duration;
            }
            if (type == Instant.class) {
                boolean digit = true;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch >= '0' && ch <= '9') continue;
                    digit = false;
                    break;
                }
                if (digit && text.length() > 8 && text.length() < 19) {
                    long epochMillis = Long.parseLong(text);
                    return (T)Instant.ofEpochMilli(epochMillis);
                }
                Instant instant = Instant.parse(text);
                return (T)instant;
            }
        } else {
            if (lexer.token() == 2) {
                long millis = lexer.longValue();
                lexer.nextToken();
                String text = null;
                if (null != format) {
                    if ("unixtime".equals(format)) {
                        millis *= 1000L;
                    } else if ("yyyyMMddHHmmss".equals(format)) {
                        int yyyy = (int)(millis / 10000000000L);
                        int MM = (int)(millis / 100000000L % 100L);
                        int dd = (int)(millis / 1000000L % 100L);
                        int HH = (int)(millis / 10000L % 100L);
                        int mm = (int)(millis / 100L % 100L);
                        int ss = (int)(millis % 100L);
                        if (type == LocalDateTime.class) {
                            text = LocalDateTime.of(yyyy, MM, dd, HH, mm, ss).format(defaultFormatter);
                            return (T)this.parseDateTime(text, defaultFormatter);
                        }
                    }
                }
                if (type == LocalDateTime.class) {
                    text = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).format(defaultFormatter);
                    return (T)this.parseDateTime(text, defaultFormatter);
                }
                if (type == LocalDate.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).toLocalDate();
                }
                if (type == LocalTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).toLocalTime();
                }
                if (type == ZonedDateTime.class) {
                    return (T)ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
                }
                if (type == Instant.class) {
                    return (T)Instant.ofEpochMilli(millis);
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    protected LocalDateTime parseDateTime(String text, DateTimeFormatter formatter) {
        if (formatter == null) {
            char c4;
            if (text.length() == 19) {
                c4 = text.charAt(4);
                c7 = text.charAt(7);
                c10 = text.charAt(10);
                c13 = text.charAt(13);
                c16 = text.charAt(16);
                if (c13 == ':' && c16 == ':') {
                    if (c4 == '-' && c7 == '-') {
                        if (c10 == 'T') {
                            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                        } else if (c10 == ' ') {
                            formatter = defaultFormatter;
                        }
                    } else if (c4 == '/' && c7 == '/') {
                        formatter = formatter_dt19_tw;
                    } else {
                        char c0 = text.charAt(0);
                        char c1 = text.charAt(1);
                        char c2 = text.charAt(2);
                        char c3 = text.charAt(3);
                        char c5 = text.charAt(5);
                        if (c2 == '/' && c5 == '/') {
                            int v0 = (c0 - 48) * 10 + (c1 - 48);
                            int v1 = (c3 - 48) * 10 + (c4 - 48);
                            if (v0 > 12) {
                                formatter = formatter_dt19_eur;
                            } else if (v1 > 12) {
                                formatter = formatter_dt19_us;
                            } else {
                                String country = Locale.getDefault().getCountry();
                                if (country.equals("US")) {
                                    formatter = formatter_dt19_us;
                                } else if (country.equals("BR") || country.equals("AU")) {
                                    formatter = formatter_dt19_eur;
                                }
                            }
                        } else if (c2 == '.' && c5 == '.') {
                            formatter = formatter_dt19_de;
                        } else if (c2 == '-' && c5 == '-') {
                            formatter = formatter_dt19_in;
                        }
                    }
                }
            } else if (text.length() == 23) {
                c4 = text.charAt(4);
                c7 = text.charAt(7);
                c10 = text.charAt(10);
                c13 = text.charAt(13);
                c16 = text.charAt(16);
                char c19 = text.charAt(19);
                if (c13 == ':' && c16 == ':' && c4 == '-' && c7 == '-' && c10 == ' ' && c19 == '.') {
                    formatter = defaultFormatter_23;
                }
            }
            if (text.length() >= 17) {
                c4 = text.charAt(4);
                if (c4 == '\u5e74') {
                    formatter = text.charAt(text.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c4 == '\ub144') {
                    formatter = formatter_dt19_kr;
                }
            }
        }
        if (formatter == null) {
            JSONScanner dateScanner = new JSONScanner(text);
            if (dateScanner.scanISO8601DateIfMatch(false)) {
                Instant instant = dateScanner.getCalendar().toInstant();
                return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            }
            boolean digit = true;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                digit = false;
                break;
            }
            if (digit && text.length() > 8 && text.length() < 19) {
                long epochMillis = Long.parseLong(text);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault());
            }
        }
        return formatter == null ? LocalDateTime.parse(text) : LocalDateTime.parse(text, formatter);
    }

    protected LocalDate parseLocalDate(String text, String format, DateTimeFormatter formatter) {
        if (formatter == null) {
            char c4;
            if (text.length() == 8) {
                formatter = formatter_d8;
            }
            if (text.length() == 10) {
                c4 = text.charAt(4);
                char c7 = text.charAt(7);
                if (c4 == '/' && c7 == '/') {
                    formatter = formatter_d10_tw;
                }
                char c0 = text.charAt(0);
                char c1 = text.charAt(1);
                char c2 = text.charAt(2);
                char c3 = text.charAt(3);
                char c5 = text.charAt(5);
                if (c2 == '/' && c5 == '/') {
                    int v0 = (c0 - 48) * 10 + (c1 - 48);
                    int v1 = (c3 - 48) * 10 + (c4 - 48);
                    if (v0 > 12) {
                        formatter = formatter_d10_eur;
                    } else if (v1 > 12) {
                        formatter = formatter_d10_us;
                    } else {
                        String country = Locale.getDefault().getCountry();
                        if (country.equals("US")) {
                            formatter = formatter_d10_us;
                        } else if (country.equals("BR") || country.equals("AU")) {
                            formatter = formatter_d10_eur;
                        }
                    }
                } else if (c2 == '.' && c5 == '.') {
                    formatter = formatter_d10_de;
                } else if (c2 == '-' && c5 == '-') {
                    formatter = formatter_d10_in;
                }
            }
            if (text.length() >= 9) {
                c4 = text.charAt(4);
                if (c4 == '\u5e74') {
                    formatter = formatter_d10_cn;
                } else if (c4 == '\ub144') {
                    formatter = formatter_d10_kr;
                }
            }
            boolean digit = true;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                digit = false;
                break;
            }
            if (digit && text.length() > 8 && text.length() < 19) {
                long epochMillis = Long.parseLong(text);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault()).toLocalDate();
            }
        }
        return formatter == null ? LocalDate.parse(text) : LocalDate.parse(text, formatter);
    }

    protected ZonedDateTime parseZonedDateTime(String text, DateTimeFormatter formatter) {
        if (formatter == null) {
            char c4;
            if (text.length() == 19) {
                c4 = text.charAt(4);
                char c7 = text.charAt(7);
                char c10 = text.charAt(10);
                char c13 = text.charAt(13);
                char c16 = text.charAt(16);
                if (c13 == ':' && c16 == ':') {
                    if (c4 == '-' && c7 == '-') {
                        if (c10 == 'T') {
                            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                        } else if (c10 == ' ') {
                            formatter = defaultFormatter;
                        }
                    } else if (c4 == '/' && c7 == '/') {
                        formatter = formatter_dt19_tw;
                    } else {
                        char c0 = text.charAt(0);
                        char c1 = text.charAt(1);
                        char c2 = text.charAt(2);
                        char c3 = text.charAt(3);
                        char c5 = text.charAt(5);
                        if (c2 == '/' && c5 == '/') {
                            int v0 = (c0 - 48) * 10 + (c1 - 48);
                            int v1 = (c3 - 48) * 10 + (c4 - 48);
                            if (v0 > 12) {
                                formatter = formatter_dt19_eur;
                            } else if (v1 > 12) {
                                formatter = formatter_dt19_us;
                            } else {
                                String country = Locale.getDefault().getCountry();
                                if (country.equals("US")) {
                                    formatter = formatter_dt19_us;
                                } else if (country.equals("BR") || country.equals("AU")) {
                                    formatter = formatter_dt19_eur;
                                }
                            }
                        } else if (c2 == '.' && c5 == '.') {
                            formatter = formatter_dt19_de;
                        } else if (c2 == '-' && c5 == '-') {
                            formatter = formatter_dt19_in;
                        }
                    }
                }
            }
            if (text.length() >= 17) {
                c4 = text.charAt(4);
                if (c4 == '\u5e74') {
                    formatter = text.charAt(text.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c4 == '\ub144') {
                    formatter = formatter_dt19_kr;
                }
            }
            boolean digit = true;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                digit = false;
                break;
            }
            if (digit && text.length() > 8 && text.length() < 19) {
                long epochMillis = Long.parseLong(text);
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault());
            }
        }
        return formatter == null ? ZonedDateTime.parse(text) : ZonedDateTime.parse(text, formatter);
    }

    public int getFastMatchToken() {
        return 4;
    }
}

