/*
 * Decompiled with CFR 0.152.
 */
package com.product.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;

public class Jdk8DateSerializer
implements ObjectSerializer {
    public static final Jdk8DateSerializer instance = new Jdk8DateSerializer();
    protected static final String defaultPatttern = "yyyy-MM-dd HH:mm:ss";
    protected static final DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected static final DateTimeFormatter defaultFormatter_23 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final DateTimeFormatter formatter_dt19_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    protected static final DateTimeFormatter formatter_dt19_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:mm:ss");
    protected static final DateTimeFormatter formatter_dt19_cn_1 = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2");
    protected static final DateTimeFormatter formatter_dt19_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c HH:mm:ss");
    protected static final DateTimeFormatter formatter_dt19_us = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
    protected static final DateTimeFormatter formatter_dt19_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    protected static final DateTimeFormatter formatter_dt19_de = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    protected static final DateTimeFormatter formatter_dt19_in = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    protected static final DateTimeFormatter formatter_d8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    protected static final DateTimeFormatter formatter_d10_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    protected static final DateTimeFormatter formatter_d10_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5");
    protected static final DateTimeFormatter formatter_d10_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c");
    protected static final DateTimeFormatter formatter_d10_us = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    protected static final DateTimeFormatter formatter_d10_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    protected static final DateTimeFormatter formatter_d10_de = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    protected static final DateTimeFormatter formatter_d10_in = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    protected static final DateTimeFormatter ISO_FIXED_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    protected static final String formatter_iso8601_pattern = "yyyy-MM-dd HH:mm:ss";
    protected static final String formatter_iso8601_pattern_23 = "yyyy-MM-dd HH:mm:ss.SSS";
    protected static final String formatter_iso8601_pattern_29 = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    protected static final DateTimeFormatter formatter_iso8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
        } else {
            if (fieldType == null) {
                fieldType = object.getClass();
            }
            if (fieldType == LocalDateTime.class) {
                LocalDateTime dateTime = (LocalDateTime)object;
                String format = serializer.getDateFormatPattern();
                if (format == null) {
                    int nano;
                    format = serializer.isEnabled(SerializerFeature.UseISO8601DateFormat) ? "yyyy-MM-dd HH:mm:ss" : ((nano = dateTime.getNano()) == 0 ? "yyyy-MM-dd HH:mm:ss" : (nano % 1000000 == 0 ? formatter_iso8601_pattern_23 : formatter_iso8601_pattern_29));
                }
                if (format != null) {
                    this.write(out, dateTime, format);
                } else if (out.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
                    this.write(out, dateTime, JSON.DEFFAULT_DATE_FORMAT);
                } else {
                    out.writeLong(dateTime.atZone(TimeZone.getDefault().toZoneId()).toInstant().toEpochMilli());
                }
            } else {
                out.writeString(object.toString());
            }
        }
    }

    private void write(SerializeWriter out, TemporalAccessor object, String format) {
        Instant instant;
        if ("unixtime".equals(format)) {
            instant = null;
            if (object instanceof ChronoZonedDateTime) {
                long seconds = ((ChronoZonedDateTime)object).toEpochSecond();
                out.writeInt((int)seconds);
                return;
            }
            if (object instanceof LocalDateTime) {
                long seconds = ((LocalDateTime)object).atZone(ZoneId.systemDefault()).toEpochSecond();
                out.writeInt((int)seconds);
                return;
            }
        }
        if ("millis".equals(format)) {
            instant = null;
            if (object instanceof ChronoZonedDateTime) {
                instant = ((ChronoZonedDateTime)object).toInstant();
            } else if (object instanceof LocalDateTime) {
                instant = ((LocalDateTime)object).atZone(ZoneId.systemDefault()).toInstant();
            }
            if (instant != null) {
                long millis = instant.toEpochMilli();
                out.writeLong(millis);
                return;
            }
        }
        DateTimeFormatter formatter = format == "yyyy-MM-dd HH:mm:ss" ? formatter_iso8601 : DateTimeFormatter.ofPattern(format);
        String text = formatter.format(object);
        out.writeString(text);
    }
}

